/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.salvage.Salvage;
import com.gmail.nossr50.skills.salvage.SalvageManager;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.text.TextComponentFactory;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;

public class SalvageCommand
extends SkillCommand {
    private boolean canScrapCollector;
    private boolean canArcaneSalvage;

    public SalvageCommand() {
        super(PrimarySkillType.SALVAGE);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue) {
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canScrapCollector = Permissions.canUseSubSkill(player, SubSkillType.SALVAGE_SCRAP_COLLECTOR);
        this.canArcaneSalvage = Permissions.canUseSubSkill(player, SubSkillType.SALVAGE_ARCANE_SALVAGE);
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        SalvageManager salvageManager = this.mmoPlayer.getSalvageManager();
        if (this.canScrapCollector) {
            messages.add(this.getStatMessage(false, true, SubSkillType.SALVAGE_SCRAP_COLLECTOR, String.valueOf(SalvageManager.getSalvageLimit(player)), RankUtils.getHighestRankStr(SubSkillType.SALVAGE_SCRAP_COLLECTOR)));
        }
        if (this.canArcaneSalvage) {
            messages.add(this.getStatMessage(false, true, SubSkillType.SALVAGE_ARCANE_SALVAGE, String.valueOf(salvageManager.getArcaneSalvageRank()), String.valueOf(RankUtils.getHighestRank(SubSkillType.SALVAGE_ARCANE_SALVAGE))));
            if (Salvage.arcaneSalvageEnchantLoss) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Salvage.Arcane.ExtractFull"), this.percent.format(salvageManager.getExtractFullEnchantChance() / 100.0)));
            }
            if (Salvage.arcaneSalvageDowngrades) {
                messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Salvage.Arcane.ExtractPartial"), this.percent.format(salvageManager.getExtractPartialEnchantChance() / 100.0)));
            }
        }
        return messages;
    }

    @Override
    protected List<Component> getTextComponents(Player player) {
        ArrayList<Component> textComponents = new ArrayList<Component>();
        TextComponentFactory.getSubSkillTextComponents(player, textComponents, PrimarySkillType.SALVAGE);
        return textComponents;
    }
}

