/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.items;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.CancellableRunnable;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.skills.SkillUtils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class TeleportationWarmup
extends CancellableRunnable {
    private final McMMOPlayer mmoPlayer;
    private final McMMOPlayer mcMMOTarget;

    public TeleportationWarmup(McMMOPlayer mmoPlayer, McMMOPlayer mcMMOTarget) {
        this.mmoPlayer = mmoPlayer;
        this.mcMMOTarget = mcMMOTarget;
    }

    @Override
    public void run() {
        int timeRemaining;
        Player teleportingPlayer = this.mmoPlayer.getPlayer();
        Player targetPlayer = this.mcMMOTarget.getPlayer();
        Location previousLocation = this.mmoPlayer.getTeleportCommenceLocation();
        Location newLocation = this.mmoPlayer.getPlayer().getLocation();
        long recentlyHurt = this.mmoPlayer.getRecentlyHurt();
        this.mmoPlayer.setTeleportCommenceLocation(null);
        if (!mcMMO.p.getPartyManager().inSameParty(teleportingPlayer, targetPlayer)) {
            teleportingPlayer.sendMessage(LocaleLoader.getString("Party.NotInYourParty", targetPlayer.getName()));
            return;
        }
        if (newLocation.distanceSquared(previousLocation) > 1.0) {
            teleportingPlayer.sendMessage(LocaleLoader.getString("Teleport.Cancelled"));
            return;
        }
        int hurtCooldown = mcMMO.p.getGeneralConfig().getPTPCommandRecentlyHurtCooldown();
        if (hurtCooldown > 0 && (timeRemaining = SkillUtils.calculateTimeLeft(recentlyHurt * 1000L, hurtCooldown, teleportingPlayer)) > 0) {
            teleportingPlayer.sendMessage(LocaleLoader.getString("Item.Injured.Wait", timeRemaining));
            return;
        }
        if (mcMMO.p.getGeneralConfig().getPTPCommandWorldPermissions()) {
            World targetWorld = targetPlayer.getWorld();
            World playerWorld = teleportingPlayer.getWorld();
            if (!Permissions.partyTeleportAllWorlds((Permissible)teleportingPlayer)) {
                if (!Permissions.partyTeleportWorld((Permissible)targetPlayer, targetWorld)) {
                    teleportingPlayer.sendMessage(LocaleLoader.getString("Commands.ptp.NoWorldPermissions", targetWorld.getName()));
                    return;
                }
                if (targetWorld != playerWorld && !Permissions.partyTeleportWorld((Permissible)teleportingPlayer, targetWorld)) {
                    teleportingPlayer.sendMessage(LocaleLoader.getString("Commands.ptp.NoWorldPermissions", targetWorld.getName()));
                    return;
                }
            }
        }
        EventUtils.handlePartyTeleportEvent(teleportingPlayer, targetPlayer);
    }
}

