/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.swords;

import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.meta.RuptureTaskMeta;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.skills.RuptureTask;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.swords.Swords;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import java.util.function.Consumer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class SwordsManager
extends SkillManager {
    public SwordsManager(McMMOPlayer mmoPlayer) {
        super(mmoPlayer, PrimarySkillType.SWORDS);
    }

    public boolean canActivateAbility() {
        return this.mmoPlayer.getToolPreparationMode(ToolType.SWORD) && Permissions.serratedStrikes((Permissible)this.getPlayer());
    }

    public boolean canUseStab() {
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.SWORDS_STAB) && RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.SWORDS_STAB);
    }

    public boolean canUseRupture() {
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.SWORDS_RUPTURE) && RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.SWORDS_RUPTURE);
    }

    public boolean canUseCounterAttack(Entity target) {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.SWORDS_COUNTER_ATTACK)) {
            return false;
        }
        return target instanceof LivingEntity && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.SWORDS_COUNTER_ATTACK);
    }

    public boolean canUseSerratedStrike() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.SWORDS_SERRATED_STRIKES)) {
            return false;
        }
        return this.mmoPlayer.getAbilityMode(SuperAbilityType.SERRATED_STRIKES);
    }

    public void processRupture(@NotNull LivingEntity target) {
        if (!this.canUseRupture()) {
            return;
        }
        if (target.hasMetadata("mcmmo_rupture")) {
            RuptureTaskMeta ruptureTaskMeta = (RuptureTaskMeta)((Object)target.getMetadata("mcmmo_rupture").get(0));
            if (this.mmoPlayer.isDebugMode()) {
                this.mmoPlayer.getPlayer().sendMessage("Rupture task ongoing for target " + String.valueOf(target));
                this.mmoPlayer.getPlayer().sendMessage(ruptureTaskMeta.getRuptureTimerTask().toString());
            }
            ruptureTaskMeta.getRuptureTimerTask().refreshRupture();
            return;
        }
        double ruptureOdds = mcMMO.p.getAdvancedConfig().getRuptureChanceToApplyOnHit(this.getRuptureRank()) * this.mmoPlayer.getAttackStrength();
        if (ProbabilityUtil.isStaticSkillRNGSuccessful(PrimarySkillType.SWORDS, this.mmoPlayer, ruptureOdds)) {
            if (target instanceof Player) {
                Player defender = (Player)target;
                if (defender.isBlocking()) {
                    return;
                }
                if (NotificationManager.doesPlayerUseNotifications(defender)) {
                    NotificationManager.sendPlayerInformation(defender, NotificationType.SUBSKILL_MESSAGE, "Swords.Combat.Bleeding.Started");
                }
            }
            RuptureTask ruptureTask = new RuptureTask(this.mmoPlayer, target, mcMMO.p.getAdvancedConfig().getRuptureTickDamage(target instanceof Player, this.getRuptureRank()));
            RuptureTaskMeta ruptureTaskMeta = new RuptureTaskMeta((Plugin)mcMMO.p, ruptureTask);
            mcMMO.p.getFoliaLib().getScheduler().runAtEntityTimer((Entity)target, (Consumer)ruptureTask, 1L, 1L);
            target.setMetadata("mcmmo_rupture", (MetadataValue)ruptureTaskMeta);
        }
    }

    private int getRuptureRank() {
        return RankUtils.getRank(this.getPlayer(), SubSkillType.SWORDS_RUPTURE);
    }

    public double getStabDamage() {
        int rank = RankUtils.getRank(this.getPlayer(), SubSkillType.SWORDS_STAB);
        if (rank > 0) {
            double baseDamage = mcMMO.p.getAdvancedConfig().getStabBaseDamage();
            double rankMultiplier = mcMMO.p.getAdvancedConfig().getStabPerRankMultiplier();
            return baseDamage + (double)rank * rankMultiplier;
        }
        return 0.0;
    }

    public void counterAttackChecks(@NotNull LivingEntity attacker, double damage) {
        if (ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.SWORDS_COUNTER_ATTACK, this.mmoPlayer)) {
            CombatUtils.safeDealDamage(attacker, damage / Swords.counterAttackModifier, (Entity)this.getPlayer());
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE, "Swords.Combat.Countered");
            if (attacker instanceof Player) {
                NotificationManager.sendPlayerInformation((Player)attacker, NotificationType.SUBSKILL_MESSAGE, "Swords.Combat.Counter.Hit");
            }
        }
    }

    public void serratedStrikes(@NotNull LivingEntity target, double damage) {
        CombatUtils.applyAbilityAoE(this.getPlayer(), target, damage / Swords.serratedStrikesModifier, this.skill);
    }
}

