/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands;

import com.gmail.nossr50.commands.party.PartySubcommandType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Permissions;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class McmmoCommand
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        switch (args.length) {
            case 0: {
                if (!Permissions.mcmmoDescription((Permissible)sender)) {
                    sender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                String description = LocaleLoader.getString("mcMMO.Description");
                String[] mcSplit = description.split(",");
                sender.sendMessage(mcSplit);
                sender.sendMessage(LocaleLoader.getString("mcMMO.Description.FormerDevs"));
                if (mcMMO.p.getGeneralConfig().getDonateMessageEnabled()) {
                    sender.sendMessage(LocaleLoader.getString("MOTD.Donate"));
                    sender.sendMessage(String.valueOf(ChatColor.GOLD) + " - " + String.valueOf(ChatColor.GREEN) + "nossr50@gmail.com" + String.valueOf(ChatColor.GOLD) + " Paypal");
                }
                if (Permissions.showversion((Permissible)sender)) {
                    sender.sendMessage(LocaleLoader.getString("MOTD.Version", mcMMO.p.getDescription().getVersion()));
                }
                return true;
            }
            case 1: {
                if (args[0].equalsIgnoreCase("?") || args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("commands")) {
                    if (!Permissions.mcmmoHelp((Permissible)sender)) {
                        sender.sendMessage(command.getPermissionMessage());
                        return true;
                    }
                    sender.sendMessage(LocaleLoader.getString("Commands.mcc.Header"));
                    this.displayGeneralCommands(sender);
                    this.displayOtherCommands(sender);
                    this.displayPartyCommands(sender);
                }
                return true;
            }
        }
        return false;
    }

    private void displayGeneralCommands(CommandSender sender) {
        sender.sendMessage(LocaleLoader.getString("Commands.Stats"));
        sender.sendMessage(LocaleLoader.getString("Commands.SkillInfo"));
        sender.sendMessage(LocaleLoader.getString("Commands.Leaderboards"));
        if (Permissions.inspect((Permissible)sender)) {
            sender.sendMessage(LocaleLoader.getString("Commands.Inspect"));
        }
        if (Permissions.mcability((Permissible)sender)) {
            sender.sendMessage(LocaleLoader.getString("Commands.ToggleAbility"));
        }
    }

    private void displayOtherCommands(CommandSender sender) {
        if (!(Permissions.skillreset((Permissible)sender) || Permissions.mmoedit((Permissible)sender) || Permissions.adminChat((Permissible)sender) || Permissions.mcgod((Permissible)sender))) {
            return;
        }
        sender.sendMessage(LocaleLoader.getString("Commands.Other"));
        if (Permissions.skillreset((Permissible)sender)) {
            sender.sendMessage(LocaleLoader.getString("Commands.Reset"));
        }
        if (Permissions.mmoedit((Permissible)sender)) {
            sender.sendMessage(LocaleLoader.getString("Commands.mmoedit"));
        }
        if (Permissions.adminChat((Permissible)sender)) {
            sender.sendMessage(LocaleLoader.getString("Commands.AdminToggle"));
        }
        if (Permissions.mcgod((Permissible)sender)) {
            sender.sendMessage(LocaleLoader.getString("Commands.mcgod"));
        }
    }

    private void displayPartyCommands(CommandSender sender) {
        if (Permissions.party((Permissible)sender)) {
            sender.sendMessage(LocaleLoader.getString("Commands.Party.Commands"));
            sender.sendMessage(LocaleLoader.getString("Commands.Party1"));
            sender.sendMessage(LocaleLoader.getString("Commands.Party2"));
            sender.sendMessage(LocaleLoader.getString("Commands.Party.Quit"));
            if (Permissions.partyChat((Permissible)sender)) {
                sender.sendMessage(LocaleLoader.getString("Commands.Party.Toggle"));
            }
            sender.sendMessage(LocaleLoader.getString("Commands.Party.Invite"));
            sender.sendMessage(LocaleLoader.getString("Commands.Party.Accept"));
            if (Permissions.partySubcommand((Permissible)sender, PartySubcommandType.TELEPORT)) {
                sender.sendMessage(LocaleLoader.getString("Commands.Party.Teleport"));
            }
        }
    }
}

