/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.skills.salvage;

import com.gmail.nossr50.config.skills.salvage.SalvageConfig;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.salvage.salvageables.Salvageable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class SalvageConfigManager {
    public static final String SALVAGE_VANILLA_YML = "salvage.vanilla.yml";
    private final List<Salvageable> salvageables = new ArrayList<Salvageable>();

    public SalvageConfigManager(mcMMO plugin) {
        Pattern pattern = Pattern.compile("salvage\\.(?:.+)\\.yml");
        File dataFolder = plugin.getDataFolder();
        SalvageConfig mainSalvageConfig = new SalvageConfig(SALVAGE_VANILLA_YML);
        this.salvageables.addAll(mainSalvageConfig.getLoadedSalvageables());
        for (String fileName : dataFolder.list()) {
            File file;
            if (fileName.equals(SALVAGE_VANILLA_YML) || !pattern.matcher(fileName).matches() || (file = new File(dataFolder, fileName)).isDirectory()) continue;
            SalvageConfig salvageConfig = new SalvageConfig(fileName);
            this.salvageables.addAll(salvageConfig.getLoadedSalvageables());
        }
    }

    public List<Salvageable> getLoadedSalvageables() {
        return new ArrayList<Salvageable>(this.salvageables);
    }
}

