/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.api;

import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.skills.SkillTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SkillAPI {
    private SkillAPI() {
    }

    public static List<String> getSkills() {
        return SkillAPI.getListFromEnum(Arrays.asList(PrimarySkillType.values()));
    }

    public static List<String> getNonChildSkills() {
        return SkillAPI.getListFromEnum(SkillTools.NON_CHILD_SKILLS);
    }

    public static List<String> getChildSkills() {
        return SkillAPI.getListFromEnum(mcMMO.p.getSkillTools().CHILD_SKILLS);
    }

    public static List<String> getCombatSkills() {
        return SkillAPI.getListFromEnum(mcMMO.p.getSkillTools().COMBAT_SKILLS);
    }

    public static List<String> getGatheringSkills() {
        return SkillAPI.getListFromEnum(mcMMO.p.getSkillTools().GATHERING_SKILLS);
    }

    public static List<String> getMiscSkills() {
        return SkillAPI.getListFromEnum(mcMMO.p.getSkillTools().MISC_SKILLS);
    }

    private static List<String> getListFromEnum(List<PrimarySkillType> skillsTypes) {
        ArrayList<String> skills = new ArrayList<String>();
        for (PrimarySkillType primarySkillType : skillsTypes) {
            skills.add(primarySkillType.name());
        }
        return skills;
    }
}

