/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.chat.mailer;

import com.gmail.nossr50.chat.author.Author;
import com.gmail.nossr50.chat.mailer.AbstractChatMailer;
import com.gmail.nossr50.chat.message.ChatMessage;
import com.gmail.nossr50.chat.message.PartyChatMessage;
import com.gmail.nossr50.datatypes.chat.ChatChannel;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.events.chat.McMMOPartyChatEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.mcmmo.kyori.adventure.audience.Audience;
import com.gmail.nossr50.mcmmo.kyori.adventure.text.TextComponent;
import com.gmail.nossr50.util.text.TextUtils;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PartyChatMailer
extends AbstractChatMailer {
    public PartyChatMailer(@NotNull Plugin pluginRef) {
        super(pluginRef);
    }

    public void processChatMessage(@NotNull Author author, @NotNull String rawString, @NotNull Party party, boolean isAsync, boolean canColor, boolean isLeader) {
        PartyChatMessage chatMessage = new PartyChatMessage(this.pluginRef, author, this.constructPartyAudience(party), rawString, this.addStyle(author, rawString, canColor, isLeader), party);
        McMMOPartyChatEvent chatEvent = new McMMOPartyChatEvent(this.pluginRef, chatMessage, party, isAsync);
        Bukkit.getPluginManager().callEvent((Event)chatEvent);
        if (!chatEvent.isCancelled()) {
            this.sendMail(chatMessage);
        }
    }

    @NotNull
    public Audience constructPartyAudience(@NotNull Party party) {
        return mcMMO.getAudiences().filter(party.getSamePartyPredicate());
    }

    @NotNull
    public TextComponent addStyle(@NotNull Author author, @NotNull String message, boolean canColor, boolean isLeader) {
        if (canColor) {
            if (isLeader) {
                return LocaleLoader.getTextComponent("Chat.Style.Party.Leader", author.getAuthoredName(ChatChannel.PARTY), message);
            }
            return LocaleLoader.getTextComponent("Chat.Style.Party", author.getAuthoredName(ChatChannel.PARTY), message);
        }
        if (isLeader) {
            return TextUtils.ofLegacyTextRaw(LocaleLoader.getString("Chat.Style.Party.Leader", author.getAuthoredName(ChatChannel.PARTY), message));
        }
        return TextUtils.ofLegacyTextRaw(LocaleLoader.getString("Chat.Style.Party", author.getAuthoredName(ChatChannel.PARTY), message));
    }

    @Override
    public void sendMail(@NotNull ChatMessage chatMessage) {
        chatMessage.sendMessage();
    }
}

