/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.player;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.experience.ExperienceBarManager;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.text.StringUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPBarCommand
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender instanceof Player) {
            McMMOPlayer mmoPlayer = UserManager.getPlayer((Player)sender);
            if (mmoPlayer == null) {
                NotificationManager.sendPlayerInformationChatOnlyPrefixed(mmoPlayer.getPlayer(), "Profile.PendingLoad", new String[0]);
                return false;
            }
            if (args.length == 0) {
                return false;
            }
            if (args.length < 2) {
                String option = args[0];
                if (option.equalsIgnoreCase(ExperienceBarManager.XPBarSettingTarget.RESET.toString())) {
                    mmoPlayer.getExperienceBarManager().xpBarSettingToggle(ExperienceBarManager.XPBarSettingTarget.RESET, null);
                    return true;
                }
                if (option.equalsIgnoreCase(ExperienceBarManager.XPBarSettingTarget.DISABLE.toString())) {
                    mmoPlayer.getExperienceBarManager().disableAllBars();
                    return true;
                }
                return false;
            }
            if (args.length == 2) {
                String skillName = args[1];
                if (SkillUtils.isSkill(skillName)) {
                    PrimarySkillType targetSkill = mcMMO.p.getSkillTools().matchSkill(skillName);
                    String option = args[0].toLowerCase();
                    ExperienceBarManager.XPBarSettingTarget settingTarget = this.getSettingTarget(option);
                    if (settingTarget != null && settingTarget != ExperienceBarManager.XPBarSettingTarget.RESET) {
                        mmoPlayer.getExperienceBarManager().xpBarSettingToggle(settingTarget, targetSkill);
                        return true;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Nullable
    private ExperienceBarManager.XPBarSettingTarget getSettingTarget(String string) {
        switch (string.toLowerCase()) {
            case "hide": {
                return ExperienceBarManager.XPBarSettingTarget.HIDE;
            }
            case "show": {
                return ExperienceBarManager.XPBarSettingTarget.SHOW;
            }
            case "reset": {
                return ExperienceBarManager.XPBarSettingTarget.RESET;
            }
            case "disable": {
                return ExperienceBarManager.XPBarSettingTarget.DISABLE;
            }
        }
        return null;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        switch (args.length) {
            case 1: {
                ArrayList<String> options = new ArrayList<String>();
                for (ExperienceBarManager.XPBarSettingTarget settingTarget : ExperienceBarManager.XPBarSettingTarget.values()) {
                    options.add(StringUtils.getCapitalized(settingTarget.toString()));
                }
                return (List)StringUtil.copyPartialMatches((String)args[0], options, new ArrayList(ExperienceBarManager.XPBarSettingTarget.values().length));
            }
            case 2: {
                if (args[0].equalsIgnoreCase(ExperienceBarManager.XPBarSettingTarget.RESET.toString())) break;
                return (List)StringUtil.copyPartialMatches((String)args[1], mcMMO.p.getSkillTools().LOCALIZED_SKILL_NAMES, new ArrayList(mcMMO.p.getSkillTools().LOCALIZED_SKILL_NAMES.size()));
            }
        }
        return ImmutableList.of();
    }
}

