/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.events.experience.McMMOPlayerLevelUpEvent;
import com.gmail.nossr50.events.experience.McMMOPlayerXpGainEvent;
import com.gmail.nossr50.events.skills.abilities.McMMOPlayerAbilityActivateEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.player.PlayerLevelUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillTools;
import com.gmail.nossr50.worldguard.WorldGuardManager;
import com.gmail.nossr50.worldguard.WorldGuardUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class SelfListener
implements Listener {
    private final mcMMO plugin;

    public SelfListener(mcMMO plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLevelUp(McMMOPlayerLevelUpEvent event) {
        Player player = event.getPlayer();
        PrimarySkillType skill = event.getSkill();
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        if (mmoPlayer == null || !mmoPlayer.getProfile().isLoaded()) {
            return;
        }
        if (player.isOnline()) {
            for (int i = 0; i < event.getLevelsGained(); ++i) {
                int previousLevelGained = event.getSkillLevel() - i;
                UserManager.getPlayer(player).processUnlockNotifications(this.plugin, event.getSkill(), previousLevelGained);
            }
            RankUtils.resetUnlockDelayTimer();
            if (mcMMO.p.getGeneralConfig().getScoreboardsEnabled()) {
                ScoreboardManager.handleLevelUp(player, skill);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerXp(McMMOPlayerXpGainEvent event) {
        Player player = event.getPlayer();
        if (player.isOnline() && mcMMO.p.getGeneralConfig().getScoreboardsEnabled()) {
            ScoreboardManager.handleXp(player, event.getSkill());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onAbility(McMMOPlayerAbilityActivateEvent event) {
        Player player = event.getPlayer();
        if (player.isOnline() && mcMMO.p.getGeneralConfig().getScoreboardsEnabled()) {
            ScoreboardManager.cooldownUpdate(event.getPlayer(), event.getSkill());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerXpGain(McMMOPlayerXpGainEvent event) {
        int threshold;
        Player player = event.getPlayer();
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        if (mmoPlayer == null || !mmoPlayer.getProfile().isLoaded()) {
            return;
        }
        PrimarySkillType primarySkillType = event.getSkill();
        if (mmoPlayer.isDebugMode()) {
            mmoPlayer.getPlayer().sendMessage(event.getSkill().toString() + " XP Gained");
            mmoPlayer.getPlayer().sendMessage("Incoming Raw XP: " + event.getRawXpGained());
        }
        if ((event.getXpGainReason() == XPGainReason.PVE || event.getXpGainReason() == XPGainReason.PVP || event.getXpGainReason() == XPGainReason.SHARED_PVE || event.getXpGainReason() == XPGainReason.SHARED_PVP) && WorldGuardUtils.isWorldGuardLoaded() && !WorldGuardManager.getInstance().hasXPFlag(player)) {
            event.setRawXpGained(0.0f);
            event.setCancelled(true);
            if (mmoPlayer.isDebugMode()) {
                mmoPlayer.getPlayer().sendMessage("No WG XP Flag - New Raw XP: " + event.getRawXpGained());
            }
        }
        if (event.getXpGainReason() == XPGainReason.COMMAND) {
            return;
        }
        if (ExperienceConfig.getInstance().isEarlyGameBoostEnabled()) {
            int earlyGameBonusXP = 0;
            if (PlayerLevelUtils.qualifiesForEarlyGameBoost(mmoPlayer, primarySkillType)) {
                earlyGameBonusXP = (int)((double)earlyGameBonusXP + (double)mmoPlayer.getXpToLevel(primarySkillType) * 0.05);
                event.setRawXpGained(event.getRawXpGained() + (float)earlyGameBonusXP);
            }
        }
        if ((threshold = ExperienceConfig.getInstance().getDiminishedReturnsThreshold(primarySkillType)) <= 0 || !ExperienceConfig.getInstance().getDiminishedReturnsEnabled()) {
            if (mmoPlayer.isDebugMode()) {
                mmoPlayer.getPlayer().sendMessage("Final Raw XP: " + event.getRawXpGained());
            }
            return;
        }
        if (event.getRawXpGained() <= 0.0f) {
            return;
        }
        if (SkillTools.isChildSkill(primarySkillType)) {
            return;
        }
        float rawXp = event.getRawXpGained();
        float guaranteedMinimum = ExperienceConfig.getInstance().getDiminishedReturnsCap() * rawXp;
        float modifiedThreshold = (float)((double)threshold / ExperienceConfig.getInstance().getFormulaSkillModifier(primarySkillType) * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier());
        float difference = (mmoPlayer.getProfile().getRegisteredXpGain(primarySkillType) - modifiedThreshold) / modifiedThreshold;
        if (difference > 0.0f) {
            float newValue = rawXp - rawXp * difference;
            if (guaranteedMinimum <= 0.0f || newValue > guaranteedMinimum) {
                if (newValue > 0.0f) {
                    event.setRawXpGained(newValue);
                } else {
                    event.setCancelled(true);
                }
            } else {
                event.setRawXpGained(guaranteedMinimum);
            }
        }
        if (mmoPlayer.isDebugMode()) {
            mmoPlayer.getPlayer().sendMessage("Final Raw XP: " + event.getRawXpGained());
        }
    }
}

