/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.maces;

import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import java.util.Locale;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacesManager
extends SkillManager {
    @Nullable
    private static PotionEffectType slowEffectType;

    public MacesManager(McMMOPlayer mmoPlayer) {
        super(mmoPlayer, PrimarySkillType.MACES);
    }

    @Nullable
    private static PotionEffectType mockSpigotMatch(@NotNull String input) {
        String filtered = input.toLowerCase(Locale.ROOT).replaceAll("\\s+", "_");
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)filtered);
        return namespacedKey != null ? (PotionEffectType)Registry.EFFECT.get(namespacedKey) : null;
    }

    public double getCrushDamage() {
        if (!Permissions.canUseSubSkill(this.mmoPlayer.getPlayer(), SubSkillType.MACES_CRUSH)) {
            return 0.0;
        }
        int rank = RankUtils.getRank(this.getPlayer(), SubSkillType.MACES_CRUSH);
        if (rank > 0) {
            return 0.5 + (double)rank * 1.0;
        }
        return 0.0;
    }

    public void processCripple(@NotNull LivingEntity target) {
        if (slowEffectType == null) {
            if (MacesManager.mockSpigotMatch("slowness") == null) {
                mcMMO.p.getLogger().severe("Unable to find the Slowness PotionEffectType, mcMMO will not function properly.");
                throw new IllegalStateException("Unable to find the Slowness PotionEffectType!");
            }
            slowEffectType = MacesManager.mockSpigotMatch("slowness");
        }
        boolean isPlayerTarget = target instanceof Player;
        if (slowEffectType == null || target.getPotionEffect(slowEffectType) != null) {
            return;
        }
        if (!Permissions.canUseSubSkill(this.mmoPlayer.getPlayer(), SubSkillType.MACES_CRIPPLE)) {
            return;
        }
        int crippleRank = RankUtils.getRank(this.getPlayer(), SubSkillType.MACES_CRIPPLE);
        double crippleOdds = mcMMO.p.getAdvancedConfig().getCrippleChanceToApplyOnHit(crippleRank) * this.mmoPlayer.getAttackStrength();
        if (ProbabilityUtil.isStaticSkillRNGSuccessful(PrimarySkillType.MACES, this.mmoPlayer, crippleOdds)) {
            if (this.mmoPlayer.useChatNotifications()) {
                NotificationManager.sendPlayerInformation(this.mmoPlayer.getPlayer(), NotificationType.SUBSKILL_MESSAGE, "Maces.SubSkill.Cripple.Activated");
            }
            target.addPotionEffect(slowEffectType.createEffect(MacesManager.getCrippleTickDuration(isPlayerTarget), MacesManager.getCrippleStrength(isPlayerTarget)));
            ParticleEffectUtils.playCrippleEffect(target);
        }
    }

    public static int getCrippleTickDuration(boolean isPlayerTarget) {
        if (isPlayerTarget) {
            return 20;
        }
        return 30;
    }

    public static int getCrippleStrength(boolean isPlayerTarget) {
        return isPlayerTarget ? 1 : 2;
    }
}

