/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.taming;

import com.gmail.nossr50.datatypes.skills.subskills.taming.CallOfTheWildType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.CancellableRunnable;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class TrackedTamingEntity
extends CancellableRunnable {
    @NotNull
    private final LivingEntity livingEntity;
    @NotNull
    private final CallOfTheWildType callOfTheWildType;
    @NotNull
    private final Player player;
    @NotNull
    private final UUID playerUUID;

    public TrackedTamingEntity(@NotNull LivingEntity livingEntity, @NotNull CallOfTheWildType callOfTheWildType, @NotNull Player player) {
        this.player = player;
        this.playerUUID = player.getUniqueId();
        this.callOfTheWildType = callOfTheWildType;
        this.livingEntity = livingEntity;
        int tamingCOTWLength = mcMMO.p.getGeneralConfig().getTamingCOTWLength(callOfTheWildType.getConfigEntityTypeEntry());
        if (tamingCOTWLength > 0) {
            int length = tamingCOTWLength * 20;
            mcMMO.p.getFoliaLib().getScheduler().runAtEntityLater((Entity)livingEntity, this, (long)length);
        }
    }

    @Override
    public void run() {
        mcMMO.getTransientEntityTracker().killSummonAndCleanMobFlags(this.getLivingEntity(), this.player, true);
        mcMMO.getTransientEntityTracker().removeSummonFromTracker(this.playerUUID, this);
        this.cancel();
    }

    @NotNull
    public CallOfTheWildType getCallOfTheWildType() {
        return this.callOfTheWildType;
    }

    @NotNull
    public LivingEntity getLivingEntity() {
        return this.livingEntity;
    }
}

