/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.text;

import com.gmail.nossr50.datatypes.party.PartyFeature;
import com.gmail.nossr50.util.text.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class ConfigStringUtils {
    public static final String UNDERSCORE = "_";
    public static final String SPACE = " ";
    private static final Map<EntityType, String> configEntityStrings = new ConcurrentHashMap<EntityType, String>();
    private static final Map<Material, String> configMaterialStrings = new ConcurrentHashMap<Material, String>();
    private static final Map<PartyFeature, String> configPartyFeatureStrings = new ConcurrentHashMap<PartyFeature, String>();
    private static final Function<String, String> CONFIG_FRIENDLY_STRING_FORMATTER = baseString -> {
        if (baseString.contains(UNDERSCORE) && !baseString.contains(SPACE)) {
            return ConfigStringUtils.asConfigFormat(baseString.split(UNDERSCORE));
        }
        if (baseString.contains(SPACE)) {
            return ConfigStringUtils.asConfigFormat(baseString.split(SPACE));
        }
        return StringUtils.getCapitalized(baseString);
    };

    public static String getMaterialConfigString(Material material) {
        return configMaterialStrings.computeIfAbsent(material, ConfigStringUtils::createConfigFriendlyString);
    }

    public static String getConfigEntityTypeString(EntityType entityType) {
        return configEntityStrings.computeIfAbsent(entityType, ConfigStringUtils::createConfigFriendlyString);
    }

    public static String getConfigPartyFeatureString(PartyFeature partyFeature) {
        return configPartyFeatureStrings.computeIfAbsent(partyFeature, pf -> ConfigStringUtils.createConfigFriendlyString(pf.name()).replace(UNDERSCORE, ""));
    }

    private static String createConfigFriendlyString(String baseString) {
        return CONFIG_FRIENDLY_STRING_FORMATTER.apply(baseString);
    }

    @NotNull
    private static String asConfigFormat(String[] substrings) {
        StringBuilder configString = new StringBuilder();
        for (int i = 0; i < substrings.length; ++i) {
            configString.append(StringUtils.getCapitalized(substrings[i]));
            if (i >= substrings.length - 1) continue;
            configString.append(UNDERSCORE);
        }
        return configString.toString();
    }

    private static String createConfigFriendlyString(Object object) {
        return ConfigStringUtils.createConfigFriendlyString(object.toString());
    }
}

