/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.worldguard;

import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.registry.SimpleFlagRegistry;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class WorldGuardUtils {
    private static WorldGuardPlugin worldGuardPluginRef;
    private static boolean isLoaded;
    private static boolean detectedIncompatibleWG;
    private static final ArrayList<String> WGClassList;

    public static boolean isWorldGuardLoaded() {
        if (detectedIncompatibleWG) {
            return false;
        }
        worldGuardPluginRef = WorldGuardUtils.getWorldGuard();
        return isLoaded;
    }

    private static WorldGuardPlugin getWorldGuard() {
        if (isLoaded) {
            return worldGuardPluginRef;
        }
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("WorldGuard");
        if (plugin == null) {
            detectedIncompatibleWG = true;
            LogUtils.debug(mcMMO.p.getLogger(), "WorldGuard was not detected.");
        } else if (plugin instanceof WorldGuardPlugin) {
            if (WorldGuardUtils.isCompatibleVersion(plugin)) {
                worldGuardPluginRef = (WorldGuardPlugin)plugin;
                isLoaded = true;
            }
        } else {
            WorldGuardUtils.markWGIncompatible();
        }
        return worldGuardPluginRef;
    }

    private static boolean isCompatibleVersion(Plugin plugin) {
        boolean allClassesFound = true;
        if (detectedIncompatibleWG) {
            return false;
        }
        if (!plugin.getDescription().getVersion().startsWith("7")) {
            WorldGuardUtils.markWGIncompatible();
        } else {
            for (String classString : WGClassList) {
                try {
                    Class<?> clazz = Class.forName(classString);
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    allClassesFound = false;
                    mcMMO.p.getLogger().severe("Missing WorldGuard class - " + classString);
                    WorldGuardUtils.markWGIncompatible();
                }
            }
            try {
                if (allClassesFound && !((SimpleFlagRegistry)WorldGuard.getInstance().getFlagRegistry()).isInitialized()) {
                    WorldGuardUtils.markWGIncompatible();
                    mcMMO.p.getLogger().severe("WG did not initialize properly, this can cause errors with mcMMO so mcMMO is disabling certain features.");
                }
            }
            catch (Exception e) {
                WorldGuardUtils.markWGIncompatible();
                e.printStackTrace();
            }
        }
        return !detectedIncompatibleWG;
    }

    private static void markWGIncompatible() {
        mcMMO.p.getLogger().severe("You are using a version of WG that is not compatible with mcMMO, WG features for mcMMO will be disabled. mcMMO requires you to be using a new version of WG7 in order for it to use WG features. Not all versions of WG7 are compatible.");
        mcMMO.p.getLogger().severe("mcMMO will continue to function normally, but if you wish to use WG support you must use a compatible version.");
        detectedIncompatibleWG = true;
    }

    static {
        isLoaded = false;
        detectedIncompatibleWG = false;
        WGClassList = new ArrayList();
        WGClassList.add("com.sk89q.worldedit.bukkit.BukkitAdapter");
        WGClassList.add("com.sk89q.worldedit.bukkit.BukkitPlayer");
        WGClassList.add("com.sk89q.worldguard.WorldGuard");
        WGClassList.add("com.sk89q.worldguard.bukkit.WorldGuardPlugin");
        WGClassList.add("com.sk89q.worldguard.protection.flags.registry.FlagConflictException");
        WGClassList.add("com.sk89q.worldguard.protection.flags.registry.FlagRegistry");
        WGClassList.add("com.sk89q.worldguard.protection.regions.RegionContainer");
        WGClassList.add("com.sk89q.worldguard.protection.regions.RegionQuery");
    }
}

