/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.chat.mailer;

import com.gmail.nossr50.chat.author.Author;
import com.gmail.nossr50.chat.mailer.AbstractChatMailer;
import com.gmail.nossr50.chat.message.AdminChatMessage;
import com.gmail.nossr50.chat.message.ChatMessage;
import com.gmail.nossr50.config.ChatConfig;
import com.gmail.nossr50.datatypes.chat.ChatChannel;
import com.gmail.nossr50.events.chat.McMMOAdminChatEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.text.TextUtils;
import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class AdminChatMailer
extends AbstractChatMailer {
    @NotNull
    public static final String MCMMO_CHAT_ADMINCHAT_PERMISSION = "mcmmo.chat.adminchat";

    public AdminChatMailer(Plugin pluginRef) {
        super(pluginRef);
    }

    @NotNull
    public Audience constructAudience() {
        return mcMMO.getAudiences().filter(this.predicate());
    }

    @NotNull
    public Predicate<CommandSender> predicate() {
        return commandSender -> commandSender.isOp() || commandSender.hasPermission(MCMMO_CHAT_ADMINCHAT_PERMISSION) || ChatConfig.getInstance().isConsoleIncludedInAudience(ChatChannel.ADMIN) && commandSender instanceof ConsoleCommandSender;
    }

    @NotNull
    public TextComponent addStyle(@NotNull Author author, @NotNull String message, boolean canColor) {
        if (canColor) {
            return LocaleLoader.getTextComponent("Chat.Style.Admin", author.getAuthoredName(ChatChannel.ADMIN), message);
        }
        return TextUtils.ofLegacyTextRaw(LocaleLoader.getString("Chat.Style.Admin", author.getAuthoredName(ChatChannel.ADMIN), message));
    }

    @Override
    public void sendMail(@NotNull ChatMessage chatMessage) {
        chatMessage.sendMessage();
    }

    public void processChatMessage(@NotNull Author author, @NotNull String rawString, boolean isAsync, boolean canColor) {
        AdminChatMessage chatMessage = new AdminChatMessage(this.pluginRef, author, this.constructAudience(), rawString, this.addStyle(author, rawString, canColor));
        McMMOAdminChatEvent chatEvent = new McMMOAdminChatEvent(this.pluginRef, chatMessage, isAsync);
        Bukkit.getPluginManager().callEvent((Event)chatEvent);
        if (!chatEvent.isCancelled()) {
            this.sendMail(chatMessage);
        }
    }
}

