/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.BukkitCommandIssuer;
import co.aikar.commands.BukkitCommandManager;
import co.aikar.commands.ConditionFailedException;
import com.gmail.nossr50.commands.chat.AdminChatCommand;
import com.gmail.nossr50.commands.chat.PartyChatCommand;
import com.gmail.nossr50.commands.skills.PowerLevelCommand;
import com.gmail.nossr50.config.ChatConfig;
import com.gmail.nossr50.datatypes.chat.ChatChannel;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class CommandManager {
    @NotNull
    public static final String MMO_DATA_LOADED = "mmoDataLoaded";
    @NotNull
    public static final String ADMIN_CONDITION = "adminCondition";
    @NotNull
    public static final String PARTY_CONDITION = "partyCondition";
    @NotNull
    public static final String POWER_LEVEL_CONDITION = "powerLevelCondition";
    @NotNull
    private final mcMMO pluginRef;
    @NotNull
    private final BukkitCommandManager bukkitCommandManager;

    public CommandManager(@NotNull mcMMO pluginRef) {
        this.pluginRef = pluginRef;
        this.bukkitCommandManager = new BukkitCommandManager((Plugin)pluginRef);
        this.registerConditions();
        this.registerCommands();
    }

    private void registerCommands() {
        this.registerSkillCommands();
        this.registerChatCommands();
    }

    private void registerSkillCommands() {
        if (mcMMO.p.getGeneralConfig().isMasterySystemEnabled()) {
            this.bukkitCommandManager.registerCommand((BaseCommand)new PowerLevelCommand(this.pluginRef));
        }
    }

    private void registerChatCommands() {
        if (ChatConfig.getInstance().isChatEnabled()) {
            if (ChatConfig.getInstance().isChatChannelEnabled(ChatChannel.ADMIN)) {
                this.bukkitCommandManager.registerCommand((BaseCommand)new AdminChatCommand(this.pluginRef));
            }
            if (this.pluginRef.getPartyConfig().isPartyEnabled() && ChatConfig.getInstance().isChatChannelEnabled(ChatChannel.PARTY)) {
                this.bukkitCommandManager.registerCommand((BaseCommand)new PartyChatCommand(this.pluginRef));
            }
        }
    }

    public void registerConditions() {
        this.registerChatCommandConditions();
        this.registerSkillConditions();
    }

    private void registerSkillConditions() {
        this.bukkitCommandManager.getCommandConditions().addCondition(POWER_LEVEL_CONDITION, context -> {
            BukkitCommandIssuer issuer = (BukkitCommandIssuer)context.getIssuer();
            if (!(issuer.getIssuer() instanceof Player)) {
                throw new ConditionFailedException(LocaleLoader.getString("Commands.NoConsole"));
            }
            this.validateLoadedData(issuer.getPlayer());
        });
    }

    private void registerChatCommandConditions() {
        this.bukkitCommandManager.getCommandConditions().addCondition(ADMIN_CONDITION, context -> {
            BukkitCommandIssuer issuer = (BukkitCommandIssuer)context.getIssuer();
            if (issuer.getIssuer() instanceof Player) {
                this.validateLoadedData(issuer.getPlayer());
                this.validateAdmin(issuer.getPlayer());
            }
        });
        this.bukkitCommandManager.getCommandConditions().addCondition(MMO_DATA_LOADED, context -> {
            BukkitCommandIssuer bukkitCommandIssuer = (BukkitCommandIssuer)context.getIssuer();
            if (bukkitCommandIssuer.getIssuer() instanceof Player) {
                this.validateLoadedData(bukkitCommandIssuer.getPlayer());
            }
        });
        this.bukkitCommandManager.getCommandConditions().addCondition(PARTY_CONDITION, context -> {
            BukkitCommandIssuer bukkitCommandIssuer = (BukkitCommandIssuer)context.getIssuer();
            if (bukkitCommandIssuer.getIssuer() instanceof Player) {
                this.validateLoadedData(bukkitCommandIssuer.getPlayer());
                this.validatePlayerParty(bukkitCommandIssuer.getPlayer());
                this.validatePermission("mcmmo.chat.partychat", (Permissible)bukkitCommandIssuer.getPlayer());
            }
        });
    }

    private void validatePermission(@NotNull String permissionNode, @NotNull Permissible permissible) {
        if (!permissible.hasPermission(permissionNode)) {
            throw new ConditionFailedException(LocaleLoader.getString("mcMMO.NoPermission"));
        }
    }

    public void validateAdmin(@NotNull Player player) {
        if (!player.isOp() && !Permissions.adminChat((Permissible)player)) {
            throw new ConditionFailedException("You are lacking the correct permissions to use this command.");
        }
    }

    public void validateLoadedData(@NotNull Player player) {
        if (UserManager.getPlayer(player) == null) {
            throw new ConditionFailedException(LocaleLoader.getString("Profile.PendingLoad"));
        }
    }

    public void validatePlayerParty(@NotNull Player player) {
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        if (!this.pluginRef.getPartyConfig().isPartyEnabled() || mmoPlayer.getParty() == null) {
            throw new ConditionFailedException(LocaleLoader.getString("Commands.Party.None"));
        }
    }

    @NotNull
    public BukkitCommandManager getBukkitCommandManager() {
        return this.bukkitCommandManager;
    }
}

