/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.excavation.ExcavationManager;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.text.TextComponentFactory;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class ExcavationCommand
extends SkillCommand {
    private String gigaDrillBreakerLength;
    private String gigaDrillBreakerLengthEndurance;
    private boolean canGigaDrill;
    private boolean canTreasureHunt;

    public ExcavationCommand() {
        super(PrimarySkillType.EXCAVATION);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue) {
        if (this.canGigaDrill) {
            String[] gigaDrillStrings = this.calculateLengthDisplayValues(player, skillValue);
            this.gigaDrillBreakerLength = gigaDrillStrings[0];
            this.gigaDrillBreakerLengthEndurance = gigaDrillStrings[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canGigaDrill = Permissions.gigaDrillBreaker((Permissible)player) && RankUtils.hasUnlockedSubskill(player, SubSkillType.EXCAVATION_GIGA_DRILL_BREAKER);
        this.canTreasureHunt = Permissions.canUseSubSkill(player, SubSkillType.EXCAVATION_ARCHAEOLOGY);
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        ExcavationManager excavationManager = this.mmoPlayer.getExcavationManager();
        if (this.canGigaDrill) {
            messages.add(this.getStatMessage(SubSkillType.EXCAVATION_GIGA_DRILL_BREAKER, this.gigaDrillBreakerLength) + (hasEndurance ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.gigaDrillBreakerLengthEndurance) : ""));
        }
        if (Permissions.canUseSubSkill(player, SubSkillType.EXCAVATION_ARCHAEOLOGY)) {
            messages.add(this.getStatMessage(false, false, SubSkillType.EXCAVATION_ARCHAEOLOGY, this.percent.format(excavationManager.getArchaelogyExperienceOrbChance() / 100.0)));
            messages.add(this.getStatMessage(true, false, SubSkillType.EXCAVATION_ARCHAEOLOGY, String.valueOf(excavationManager.getExperienceOrbsReward())));
        }
        return messages;
    }

    @Override
    protected List<Component> getTextComponents(Player player) {
        ArrayList<Component> textComponents = new ArrayList<Component>();
        TextComponentFactory.getSubSkillTextComponents(player, textComponents, PrimarySkillType.EXCAVATION);
        return textComponents;
    }
}

