/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.skills;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.runnables.skills.AlchemyBrewTask;
import com.gmail.nossr50.skills.alchemy.Alchemy;
import com.gmail.nossr50.skills.alchemy.AlchemyPotionBrewer;
import com.gmail.nossr50.util.CancellableRunnable;
import com.gmail.nossr50.util.ContainerMetadataUtils;
import com.gmail.nossr50.util.player.UserManager;
import java.util.Arrays;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlchemyBrewCheckTask
extends CancellableRunnable {
    private final BrewingStand brewingStand;
    private final ItemStack[] oldInventory;

    @Deprecated(forRemoval=true, since="2.2.010")
    public AlchemyBrewCheckTask(@Nullable Player ignored, BrewingStand brewingStand) {
        this(brewingStand);
    }

    public AlchemyBrewCheckTask(@NotNull BrewingStand brewingStand) {
        this.brewingStand = brewingStand;
        this.oldInventory = Arrays.copyOfRange(brewingStand.getInventory().getContents(), 0, 4);
    }

    @Override
    public void run() {
        boolean validBrew;
        McMMOPlayer mmoPlayer;
        OfflinePlayer offlinePlayer = ContainerMetadataUtils.getContainerOwner((BlockState)this.brewingStand);
        int ingredientLevel = 1;
        if (offlinePlayer != null && offlinePlayer.isOnline() && (mmoPlayer = UserManager.getPlayer(offlinePlayer.getPlayer())) != null) {
            ingredientLevel = mmoPlayer.getAlchemyManager().getTier();
        }
        Location location = this.brewingStand.getLocation();
        ItemStack[] newInventory = Arrays.copyOfRange(this.brewingStand.getInventory().getContents(), 0, 4);
        boolean bl = validBrew = this.brewingStand.getFuelLevel() > 0 && AlchemyPotionBrewer.isValidBrew(ingredientLevel, newInventory);
        if (Alchemy.brewingStandMap.containsKey(location)) {
            if (this.oldInventory[3] == null || newInventory[3] == null || !this.oldInventory[3].isSimilar(newInventory[3]) || !validBrew) {
                Alchemy.brewingStandMap.get(location).cancelBrew();
            }
        } else if (validBrew) {
            Alchemy.brewingStandMap.put(location, new AlchemyBrewTask((BlockState)this.brewingStand));
        }
    }
}

