/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.player;

import com.gmail.nossr50.datatypes.LevelUpBroadcastPredicate;
import com.gmail.nossr50.datatypes.PowerLevelUpBroadcastPredicate;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.notifications.SensitiveCommandType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.events.skills.McMMOPlayerNotificationEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import com.gmail.nossr50.util.text.McMMOMessageType;
import com.gmail.nossr50.util.text.TextComponentFactory;
import java.time.LocalDate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.SoundCategory;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class NotificationManager {
    public static final String HEX_BEIGE_COLOR = "#c2a66e";
    public static final String HEX_LIME_GREEN_COLOR = "#8ec26e";

    public static void sendPlayerInformation(Player player, NotificationType notificationType, String key) {
        if (UserManager.getPlayer(player) == null || !UserManager.getPlayer(player).useChatNotifications()) {
            return;
        }
        McMMOMessageType destination = mcMMO.p.getAdvancedConfig().doesNotificationUseActionBar(notificationType) ? McMMOMessageType.ACTION_BAR : McMMOMessageType.SYSTEM;
        Component message = TextComponentFactory.getNotificationTextComponentFromLocale(key);
        McMMOPlayerNotificationEvent customEvent = NotificationManager.checkNotificationEvent(player, notificationType, destination, message);
        NotificationManager.sendNotification(player, customEvent);
    }

    public static boolean doesPlayerUseNotifications(Player player) {
        if (UserManager.getPlayer(player) == null) {
            return false;
        }
        return UserManager.getPlayer(player).useChatNotifications();
    }

    public static void sendNearbyPlayersInformation(Player targetPlayer, NotificationType notificationType, String key, String ... values) {
        NotificationManager.sendPlayerInformation(targetPlayer, notificationType, key, values);
    }

    public static void sendPlayerInformationChatOnly(Player player, String key, String ... values) {
        if (UserManager.getPlayer(player) == null || !UserManager.getPlayer(player).useChatNotifications()) {
            return;
        }
        String preColoredString = LocaleLoader.getString(key, values);
        player.sendMessage(preColoredString);
    }

    public static void sendPlayerInformationChatOnlyPrefixed(Player player, String key, String ... values) {
        if (UserManager.getPlayer(player) == null || !UserManager.getPlayer(player).useChatNotifications()) {
            return;
        }
        String preColoredString = LocaleLoader.getString(key, values);
        String prefixFormattedMessage = LocaleLoader.getString("mcMMO.Template.Prefix", preColoredString);
        player.sendMessage(prefixFormattedMessage);
    }

    public static void sendPlayerInformation(Player player, NotificationType notificationType, String key, String ... values) {
        if (UserManager.getPlayer(player) == null || !UserManager.getPlayer(player).useChatNotifications()) {
            return;
        }
        McMMOMessageType destination = mcMMO.p.getAdvancedConfig().doesNotificationUseActionBar(notificationType) ? McMMOMessageType.ACTION_BAR : McMMOMessageType.SYSTEM;
        TextComponent message = TextComponentFactory.getNotificationMultipleValues(key, values);
        McMMOPlayerNotificationEvent customEvent = NotificationManager.checkNotificationEvent(player, notificationType, destination, (Component)message);
        NotificationManager.sendNotification(player, customEvent);
    }

    private static void sendNotification(Player player, McMMOPlayerNotificationEvent customEvent) {
        if (customEvent.isCancelled()) {
            return;
        }
        Audience audience = mcMMO.getAudiences().player(player);
        Component notificationTextComponent = customEvent.getNotificationTextComponent();
        if (customEvent.getChatMessageType() == McMMOMessageType.ACTION_BAR) {
            audience.sendActionBar(notificationTextComponent);
            if (customEvent.isMessageAlsoBeingSentToChat()) {
                audience.sendMessage(notificationTextComponent);
            }
        } else {
            audience.sendMessage(notificationTextComponent);
        }
    }

    private static McMMOPlayerNotificationEvent checkNotificationEvent(Player player, NotificationType notificationType, McMMOMessageType destination, Component message) {
        McMMOPlayerNotificationEvent customEvent = new McMMOPlayerNotificationEvent(player, notificationType, message, destination, mcMMO.p.getAdvancedConfig().doesNotificationSendCopyToChat(notificationType));
        Bukkit.getServer().getPluginManager().callEvent((Event)customEvent);
        return customEvent;
    }

    public static void sendPlayerLevelUpNotification(McMMOPlayer mmoPlayer, PrimarySkillType skillName, int levelsGained, int newLevel) {
        if (!mmoPlayer.useChatNotifications()) {
            return;
        }
        McMMOMessageType destination = mcMMO.p.getAdvancedConfig().doesNotificationUseActionBar(NotificationType.LEVEL_UP_MESSAGE) ? McMMOMessageType.ACTION_BAR : McMMOMessageType.SYSTEM;
        Component levelUpTextComponent = TextComponentFactory.getNotificationLevelUpTextComponent(skillName, levelsGained, newLevel);
        McMMOPlayerNotificationEvent customEvent = NotificationManager.checkNotificationEvent(mmoPlayer.getPlayer(), NotificationType.LEVEL_UP_MESSAGE, destination, levelUpTextComponent);
        NotificationManager.sendNotification(mmoPlayer.getPlayer(), customEvent);
    }

    public static void broadcastTitle(Server server, String title, String subtitle, int i1, int i2, int i3) {
        for (Player player : server.getOnlinePlayers()) {
            player.sendTitle(title, subtitle, i1, i2, i3);
        }
    }

    public static void sendPlayerUnlockNotification(McMMOPlayer mmoPlayer, SubSkillType subSkillType) {
        if (!mmoPlayer.useChatNotifications()) {
            return;
        }
        mcMMO.getAudiences().player(mmoPlayer.getPlayer()).sendMessage(Identity.nil(), (Component)TextComponentFactory.getSubSkillUnlockedNotificationComponents(mmoPlayer.getPlayer(), subSkillType));
        SoundManager.sendCategorizedSound(mmoPlayer.getPlayer(), mmoPlayer.getPlayer().getLocation(), SoundType.SKILL_UNLOCKED, SoundCategory.MASTER);
    }

    private static void sendAdminNotification(String msg) {
        if (!mcMMO.p.getGeneralConfig().adminNotifications()) {
            return;
        }
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            if (!player.isOp() && !Permissions.adminChat((Permissible)player)) continue;
            player.sendMessage(LocaleLoader.getString("Notifications.Admin.Format.Others", msg));
        }
        mcMMO.p.getLogger().info(LocaleLoader.getString("Notifications.Admin.Format.Others", msg));
    }

    private static void sendAdminCommandConfirmation(CommandSender commandSender, String msg) {
        commandSender.sendMessage(LocaleLoader.getString("Notifications.Admin.Format.Self", msg));
    }

    public static void processSensitiveCommandNotification(CommandSender commandSender, SensitiveCommandType sensitiveCommandType, String ... args) {
        Object senderName = LocaleLoader.getString("Server.ConsoleName");
        if (commandSender instanceof Player) {
            senderName = ((Player)commandSender).getDisplayName() + String.valueOf(ChatColor.RESET) + "-" + String.valueOf(((Player)commandSender).getUniqueId());
        }
        switch (sensitiveCommandType) {
            case XPRATE_MODIFY: {
                NotificationManager.sendAdminNotification(LocaleLoader.getString("Notifications.Admin.XPRate.Start.Others", NotificationManager.addItemToFirstPositionOfArray((String)senderName, args)));
                NotificationManager.sendAdminCommandConfirmation(commandSender, LocaleLoader.getString("Notifications.Admin.XPRate.Start.Self", args));
                break;
            }
            case XPRATE_END: {
                NotificationManager.sendAdminNotification(LocaleLoader.getString("Notifications.Admin.XPRate.End.Others", NotificationManager.addItemToFirstPositionOfArray((String)senderName, args)));
                NotificationManager.sendAdminCommandConfirmation(commandSender, LocaleLoader.getString("Notifications.Admin.XPRate.End.Self", args));
            }
        }
    }

    public static String[] addItemToFirstPositionOfArray(String itemToAdd, String ... existingArray) {
        String[] newArray = new String[existingArray.length + 1];
        newArray[0] = itemToAdd;
        System.arraycopy(existingArray, 0, newArray, 1, existingArray.length);
        return newArray;
    }

    public static void processLevelUpBroadcasting(@NotNull McMMOPlayer mmoPlayer, @NotNull PrimarySkillType primarySkillType, int level) {
        if (level <= 0) {
            return;
        }
        if (mcMMO.p.getGeneralConfig().shouldLevelUpBroadcasts()) {
            if (!Permissions.levelUpBroadcast((Permissible)mmoPlayer.getPlayer())) {
                return;
            }
            int levelInterval = mcMMO.p.getGeneralConfig().getLevelUpBroadcastInterval();
            int remainder = level % levelInterval;
            if (remainder == 0) {
                Audience audience = mcMMO.getAudiences().filter(NotificationManager.getLevelUpBroadcastPredicate((CommandSender)mmoPlayer.getPlayer()));
                HoverEvent levelMilestoneHover = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)mmoPlayer.getPlayer().getName()).append((Component)Component.newline())).append((Component)Component.text((String)LocalDate.now().toString()))).append((Component)Component.newline())).append((Component)Component.text((String)(mcMMO.p.getSkillTools().getLocalizedSkillName(primarySkillType) + " reached level " + level)))).color(TextColor.fromHexString((String)HEX_BEIGE_COLOR))).asHoverEvent();
                String localeMessage = LocaleLoader.getString("Broadcasts.LevelUpMilestone", mmoPlayer.getPlayer().getDisplayName(), level, mcMMO.p.getSkillTools().getLocalizedSkillName(primarySkillType));
                Component component = LegacyComponentSerializer.legacySection().deserialize(localeMessage).hoverEvent((HoverEventSource)levelMilestoneHover);
                mcMMO.p.getFoliaLib().getScheduler().runNextTick(t -> audience.sendMessage(component));
            }
        }
    }

    public static void processPowerLevelUpBroadcasting(@NotNull McMMOPlayer mmoPlayer, int powerLevel) {
        if (powerLevel <= 0) {
            return;
        }
        if (mcMMO.p.getGeneralConfig().shouldPowerLevelUpBroadcasts()) {
            if (!Permissions.levelUpBroadcast((Permissible)mmoPlayer.getPlayer())) {
                return;
            }
            int levelInterval = mcMMO.p.getGeneralConfig().getPowerLevelUpBroadcastInterval();
            int remainder = powerLevel % levelInterval;
            if (remainder == 0) {
                Audience audience = mcMMO.getAudiences().filter(NotificationManager.getPowerLevelUpBroadcastPredicate((CommandSender)mmoPlayer.getPlayer()));
                HoverEvent levelMilestoneHover = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)mmoPlayer.getPlayer().getName()).append((Component)Component.newline())).append((Component)Component.text((String)LocalDate.now().toString()))).append((Component)Component.newline())).append((Component)Component.text((String)("Power level has reached " + powerLevel)))).color(TextColor.fromHexString((String)HEX_BEIGE_COLOR))).asHoverEvent();
                String localeMessage = LocaleLoader.getString("Broadcasts.PowerLevelUpMilestone", mmoPlayer.getPlayer().getDisplayName(), powerLevel);
                Component message = LegacyComponentSerializer.legacySection().deserialize(localeMessage).hoverEvent((HoverEventSource)levelMilestoneHover);
                mcMMO.p.getFoliaLib().getScheduler().runNextTick(t -> audience.sendMessage(message));
            }
        }
    }

    @NotNull
    public static LevelUpBroadcastPredicate<CommandSender> getLevelUpBroadcastPredicate(@NotNull CommandSender levelUpPlayer) {
        return new LevelUpBroadcastPredicate<CommandSender>(levelUpPlayer);
    }

    @NotNull
    public static PowerLevelUpBroadcastPredicate<CommandSender> getPowerLevelUpBroadcastPredicate(@NotNull CommandSender levelUpPlayer) {
        return new PowerLevelUpBroadcastPredicate<CommandSender>(levelUpPlayer);
    }
}

