/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.skills;

import com.gmail.nossr50.config.RankConfig;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.datatypes.skills.subskills.AbstractSubSkill;
import com.gmail.nossr50.listeners.InteractionManager;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.skills.SkillUnlockNotificationTask;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import java.util.HashMap;
import java.util.function.Consumer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class RankUtils {
    private static HashMap<String, HashMap<Integer, Integer>> subSkillRanks;
    private static int count;

    public static void executeSkillUnlockNotifications(Plugin plugin, McMMOPlayer mmoPlayer, PrimarySkillType primarySkillType, int newLevel) {
        for (SubSkillType subSkillType : mcMMO.p.getSkillTools().getSubSkills(primarySkillType)) {
            int playerRankInSkill = RankUtils.getRank(mmoPlayer.getPlayer(), subSkillType);
            HashMap<Integer, Integer> innerMap = subSkillRanks.get(subSkillType.toString());
            if (innerMap == null || innerMap.get(playerRankInSkill) == null || !Permissions.isSubSkillEnabled((Permissible)mmoPlayer.getPlayer(), subSkillType) || newLevel != innerMap.get(playerRankInSkill)) continue;
            SkillUnlockNotificationTask skillUnlockNotificationTask = new SkillUnlockNotificationTask(mmoPlayer, subSkillType, newLevel);
            mcMMO.p.getFoliaLib().getScheduler().runAtEntityLater((Entity)mmoPlayer.getPlayer(), (Consumer)skillUnlockNotificationTask, (long)count * 100L);
            ++count;
        }
    }

    public static void resetUnlockDelayTimer() {
        count = 0;
    }

    private static void addRanks(AbstractSubSkill abstractSubSkill) {
        for (int i = 0; i < abstractSubSkill.getNumRanks(); ++i) {
            RankUtils.addRank(abstractSubSkill, abstractSubSkill.getNumRanks() - i);
        }
    }

    private static void addRanks(SubSkillType subSkillType) {
        for (int i = 0; i < subSkillType.getNumRanks(); ++i) {
            RankUtils.addRank(subSkillType, subSkillType.getNumRanks() - i);
        }
    }

    public static void populateRanks() {
        for (SubSkillType subSkillType : SubSkillType.values()) {
            RankUtils.addRanks(subSkillType);
        }
        for (AbstractSubSkill abstractSubSkill : InteractionManager.getSubSkillList()) {
            RankUtils.addRanks(abstractSubSkill);
        }
    }

    public static boolean hasUnlockedSubskill(Player player, SubSkillType subSkillType) {
        int curRank = RankUtils.getRank(player, subSkillType);
        return curRank == -1 || curRank >= 1;
    }

    public static boolean hasUnlockedSubskill(Player player, AbstractSubSkill abstractSubSkill) {
        int curRank = RankUtils.getRank(player, abstractSubSkill);
        return curRank == -1 || curRank >= 1;
    }

    public static boolean hasReachedRank(int rank, Player player, SubSkillType subSkillType) {
        return RankUtils.getRank(player, subSkillType) >= rank;
    }

    public static boolean hasReachedRank(int rank, Player player, AbstractSubSkill abstractSubSkill) {
        return RankUtils.getRank(player, abstractSubSkill) >= rank;
    }

    public static int getRank(McMMOPlayer mmoPlayer, SubSkillType subSkillType) {
        return RankUtils.getRank(mmoPlayer.getPlayer(), subSkillType);
    }

    public static int getRank(Player player, SubSkillType subSkillType) {
        String skillName = subSkillType.toString();
        int numRanks = subSkillType.getNumRanks();
        if (subSkillRanks == null) {
            subSkillRanks = new HashMap();
        }
        if (numRanks == 0) {
            return -1;
        }
        if (subSkillRanks.get(skillName) == null && numRanks > 0) {
            RankUtils.addRanks(subSkillType);
        }
        HashMap<Integer, Integer> rankMap = subSkillRanks.get(skillName);
        if (UserManager.getPlayer(player) == null) {
            return 0;
        }
        int currentSkillLevel = UserManager.getPlayer(player).getSkillLevel(subSkillType.getParentSkill());
        for (int i = 0; i < numRanks; ++i) {
            int rank = numRanks - i;
            int unlockLevel = RankUtils.getRankUnlockLevel(subSkillType, rank);
            if (rank == 0) {
                return 0;
            }
            if (currentSkillLevel < unlockLevel) continue;
            return rank;
        }
        return 0;
    }

    public static int getRank(Player player, AbstractSubSkill abstractSubSkill) {
        String skillName = abstractSubSkill.getConfigKeyName();
        int numRanks = abstractSubSkill.getNumRanks();
        if (subSkillRanks == null) {
            subSkillRanks = new HashMap();
        }
        if (numRanks == 0) {
            return -1;
        }
        if (subSkillRanks.get(skillName) == null && numRanks > 0) {
            RankUtils.addRanks(abstractSubSkill);
        }
        HashMap<Integer, Integer> rankMap = subSkillRanks.get(skillName);
        if (UserManager.getPlayer(player) == null) {
            return 0;
        }
        int currentSkillLevel = UserManager.getPlayer(player).getSkillLevel(abstractSubSkill.getPrimarySkill());
        for (int i = 0; i < numRanks; ++i) {
            int rank = numRanks - i;
            int unlockLevel = RankUtils.getRankUnlockLevel(abstractSubSkill, rank);
            if (rank == 0) {
                return 0;
            }
            if (currentSkillLevel < unlockLevel) continue;
            return rank;
        }
        return 0;
    }

    private static void addRank(AbstractSubSkill abstractSubSkill, int rank) {
        RankUtils.initMaps(abstractSubSkill.getConfigKeyName());
        HashMap<Integer, Integer> rankMap = subSkillRanks.get(abstractSubSkill.getConfigKeyName());
        rankMap.put(rank, RankUtils.getRankUnlockLevel(abstractSubSkill, rank));
    }

    @Deprecated
    private static void addRank(SubSkillType subSkillType, int rank) {
        RankUtils.initMaps(subSkillType.toString());
        HashMap<Integer, Integer> rankMap = subSkillRanks.get(subSkillType.toString());
        rankMap.put(rank, RankUtils.getRankUnlockLevel(subSkillType, rank));
    }

    private static void initMaps(String s) {
        if (subSkillRanks == null) {
            subSkillRanks = new HashMap();
        }
        subSkillRanks.computeIfAbsent(s, k -> new HashMap());
    }

    public static int getRankUnlockLevel(SubSkillType subSkillType, int rank) {
        return RankConfig.getInstance().getSubSkillUnlockLevel(subSkillType, rank);
    }

    public static int getRankUnlockLevel(AbstractSubSkill abstractSubSkill, int rank) {
        return RankConfig.getInstance().getSubSkillUnlockLevel(abstractSubSkill, rank);
    }

    public static int getUnlockLevel(SubSkillType subSkillType) {
        return RankConfig.getInstance().getSubSkillUnlockLevel(subSkillType, 1);
    }

    public static int getUnlockLevel(AbstractSubSkill abstractSubSkill) {
        return RankConfig.getInstance().getSubSkillUnlockLevel(abstractSubSkill, 1);
    }

    public static int getHighestRank(SubSkillType subSkillType) {
        return subSkillType.getNumRanks();
    }

    public static String getHighestRankStr(SubSkillType subSkillType) {
        return String.valueOf(subSkillType.getNumRanks());
    }

    public static int getHighestRank(AbstractSubSkill abstractSubSkill) {
        return abstractSubSkill.getNumRanks();
    }

    public static int getSuperAbilityUnlockRequirement(SuperAbilityType superAbilityType) {
        return RankUtils.getRankUnlockLevel(superAbilityType.getSubSkillTypeDefinition(), 1);
    }

    public static boolean isPlayerMaxRankInSubSkill(Player player, SubSkillType subSkillType) {
        int highestRank;
        int playerRank = RankUtils.getRank(player, subSkillType);
        return playerRank == (highestRank = RankUtils.getHighestRank(subSkillType));
    }

    static {
        count = 0;
    }
}

