/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.chat;

import com.gmail.nossr50.chat.author.Author;
import com.gmail.nossr50.chat.author.ConsoleAuthor;
import com.gmail.nossr50.chat.mailer.AdminChatMailer;
import com.gmail.nossr50.chat.mailer.PartyChatMailer;
import com.gmail.nossr50.config.ChatConfig;
import com.gmail.nossr50.datatypes.chat.ChatChannel;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.text.StringUtils;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ChatManager {
    @NotNull
    private final AdminChatMailer adminChatMailer;
    @NotNull
    private final PartyChatMailer partyChatMailer;
    @NotNull
    private final ConsoleAuthor consoleAuthor;
    @NotNull
    private final Audience consoleAudience;
    private final boolean isChatEnabled;

    public ChatManager(@NotNull mcMMO pluginRef) {
        this.adminChatMailer = new AdminChatMailer((Plugin)pluginRef);
        this.partyChatMailer = new PartyChatMailer((Plugin)pluginRef);
        this.consoleAuthor = new ConsoleAuthor(LocaleLoader.getString("Chat.Identity.Console"));
        this.consoleAudience = mcMMO.getAudiences().filter(cs -> cs instanceof ConsoleCommandSender);
        this.isChatEnabled = ChatConfig.getInstance().isChatEnabled();
    }

    public void processPlayerMessage(@NotNull McMMOPlayer mmoPlayer, @NotNull String rawMessage, boolean isAsync) {
        this.processPlayerMessage(mmoPlayer, mmoPlayer.getChatChannel(), rawMessage, isAsync);
    }

    public void processPlayerMessage(@NotNull McMMOPlayer mmoPlayer, @NotNull String[] args, @NotNull ChatChannel chatChannel) {
        String chatMessageWithoutCommand = this.buildChatMessage(args);
        this.processPlayerMessage(mmoPlayer, chatChannel, chatMessageWithoutCommand, false);
    }

    private void processPlayerMessage(@NotNull McMMOPlayer mmoPlayer, @NotNull ChatChannel chatChannel, @NotNull String rawMessage, boolean isAsync) {
        switch (chatChannel) {
            case ADMIN: {
                this.adminChatMailer.processChatMessage(mmoPlayer.getPlayerAuthor(), rawMessage, isAsync, Permissions.colorChat((Permissible)mmoPlayer.getPlayer()));
                break;
            }
            case PARTY: {
                this.partyChatMailer.processChatMessage(mmoPlayer.getPlayerAuthor(), rawMessage, mmoPlayer.getParty(), isAsync, Permissions.colorChat((Permissible)mmoPlayer.getPlayer()), Misc.isPartyLeader(mmoPlayer));
                break;
            }
        }
    }

    public void processConsoleMessage(@NotNull String rawMessage) {
        this.adminChatMailer.processChatMessage(this.getConsoleAuthor(), rawMessage, false, true);
    }

    public void processConsoleMessage(@NotNull String[] args) {
        this.processConsoleMessage(this.buildChatMessage(args));
    }

    public void processConsoleMessage(@NotNull String rawMessage, @NotNull Party party) {
        this.partyChatMailer.processChatMessage(this.getConsoleAuthor(), rawMessage, party, false, true, false);
    }

    @NotNull
    private Author getConsoleAuthor() {
        return this.consoleAuthor;
    }

    public void setOrToggleChatChannel(@NotNull McMMOPlayer mmoPlayer, @NotNull ChatChannel targetChatChannel) {
        if (targetChatChannel == mmoPlayer.getChatChannel()) {
            mmoPlayer.getPlayer().sendMessage(LocaleLoader.getString("Chat.Channel.Off", StringUtils.getCapitalized(targetChatChannel.toString())));
            mmoPlayer.setChatMode(ChatChannel.NONE);
        } else {
            mmoPlayer.setChatMode(targetChatChannel);
            mmoPlayer.getPlayer().sendMessage(LocaleLoader.getString("Chat.Channel.On", StringUtils.getCapitalized(targetChatChannel.toString())));
        }
    }

    @NotNull
    private String buildChatMessage(@NotNull String[] args) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i + 1 >= args.length) {
                stringBuilder.append(args[i]);
                continue;
            }
            stringBuilder.append(args[i]).append(" ");
        }
        return stringBuilder.toString();
    }

    public boolean isMessageAllowed(@NotNull McMMOPlayer mmoPlayer) {
        switch (mmoPlayer.getChatChannel()) {
            case ADMIN: {
                if (!mmoPlayer.getPlayer().isOp() && !Permissions.adminChat((Permissible)mmoPlayer.getPlayer())) break;
                return true;
            }
            case PARTY: {
                if (mmoPlayer.getParty() == null || !Permissions.partyChat((Permissible)mmoPlayer.getPlayer())) break;
                return true;
            }
            case PARTY_OFFICER: 
            case NONE: {
                return false;
            }
        }
        return false;
    }

    public void sendConsoleMessage(@NotNull Author author, @NotNull TextComponent message) {
        this.consoleAudience.sendMessage((Identity)author, (Component)message);
    }

    public boolean isChatEnabled() {
        return this.isChatEnabled;
    }

    public boolean isChatChannelEnabled(@NotNull ChatChannel chatChannel) {
        if (!this.isChatEnabled) {
            return false;
        }
        switch (chatChannel) {
            case ADMIN: 
            case PARTY: 
            case PARTY_OFFICER: {
                return ChatConfig.getInstance().isChatChannelEnabled(chatChannel);
            }
            case NONE: {
                return true;
            }
        }
        return false;
    }
}

