/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.treasure;

import com.gmail.nossr50.config.BukkitConfig;
import com.gmail.nossr50.datatypes.treasure.EnchantmentTreasure;
import com.gmail.nossr50.datatypes.treasure.FishingTreasure;
import com.gmail.nossr50.datatypes.treasure.FishingTreasureBook;
import com.gmail.nossr50.datatypes.treasure.Rarity;
import com.gmail.nossr50.datatypes.treasure.ShakeTreasure;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.EnchantmentUtils;
import com.gmail.nossr50.util.LogUtils;
import com.gmail.nossr50.util.PotionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

public class FishingTreasureConfig
extends BukkitConfig {
    public static final String FILENAME = "fishing_treasures.yml";
    private static FishingTreasureConfig instance;
    @NotNull
    public HashMap<Rarity, List<FishingTreasure>> fishingRewards = new HashMap();
    @NotNull
    public HashMap<Rarity, List<EnchantmentTreasure>> fishingEnchantments = new HashMap();
    @NotNull
    public HashMap<EntityType, List<ShakeTreasure>> shakeMap = new HashMap();

    private FishingTreasureConfig() {
        super(FILENAME, false);
        this.loadKeys();
        this.validate();
    }

    public static FishingTreasureConfig getInstance() {
        if (instance == null) {
            instance = new FishingTreasureConfig();
        }
        return instance;
    }

    @Override
    protected boolean validateKeys() {
        ArrayList<String> reason = new ArrayList<String>();
        ConfigurationSection enchantment_drop_rates = this.config.getConfigurationSection("Enchantment_Drop_Rates");
        if (enchantment_drop_rates != null) {
            for (String tier : enchantment_drop_rates.getKeys(false)) {
                double totalEnchantDropRate = 0.0;
                double totalItemDropRate = 0.0;
                for (Rarity rarity : Rarity.values()) {
                    double enchantDropRate = this.config.getDouble("Enchantment_Drop_Rates." + tier + "." + rarity.toString());
                    double itemDropRate = this.config.getDouble("Item_Drop_Rates." + tier + "." + rarity);
                    if (enchantDropRate < 0.0 || enchantDropRate > 100.0) {
                        reason.add("The enchant drop rate for " + tier + " items that are " + rarity + "should be between 0.0 and 100.0!");
                    }
                    if (itemDropRate < 0.0 || itemDropRate > 100.0) {
                        reason.add("The item drop rate for " + tier + " items that are " + rarity + "should be between 0.0 and 100.0!");
                    }
                    totalEnchantDropRate += enchantDropRate;
                    totalItemDropRate += itemDropRate;
                }
                if (totalEnchantDropRate < 0.0 || totalEnchantDropRate > 100.0) {
                    reason.add("The total enchant drop rate for " + tier + " should be between 0.0 and 100.0!");
                }
                if (!(totalItemDropRate < 0.0) && !(totalItemDropRate > 100.0)) continue;
                reason.add("The total item drop rate for " + tier + " should be between 0.0 and 100.0!");
            }
        } else {
            mcMMO.p.getLogger().warning("Your fishing treasures config is empty, is this intentional? Delete it to regenerate.");
        }
        return this.noErrorsInConfig(reason);
    }

    @Override
    protected void loadKeys() {
        if (this.config.getConfigurationSection("Treasures") != null) {
            this.backup();
            return;
        }
        this.loadTreasures("Fishing");
        this.loadEnchantments();
        for (EntityType entity : EntityType.values()) {
            if (!entity.isAlive()) continue;
            this.loadTreasures("Shake." + entity);
        }
    }

    private void loadTreasures(@NotNull String type) {
        boolean isFishing = type.equals("Fishing");
        boolean isShake = type.contains("Shake");
        ConfigurationSection treasureSection = this.config.getConfigurationSection(type);
        if (treasureSection == null) {
            return;
        }
        for (Rarity rarity : Rarity.values()) {
            if (this.fishingRewards.containsKey((Object)rarity)) continue;
            this.fishingRewards.put(rarity, new ArrayList());
        }
        for (String treasureName : treasureSection.getKeys(false)) {
            short data;
            ArrayList<String> reason = new ArrayList<String>();
            String[] treasureInfo = treasureName.split("[|]");
            String materialName = treasureInfo[0];
            if (materialName.contains("INVENTORY")) {
                this.addShakeTreasure(new ShakeTreasure(new ItemStack(Material.BEDROCK, 1, 0), 1, this.getInventoryStealDropChance(), this.getInventoryStealDropLevel()), EntityType.PLAYER);
                continue;
            }
            Material material = Material.matchMaterial((String)materialName);
            int amount = this.config.getInt(type + "." + treasureName + ".Amount");
            short s = data = treasureInfo.length == 2 ? Short.parseShort(treasureInfo[1]) : (short)this.config.getInt(type + "." + treasureName + ".Data");
            if (material == null) {
                reason.add("Cannot find matching item type in this version of MC, skipping - " + materialName);
                continue;
            }
            if (amount <= 0) {
                amount = 1;
            }
            if (material.isBlock() && (data > 127 || data < -128)) {
                reason.add("Data of " + treasureName + " is invalid! " + data);
            }
            int xp = this.config.getInt(type + "." + treasureName + ".XP");
            double dropChance = this.config.getDouble(type + "." + treasureName + ".Drop_Chance");
            int dropLevel = this.config.getInt(type + "." + treasureName + ".Drop_Level");
            if (xp < 0) {
                reason.add(treasureName + " has an invalid XP value: " + xp);
            }
            if (dropChance < 0.0) {
                reason.add(treasureName + " has an invalid Drop_Chance: " + dropChance);
            }
            if (dropLevel < 0) {
                reason.add("Fishing Config: " + treasureName + " has an invalid Drop_Level: " + dropLevel);
            }
            Rarity rarity = null;
            if (isFishing) {
                String rarityStr = this.config.getString(type + "." + treasureName + ".Rarity");
                if (rarityStr != null) {
                    rarity = Rarity.getRarity(rarityStr);
                } else {
                    mcMMO.p.getLogger().severe("Please edit your config and add a Rarity definition for - " + treasureName);
                    mcMMO.p.getLogger().severe("Skipping this treasure until rarity is defined - " + treasureName);
                    continue;
                }
            }
            ItemStack item = null;
            String customName = null;
            if (this.hasCustomName(type, treasureName)) {
                customName = this.config.getString(type + "." + treasureName + ".Custom_Name");
            }
            if (materialName.contains("POTION")) {
                boolean upgraded;
                boolean extended;
                Material mat = Material.matchMaterial((String)materialName);
                if (mat == null) {
                    reason.add("Potion format for fishing_treasures.yml has changed");
                    continue;
                }
                item = new ItemStack(mat, amount, data);
                PotionMeta potionMeta = (PotionMeta)item.getItemMeta();
                if (potionMeta == null) {
                    mcMMO.p.getLogger().severe("FishingConfig: Item meta when adding potion to fishing treasure was null, contact the mcMMO devs!");
                    reason.add("FishingConfig: Item meta when adding potion to fishing treasure was null");
                    continue;
                }
                String potionTypeStr = this.config.getString(type + "." + treasureName + ".PotionData.PotionType", "WATER");
                PotionType potionType = PotionUtil.matchPotionType(potionTypeStr, extended = this.config.getBoolean(type + "." + treasureName + ".PotionData.Extended", false), upgraded = this.config.getBoolean(type + "." + treasureName + ".PotionData.Upgraded", false));
                if (potionType == null) {
                    reason.add("FishingConfig: Could not derive potion type from: " + potionTypeStr + ", " + extended + ", " + upgraded);
                    continue;
                }
                PotionUtil.setBasePotionType(potionMeta, potionType, upgraded, extended);
                if (customName != null) {
                    potionMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)customName));
                }
                if (this.config.contains(type + "." + treasureName + ".Lore")) {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String s2 : this.config.getStringList(type + "." + treasureName + ".Lore")) {
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s2));
                    }
                    potionMeta.setLore(lore);
                }
                item.setItemMeta((ItemMeta)potionMeta);
            } else {
                ItemMeta itemMeta;
                if (material == Material.ENCHANTED_BOOK) {
                    item = new ItemStack(material, 1);
                    itemMeta = item.getItemMeta();
                    List allowedEnchantsList = this.config.getStringList(type + "." + treasureName + ".Enchantments_Whitelist");
                    List disallowedEnchantsList = this.config.getStringList(type + "." + treasureName + ".Enchantments_Blacklist");
                    HashSet<Enchantment> blackListedEnchants = new HashSet<Enchantment>();
                    HashSet<Enchantment> whiteListedEnchants = new HashSet<Enchantment>();
                    this.matchAndFillSet(disallowedEnchantsList, blackListedEnchants);
                    this.matchAndFillSet(allowedEnchantsList, whiteListedEnchants);
                    if (customName != null && itemMeta != null) {
                        itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)customName));
                        item.setItemMeta(itemMeta);
                    }
                    FishingTreasureBook fishingTreasureBook = new FishingTreasureBook(item, xp, blackListedEnchants, whiteListedEnchants);
                    this.addFishingTreasure(rarity, fishingTreasureBook);
                    continue;
                }
                item = new ItemStack(material, amount, data);
                if (customName != null) {
                    itemMeta = item.getItemMeta();
                    itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)customName));
                    item.setItemMeta(itemMeta);
                }
                if (this.config.contains(type + "." + treasureName + ".Lore")) {
                    itemMeta = item.getItemMeta();
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String s3 : this.config.getStringList(type + "." + treasureName + ".Lore")) {
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s3));
                    }
                    itemMeta.setLore(lore);
                    item.setItemMeta(itemMeta);
                }
            }
            if (!this.noErrorsInConfig(reason)) continue;
            if (isFishing) {
                this.addFishingTreasure(rarity, new FishingTreasure(item, xp));
                continue;
            }
            if (!isShake) continue;
            ShakeTreasure shakeTreasure = new ShakeTreasure(item, xp, dropChance, dropLevel);
            EntityType entityType = EntityType.valueOf((String)type.substring(6));
            this.addShakeTreasure(shakeTreasure, entityType);
        }
    }

    private void addShakeTreasure(@NotNull ShakeTreasure shakeTreasure, @NotNull EntityType entityType) {
        if (!this.shakeMap.containsKey(entityType)) {
            this.shakeMap.put(entityType, new ArrayList());
        }
        this.shakeMap.get(entityType).add(shakeTreasure);
    }

    private void addFishingTreasure(@NotNull Rarity rarity, @NotNull FishingTreasure fishingTreasure) {
        this.fishingRewards.get((Object)rarity).add(fishingTreasure);
    }

    private boolean hasCustomName(@NotNull String type, @NotNull String treasureName) {
        return this.config.contains(type + "." + treasureName + ".Custom_Name");
    }

    private void matchAndFillSet(@NotNull List<String> enchantListStr, @NotNull Set<Enchantment> permissiveList) {
        if (enchantListStr.isEmpty()) {
            return;
        }
        for (String str : enchantListStr) {
            boolean foundMatch = false;
            for (Enchantment enchantment : Enchantment.values()) {
                if (!enchantment.getKey().getKey().equalsIgnoreCase(str)) continue;
                permissiveList.add(enchantment);
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            LogUtils.debug(mcMMO.p.getLogger(), "[Fishing Treasure Init] Could not find any enchantments which matched the user defined enchantment named: " + str);
        }
    }

    private void loadEnchantments() {
        for (Rarity rarity : Rarity.values()) {
            ConfigurationSection enchantmentSection;
            if (!this.fishingEnchantments.containsKey((Object)rarity)) {
                this.fishingEnchantments.put(rarity, new ArrayList());
            }
            if ((enchantmentSection = this.config.getConfigurationSection("Enchantments_Rarity." + rarity.toString())) == null) {
                return;
            }
            for (String enchantmentName : enchantmentSection.getKeys(false)) {
                int level = this.config.getInt("Enchantments_Rarity." + rarity + "." + enchantmentName);
                Enchantment enchantment = EnchantmentUtils.getByName(enchantmentName);
                if (enchantment == null) {
                    mcMMO.p.getLogger().info("Skipping invalid enchantment in 'fishing_treasures.yml', named:" + enchantmentName);
                    continue;
                }
                this.fishingEnchantments.get((Object)rarity).add(new EnchantmentTreasure(enchantment, level));
            }
        }
    }

    public boolean getInventoryStealEnabled() {
        return this.config.contains("Shake.PLAYER.INVENTORY");
    }

    public boolean getInventoryStealStacks() {
        return this.config.getBoolean("Shake.PLAYER.INVENTORY.Whole_Stacks");
    }

    public double getInventoryStealDropChance() {
        return this.config.getDouble("Shake.PLAYER.INVENTORY.Drop_Chance");
    }

    public int getInventoryStealDropLevel() {
        return this.config.getInt("Shake.PLAYER.INVENTORY.Drop_Level");
    }

    public double getItemDropRate(int tier, @NotNull Rarity rarity) {
        return this.config.getDouble("Item_Drop_Rates.Tier_" + tier + "." + rarity);
    }

    public double getEnchantmentDropRate(int tier, @NotNull Rarity rarity) {
        return this.config.getDouble("Enchantment_Drop_Rates.Tier_" + tier + "." + rarity);
    }
}

