/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config;

import com.gmail.nossr50.mcMMO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.bukkit.World;

public class WorldBlacklist {
    private static ArrayList<String> blacklist;
    private final mcMMO plugin;
    private final String blackListFileName = "world_blacklist.txt";

    public WorldBlacklist(mcMMO plugin) {
        this.plugin = plugin;
        blacklist = new ArrayList();
        this.init();
    }

    public static boolean isWorldBlacklisted(World world) {
        for (String s : blacklist) {
            if (!world.getName().equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public void init() {
        File blackListFile = new File(this.plugin.getDataFolder() + File.separator + "world_blacklist.txt");
        try {
            if (!blackListFile.exists()) {
                blackListFile.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.loadBlacklist(blackListFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBlacklist(File blackListFile) {
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            String currentLine;
            fileReader = new FileReader(blackListFile);
            bufferedReader = new BufferedReader(fileReader);
            while ((currentLine = bufferedReader.readLine()) != null) {
                if (currentLine.length() == 0 || blacklist.contains(currentLine)) continue;
                blacklist.add(currentLine);
            }
            this.closeRead(bufferedReader);
            this.closeRead(fileReader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.closeRead(bufferedReader);
            this.closeRead(fileReader);
        }
        if (blacklist.size() > 0) {
            this.plugin.getLogger().info(blacklist.size() + " entries in mcMMO World Blacklist");
        }
    }

    private void closeRead(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

