/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.player;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.datatypes.experience.SkillXpGain;
import com.gmail.nossr50.datatypes.player.UniqueDataType;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.player.PlayerProfileSaveTask;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.SkillTools;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.DelayQueue;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerProfile {
    private final String playerName;
    @Nullable
    private UUID uuid;
    private boolean loaded;
    private volatile boolean changed;
    private int scoreboardTipsShown;
    private int saveAttempts = 0;
    @Nullable
    private Long lastLogin;
    private final Map<PrimarySkillType, Integer> skills = new EnumMap<PrimarySkillType, Integer>(PrimarySkillType.class);
    private final Map<PrimarySkillType, Float> skillsXp = new EnumMap<PrimarySkillType, Float>(PrimarySkillType.class);
    private final Map<SuperAbilityType, Integer> abilityDATS = new EnumMap<SuperAbilityType, Integer>(SuperAbilityType.class);
    private final Map<UniqueDataType, Integer> uniquePlayerData = new EnumMap<UniqueDataType, Integer>(UniqueDataType.class);
    private final DelayQueue<SkillXpGain> gainedSkillsXp = new DelayQueue();
    private final Map<PrimarySkillType, Float> rollingSkillsXp = new EnumMap<PrimarySkillType, Float>(PrimarySkillType.class);

    @Deprecated
    public PlayerProfile(String playerName) {
        this(playerName, null, 0);
    }

    @Deprecated
    public PlayerProfile(String playerName, UUID uuid) {
        this(playerName, uuid, 0);
    }

    @Deprecated
    public PlayerProfile(String playerName, int startingLevel) {
        this(playerName, null, startingLevel);
    }

    public PlayerProfile(String playerName, @Nullable UUID uuid, int startingLevel) {
        this.uuid = uuid;
        this.playerName = playerName;
        this.scoreboardTipsShown = 0;
        for (SuperAbilityType superAbilityType : SuperAbilityType.values()) {
            this.abilityDATS.put(superAbilityType, 0);
        }
        for (PrimarySkillType primarySkillType : SkillTools.NON_CHILD_SKILLS) {
            this.skills.put(primarySkillType, startingLevel);
            this.skillsXp.put(primarySkillType, Float.valueOf(0.0f));
        }
        this.uniquePlayerData.put(UniqueDataType.CHIMAERA_WING_DATS, 0);
        this.lastLogin = System.currentTimeMillis();
    }

    @Deprecated
    public PlayerProfile(@NotNull String playerName, boolean isLoaded, int startingLvl) {
        this(playerName, startingLvl);
        this.loaded = isLoaded;
    }

    public PlayerProfile(@NotNull String playerName, UUID uuid, boolean isLoaded, int startingLvl) {
        this(playerName, uuid, startingLvl);
        this.loaded = isLoaded;
    }

    public PlayerProfile(@NotNull String playerName, @Nullable UUID uuid, Map<PrimarySkillType, Integer> levelData, Map<PrimarySkillType, Float> xpData, Map<SuperAbilityType, Integer> cooldownData, int scoreboardTipsShown, Map<UniqueDataType, Integer> uniqueProfileData, @Nullable Long lastLogin) {
        this.playerName = playerName;
        this.uuid = uuid;
        this.scoreboardTipsShown = scoreboardTipsShown;
        this.skills.putAll(levelData);
        this.skillsXp.putAll(xpData);
        this.abilityDATS.putAll(cooldownData);
        this.uniquePlayerData.putAll(uniqueProfileData);
        this.loaded = true;
        if (lastLogin != null) {
            this.lastLogin = lastLogin;
        }
    }

    public void scheduleAsyncSave() {
        mcMMO.p.getFoliaLib().getScheduler().runAsync((Consumer)new PlayerProfileSaveTask(this, false));
    }

    public void scheduleAsyncSaveDelay() {
        mcMMO.p.getFoliaLib().getScheduler().runLaterAsync((Consumer)new PlayerProfileSaveTask(this, false), 20L);
    }

    @Deprecated
    public void scheduleSyncSaveDelay() {
        mcMMO.p.getFoliaLib().getScheduler().runLater((Consumer)new PlayerProfileSaveTask(this, true), 20L);
    }

    public void save(boolean useSync) {
        if (!this.changed || !this.loaded) {
            this.saveAttempts = 0;
            return;
        }
        PlayerProfile profileCopy = new PlayerProfile(this.playerName, this.uuid, (Map<PrimarySkillType, Integer>)ImmutableMap.copyOf(this.skills), (Map<PrimarySkillType, Float>)ImmutableMap.copyOf(this.skillsXp), (Map<SuperAbilityType, Integer>)ImmutableMap.copyOf(this.abilityDATS), this.scoreboardTipsShown, (Map<UniqueDataType, Integer>)ImmutableMap.copyOf(this.uniquePlayerData), this.lastLogin);
        boolean bl = this.changed = !mcMMO.getDatabaseManager().saveUser(profileCopy);
        if (this.changed) {
            mcMMO.p.getLogger().severe("PlayerProfile saving failed for player: " + this.playerName + " " + this.uuid);
            if (this.saveAttempts > 0) {
                mcMMO.p.getLogger().severe("Attempted to save profile for player " + this.getPlayerName() + " resulted in failure. " + this.saveAttempts + " have been made so far.");
            }
            if (this.saveAttempts < 10) {
                ++this.saveAttempts;
                if (mcMMO.isServerShutdownExecuted() || useSync) {
                    mcMMO.p.getFoliaLib().getScheduler().runNextTick((Consumer)new PlayerProfileSaveTask(this, true));
                } else {
                    this.scheduleAsyncSave();
                }
            } else {
                mcMMO.p.getLogger().severe("mcMMO has failed to save the profile for " + this.getPlayerName() + " numerous times. mcMMO will now stop attempting to save this profile. Check your console for errors and inspect your DB for issues.");
            }
        } else {
            this.saveAttempts = 0;
        }
    }

    @NotNull
    public Long getLastLogin() {
        return Objects.requireNonNullElse(this.lastLogin, -1L);
    }

    public void updateLastLogin() {
        this.lastLogin = System.currentTimeMillis();
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public void setUniqueId(UUID uuid) {
        this.markProfileDirty();
        this.uuid = uuid;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void markProfileDirty() {
        this.changed = true;
    }

    public int getScoreboardTipsShown() {
        return this.scoreboardTipsShown;
    }

    public void setScoreboardTipsShown(int scoreboardTipsShown) {
        this.markProfileDirty();
        this.scoreboardTipsShown = scoreboardTipsShown;
    }

    public void increaseTipsShown() {
        this.setScoreboardTipsShown(this.getScoreboardTipsShown() + 1);
    }

    public int getChimaerWingDATS() {
        return this.uniquePlayerData.get((Object)UniqueDataType.CHIMAERA_WING_DATS);
    }

    protected void setChimaeraWingDATS(int DATS) {
        this.markProfileDirty();
        this.uniquePlayerData.put(UniqueDataType.CHIMAERA_WING_DATS, DATS);
    }

    public void setUniqueData(UniqueDataType uniqueDataType, int newData) {
        this.markProfileDirty();
        this.uniquePlayerData.put(uniqueDataType, newData);
    }

    public long getUniqueData(UniqueDataType uniqueDataType) {
        return this.uniquePlayerData.get((Object)uniqueDataType).intValue();
    }

    public long getAbilityDATS(SuperAbilityType ability) {
        return this.abilityDATS.get((Object)ability).intValue();
    }

    protected void setAbilityDATS(SuperAbilityType ability, long DATS) {
        this.markProfileDirty();
        this.abilityDATS.put(ability, (int)((double)DATS * 0.001));
    }

    protected void resetCooldowns() {
        this.markProfileDirty();
        this.abilityDATS.replaceAll((a, v) -> 0);
    }

    public int getSkillLevel(PrimarySkillType skill) {
        return SkillTools.isChildSkill(skill) ? this.getChildSkillLevel(skill) : this.skills.get((Object)skill).intValue();
    }

    public float getSkillXpLevelRaw(PrimarySkillType skill) {
        return this.skillsXp.get((Object)skill).floatValue();
    }

    public int getSkillXpLevel(PrimarySkillType skill) {
        if (SkillTools.isChildSkill(skill)) {
            return 0;
        }
        return (int)Math.floor(this.getSkillXpLevelRaw(skill));
    }

    public void setSkillXpLevel(PrimarySkillType skill, float xpLevel) {
        if (SkillTools.isChildSkill(skill)) {
            return;
        }
        this.markProfileDirty();
        this.skillsXp.put(skill, Float.valueOf(xpLevel));
    }

    protected float levelUp(PrimarySkillType skill) {
        float xpRemoved = this.getXpToLevel(skill);
        this.markProfileDirty();
        this.skills.put(skill, this.skills.get((Object)skill) + 1);
        this.skillsXp.put(skill, Float.valueOf(this.skillsXp.get((Object)skill).floatValue() - xpRemoved));
        return xpRemoved;
    }

    public void removeXp(PrimarySkillType skill, int xp) {
        if (SkillTools.isChildSkill(skill)) {
            return;
        }
        this.markProfileDirty();
        this.skillsXp.put(skill, Float.valueOf(this.skillsXp.get((Object)skill).floatValue() - (float)xp));
    }

    public void removeXp(PrimarySkillType skill, float xp) {
        if (SkillTools.isChildSkill(skill)) {
            return;
        }
        this.markProfileDirty();
        this.skillsXp.put(skill, Float.valueOf(this.skillsXp.get((Object)skill).floatValue() - xp));
    }

    public void modifySkill(PrimarySkillType skill, int level) {
        if (SkillTools.isChildSkill(skill)) {
            return;
        }
        this.markProfileDirty();
        if (level < 0) {
            level = 0;
        }
        this.skills.put(skill, level);
        this.skillsXp.put(skill, Float.valueOf(0.0f));
    }

    public void addLevels(PrimarySkillType skill, int levels) {
        this.modifySkill(skill, this.skills.get((Object)skill) + levels);
    }

    public void addXp(PrimarySkillType skill, float xp) {
        this.markProfileDirty();
        if (SkillTools.isChildSkill(skill)) {
            ImmutableList<PrimarySkillType> parentSkills = mcMMO.p.getSkillTools().getChildSkillParents(skill);
            float dividedXP = xp / (float)parentSkills.size();
            for (PrimarySkillType parentSkill : parentSkills) {
                this.skillsXp.put(parentSkill, Float.valueOf(this.skillsXp.get((Object)parentSkill).floatValue() + dividedXP));
            }
        } else {
            this.skillsXp.put(skill, Float.valueOf(this.skillsXp.get((Object)skill).floatValue() + xp));
        }
    }

    public float getRegisteredXpGain(PrimarySkillType primarySkillType) {
        float xp = 0.0f;
        if (this.rollingSkillsXp.get((Object)primarySkillType) != null) {
            xp = this.rollingSkillsXp.get((Object)primarySkillType).floatValue();
        }
        return xp;
    }

    public void registerXpGain(PrimarySkillType primarySkillType, float xp) {
        this.gainedSkillsXp.add(new SkillXpGain(primarySkillType, xp));
        this.rollingSkillsXp.put(primarySkillType, Float.valueOf(this.getRegisteredXpGain(primarySkillType) + xp));
    }

    public void purgeExpiredXpGains() {
        SkillXpGain gain;
        while ((gain = (SkillXpGain)this.gainedSkillsXp.poll()) != null) {
            this.rollingSkillsXp.put(gain.getSkill(), Float.valueOf(this.getRegisteredXpGain(gain.getSkill()) - gain.getXp()));
        }
    }

    public int getXpToLevel(PrimarySkillType primarySkillType) {
        if (SkillTools.isChildSkill(primarySkillType)) {
            return 0;
        }
        int level = ExperienceConfig.getInstance().getCumulativeCurveEnabled() ? UserManager.getPlayer(this.playerName).getPowerLevel() : this.skills.get((Object)primarySkillType).intValue();
        FormulaType formulaType = ExperienceConfig.getInstance().getFormulaType();
        return mcMMO.getFormulaManager().getXPtoNextLevel(level, formulaType);
    }

    private int getChildSkillLevel(@NotNull PrimarySkillType primarySkillType) throws IllegalArgumentException {
        if (!SkillTools.isChildSkill(primarySkillType)) {
            throw new IllegalArgumentException(primarySkillType + " is not a child skill!");
        }
        ImmutableList<PrimarySkillType> parents = mcMMO.p.getSkillTools().getChildSkillParents(primarySkillType);
        int sum = 0;
        for (PrimarySkillType parent : parents) {
            sum += Math.min(this.getSkillLevel(parent), mcMMO.p.getSkillTools().getLevelCap(parent));
        }
        return sum / parents.size();
    }
}

