/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config;

import com.gmail.nossr50.config.LegacyConfigLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public abstract class AutoUpdateLegacyConfigLoader
extends LegacyConfigLoader {
    public AutoUpdateLegacyConfigLoader(String relativePath, String fileName, File dataFolder) {
        super(relativePath, fileName, dataFolder);
    }

    public AutoUpdateLegacyConfigLoader(String fileName, File dataFolder) {
        super(fileName, dataFolder);
    }

    @Deprecated
    public AutoUpdateLegacyConfigLoader(String relativePath, String fileName) {
        super(relativePath, fileName);
    }

    @Deprecated
    public AutoUpdateLegacyConfigLoader(String fileName) {
        super(fileName);
    }

    protected void saveConfig() {
        try {
            LogUtils.debug(mcMMO.p.getLogger(), "Saving changes to config file - " + this.fileName);
            this.config.options().indent(2);
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    protected FileConfiguration getInternalConfig() {
        return YamlConfiguration.loadConfiguration((Reader)mcMMO.p.getResourceAsReader(this.fileName));
    }

    @Override
    protected void loadFile() {
        super.loadFile();
        YamlConfiguration internalConfig = YamlConfiguration.loadConfiguration((Reader)mcMMO.p.getResourceAsReader(this.fileName));
        Set configKeys = this.config.getKeys(true);
        Set internalConfigKeys = internalConfig.getKeys(true);
        boolean needSave = false;
        HashSet oldKeys = new HashSet(configKeys);
        oldKeys.removeAll(internalConfigKeys);
        if (!oldKeys.isEmpty()) {
            LogUtils.debug(mcMMO.p.getLogger(), "old key(s) in \"" + this.fileName + "\"");
            for (Object key : oldKeys) {
                LogUtils.debug(mcMMO.p.getLogger(), "  old-key:" + (String)key);
            }
        }
        HashSet newKeys = new HashSet(internalConfigKeys);
        newKeys.removeAll(configKeys);
        if (!newKeys.isEmpty()) {
            needSave = true;
        }
        for (String key : newKeys) {
            LogUtils.debug(mcMMO.p.getLogger(), "Adding new key: " + key + " = " + internalConfig.get(key));
            this.config.set(key, internalConfig.get(key));
        }
        if (needSave) {
            if (this.dataFolder == null) {
                mcMMO.p.getLogger().severe("Data folder should never be null!");
                return;
            }
            try {
                Object saveName = this.fileName;
                if (!mcMMO.p.getConfig().getBoolean("General.Config_Update_Overwrite", true)) {
                    saveName = (String)saveName + ".new";
                }
                File newSaveFile = new File(this.dataFolder, (String)saveName);
                YamlConfiguration yamlConfiguration = this.config;
                yamlConfiguration.options().indent(4);
                yamlConfiguration.save(newSaveFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

