/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.skills.alchemy;

import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.PotionUtil;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlchemyPotion {
    @NotNull
    private final String potionConfigName;
    @NotNull
    private final ItemStack potionItemStack;
    @NotNull
    private final ItemMeta potionItemMeta;
    @NotNull
    private final Map<ItemStack, String> alchemyPotionChildren;

    public AlchemyPotion(@NotNull String potionConfigName, @NotNull ItemStack potionItemStack, @NotNull Map<ItemStack, String> alchemyPotionChildren) {
        this.potionConfigName = Objects.requireNonNull(potionConfigName, "potionConfigName cannot be null");
        this.potionItemStack = Objects.requireNonNull(potionItemStack, "potionItemStack cannot be null");
        this.alchemyPotionChildren = Objects.requireNonNull(alchemyPotionChildren, "alchemyPotionChildren cannot be null");
        this.potionItemMeta = Objects.requireNonNull(potionItemStack.getItemMeta(), "potionItemMeta cannot be null");
    }

    @NotNull
    public ItemStack toItemStack(int amount) {
        ItemStack clone = this.potionItemStack.clone();
        clone.setAmount(Math.max(1, amount));
        return clone;
    }

    @NotNull
    public Map<ItemStack, String> getAlchemyPotionChildren() {
        return this.alchemyPotionChildren;
    }

    @Nullable
    public AlchemyPotion getChild(@NotNull ItemStack ingredient) {
        if (!this.alchemyPotionChildren.isEmpty()) {
            for (Map.Entry<ItemStack, String> child : this.alchemyPotionChildren.entrySet()) {
                if (!ingredient.isSimilar(child.getKey())) continue;
                return mcMMO.p.getPotionConfig().getPotion(child.getValue());
            }
        }
        return null;
    }

    public boolean isSimilarPotion(@NotNull ItemStack otherPotion) {
        return this.isSimilarPotion(otherPotion, otherPotion.getItemMeta());
    }

    public boolean isSimilarPotion(@NotNull ItemStack otherPotion, @Nullable ItemMeta otherMeta) {
        Objects.requireNonNull(otherPotion, "otherPotion cannot be null");
        if (otherPotion.getType() != this.potionItemStack.getType()) {
            return false;
        }
        if (otherMeta == null) {
            return false;
        }
        PotionMeta otherPotionMeta = (PotionMeta)otherMeta;
        if (this.hasDifferingCustomEffects(this.getAlchemyPotionMeta(), otherPotionMeta) || this.hasDifferingCustomEffects(otherPotionMeta, this.getAlchemyPotionMeta())) {
            return false;
        }
        if (!PotionUtil.samePotionType(this.getAlchemyPotionMeta(), otherPotionMeta)) {
            return false;
        }
        if (!PotionUtil.isPotionDataEqual(this.getAlchemyPotionMeta(), otherPotionMeta)) {
            return false;
        }
        if (!otherPotionMeta.hasLore() && this.getAlchemyPotionMeta().hasLore() || !this.getAlchemyPotionMeta().hasLore() && otherPotionMeta.hasLore()) {
            return false;
        }
        return !otherPotionMeta.hasLore() || !this.getAlchemyPotionMeta().hasLore() || otherPotionMeta.getLore().equals(this.getAlchemyPotionMeta().getLore());
    }

    private boolean hasDifferingCustomEffects(PotionMeta potionMeta, PotionMeta otherPotionMeta) {
        for (int i = 0; i < potionMeta.getCustomEffects().size(); ++i) {
            PotionEffect effect = (PotionEffect)potionMeta.getCustomEffects().get(i);
            if (!otherPotionMeta.hasCustomEffect(effect.getType())) {
                return true;
            }
            PotionEffect otherEffect = (PotionEffect)otherPotionMeta.getCustomEffects().get(i);
            if (effect.getAmplifier() == otherEffect.getAmplifier() && effect.getDuration() == otherEffect.getDuration()) continue;
            return true;
        }
        return false;
    }

    public PotionMeta getAlchemyPotionMeta() {
        return (PotionMeta)this.potionItemMeta;
    }

    public boolean isSplash() {
        return this.potionItemStack.getType() == Material.SPLASH_POTION;
    }

    public boolean isLingering() {
        return this.potionItemStack.getType() == Material.LINGERING_POTION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlchemyPotion that = (AlchemyPotion)o;
        return Objects.equals(this.potionConfigName, that.potionConfigName) && Objects.equals(this.potionItemStack, that.potionItemStack) && Objects.equals(this.alchemyPotionChildren, that.alchemyPotionChildren);
    }

    public int hashCode() {
        return Objects.hash(this.potionConfigName, this.potionItemStack, this.alchemyPotionChildren);
    }

    public String toString() {
        return "AlchemyPotion{potionConfigName='" + this.potionConfigName + "', potionItemStack=" + this.potionItemStack + ", alchemyPotionChildren=" + this.alchemyPotionChildren + "}";
    }
}

