/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.datatypes.MobHealthbarType;
import com.gmail.nossr50.datatypes.meta.OldName;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.MobHealthDisplayUpdaterTask;
import com.gmail.nossr50.util.text.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public final class MobHealthbarUtils {
    private MobHealthbarUtils() {
    }

    public static String fixDeathMessage(String deathMessage, Player player) {
        EntityDamageEvent lastDamageCause = player.getLastDamageCause();
        String replaceString = lastDamageCause instanceof EntityDamageByEntityEvent ? StringUtils.getPrettyEntityTypeString(((EntityDamageByEntityEvent)lastDamageCause).getDamager().getType()) : "a mob";
        return deathMessage.replaceAll("(?:(\u00a7(?:[0-9A-FK-ORa-fk-or]))*(?:[\u2764\u25a0]{1,10})){1,2}", replaceString);
    }

    public static void handleMobHealthbars(LivingEntity target, double damage, mcMMO plugin) {
        if (mcMMO.isHealthBarPluginEnabled() || !mcMMO.p.getGeneralConfig().getMobHealthbarEnabled()) {
            return;
        }
        if (MobHealthbarUtils.isBoss(target) || target instanceof Player) {
            return;
        }
        if (!target.isValid()) {
            return;
        }
        String originalName = target.getName();
        String oldName = target.getCustomName();
        if (target.getMetadata("mcmmo_old_name").size() <= 0) {
            target.setMetadata("mcmmo_old_name", (MetadataValue)new OldName(originalName, plugin));
        }
        if (oldName == null) {
            oldName = "";
        }
        boolean oldNameVisible = target.isCustomNameVisible();
        String newName = MobHealthbarUtils.createHealthDisplay(mcMMO.p.getGeneralConfig().getMobHealthbarDefault(), target, damage);
        target.setCustomName(newName);
        target.setCustomNameVisible(true);
        int displayTime = mcMMO.p.getGeneralConfig().getMobHealthbarTime();
        if (displayTime != -1) {
            boolean updateName;
            boolean bl = updateName = !ChatColor.stripColor((String)oldName).equalsIgnoreCase(ChatColor.stripColor((String)newName));
            if (updateName) {
                target.setMetadata("mcmmo_custom_name", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, (Object)oldName));
                target.setMetadata("mcMMO: Name Visibility", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, (Object)oldNameVisible));
            } else if (!target.hasMetadata("mcmmo_custom_name")) {
                target.setMetadata("mcmmo_custom_name", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, (Object)""));
                target.setMetadata("mcMMO: Name Visibility", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, (Object)false));
            }
            mcMMO.p.getFoliaLib().getScheduler().runAtEntityLater((Entity)target, new MobHealthDisplayUpdaterTask(target), (long)displayTime * 20L);
        }
    }

    private static String createHealthDisplay(MobHealthbarType mobHealthbarType, LivingEntity entity, double damage) {
        int i;
        String symbol;
        int fullDisplay;
        double maxHealth = entity.getMaxHealth();
        double currentHealth = Math.max(entity.getHealth() - damage, 0.0);
        double healthPercentage = currentHealth / maxHealth * 100.0;
        ChatColor color = ChatColor.BLACK;
        switch (mobHealthbarType) {
            case HEARTS: {
                fullDisplay = Math.min((int)(maxHealth / 2.0), 10);
                color = ChatColor.DARK_RED;
                symbol = "\u2764";
                break;
            }
            case BAR: {
                fullDisplay = 10;
                if (healthPercentage >= 85.0) {
                    color = ChatColor.DARK_GREEN;
                } else if (healthPercentage >= 70.0) {
                    color = ChatColor.GREEN;
                } else if (healthPercentage >= 55.0) {
                    color = ChatColor.GOLD;
                } else if (healthPercentage >= 40.0) {
                    color = ChatColor.YELLOW;
                } else if (healthPercentage >= 25.0) {
                    color = ChatColor.RED;
                } else if (healthPercentage >= 0.0) {
                    color = ChatColor.DARK_RED;
                }
                symbol = "\u25a0";
                break;
            }
            default: {
                return null;
            }
        }
        int coloredDisplay = (int)Math.max(Math.ceil((double)fullDisplay * (healthPercentage / 100.0)), 0.5);
        int grayDisplay = fullDisplay - coloredDisplay;
        StringBuilder healthbar = new StringBuilder("" + color);
        for (i = 0; i < coloredDisplay; ++i) {
            healthbar.append(symbol);
        }
        healthbar.append(ChatColor.GRAY);
        for (i = 0; i < grayDisplay; ++i) {
            healthbar.append(symbol);
        }
        return healthbar.toString();
    }

    private static boolean isBoss(LivingEntity livingEntity) {
        switch (livingEntity.getType()) {
            case ENDER_DRAGON: 
            case WITHER: {
                return true;
            }
        }
        return false;
    }
}

