/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database;

import com.gmail.nossr50.api.exceptions.InvalidSkillException;
import com.gmail.nossr50.database.DatabaseManager;
import com.gmail.nossr50.database.FlatFileDataFlag;
import com.gmail.nossr50.database.FlatFileDataProcessor;
import com.gmail.nossr50.database.UserQuery;
import com.gmail.nossr50.database.UserQueryFull;
import com.gmail.nossr50.database.UserQueryName;
import com.gmail.nossr50.database.UserQueryNameImpl;
import com.gmail.nossr50.database.UserQueryType;
import com.gmail.nossr50.database.UserQueryUUID;
import com.gmail.nossr50.database.UserQueryUUIDImpl;
import com.gmail.nossr50.database.flatfile.LeaderboardStatus;
import com.gmail.nossr50.datatypes.database.DatabaseType;
import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.player.UniqueDataType;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.skills.SkillTools;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlatFileDatabaseManager
implements DatabaseManager {
    public static final String IGNORED = "IGNORED";
    public static final String LEGACY_INVALID_OLD_USERNAME = "_INVALID_OLD_USERNAME_'";
    @NotNull
    private final EnumMap<PrimarySkillType, List<PlayerStat>> playerStatHash = new EnumMap(PrimarySkillType.class);
    @NotNull
    private final List<PlayerStat> powerLevels = new ArrayList<PlayerStat>();
    private long lastUpdate = 0L;
    @NotNull
    private final String usersFilePath;
    @NotNull
    private final Logger logger;
    private final long purgeTime;
    private final int startingLevel;
    private final boolean testing;
    private final long UPDATE_WAIT_TIME = 600000L;
    @NotNull
    private final File usersFile;
    private static final Object fileWritingLock = new Object();
    public static final int USERNAME_INDEX = 0;
    public static final int SKILLS_MINING = 1;
    public static final int EXP_MINING = 4;
    public static final int SKILLS_WOODCUTTING = 5;
    public static final int EXP_WOODCUTTING = 6;
    public static final int SKILLS_REPAIR = 7;
    public static final int SKILLS_UNARMED = 8;
    public static final int SKILLS_HERBALISM = 9;
    public static final int SKILLS_EXCAVATION = 10;
    public static final int SKILLS_ARCHERY = 11;
    public static final int SKILLS_SWORDS = 12;
    public static final int SKILLS_AXES = 13;
    public static final int SKILLS_ACROBATICS = 14;
    public static final int EXP_REPAIR = 15;
    public static final int EXP_UNARMED = 16;
    public static final int EXP_HERBALISM = 17;
    public static final int EXP_EXCAVATION = 18;
    public static final int EXP_ARCHERY = 19;
    public static final int EXP_SWORDS = 20;
    public static final int EXP_AXES = 21;
    public static final int EXP_ACROBATICS = 22;
    public static final int SKILLS_TAMING = 24;
    public static final int EXP_TAMING = 25;
    public static final int COOLDOWN_BERSERK = 26;
    public static final int COOLDOWN_GIGA_DRILL_BREAKER = 27;
    public static final int COOLDOWN_TREE_FELLER = 28;
    public static final int COOLDOWN_GREEN_TERRA = 29;
    public static final int COOLDOWN_SERRATED_STRIKES = 30;
    public static final int COOLDOWN_SKULL_SPLITTER = 31;
    public static final int COOLDOWN_SUPER_BREAKER = 32;
    public static final int SKILLS_FISHING = 34;
    public static final int EXP_FISHING = 35;
    public static final int COOLDOWN_BLAST_MINING = 36;
    public static final int LEGACY_LAST_LOGIN = 37;
    public static final int HEALTHBAR = 38;
    public static final int SKILLS_ALCHEMY = 39;
    public static final int EXP_ALCHEMY = 40;
    public static final int UUID_INDEX = 41;
    public static final int SCOREBOARD_TIPS = 42;
    public static final int COOLDOWN_CHIMAERA_WING = 43;
    public static final int OVERHAUL_LAST_LOGIN = 44;
    public static final int EXP_CROSSBOWS = 45;
    public static final int SKILLS_CROSSBOWS = 46;
    public static final int EXP_TRIDENTS = 47;
    public static final int SKILLS_TRIDENTS = 48;
    public static final int COOLDOWN_SUPER_SHOTGUN = 49;
    public static final int COOLDOWN_TRIDENTS = 50;
    public static final int COOLDOWN_ARCHERY = 51;
    public static final int EXP_MACES = 52;
    public static final int SKILLS_MACES = 53;
    public static final int COOLDOWN_MACES = 54;
    public static final int DATA_ENTRY_COUNT = 55;

    FlatFileDatabaseManager(@NotNull File usersFile, @NotNull Logger logger, long purgeTime, int startingLevel, boolean testing) {
        this.usersFile = usersFile;
        this.usersFilePath = usersFile.getPath();
        this.logger = logger;
        this.purgeTime = purgeTime;
        this.startingLevel = startingLevel;
        this.testing = testing;
        if (!usersFile.exists()) {
            this.initEmptyDB();
        }
        if (!testing) {
            List<FlatFileDataFlag> flatFileDataFlags = this.checkFileHealthAndStructure();
            if (flatFileDataFlags != null && !flatFileDataFlags.isEmpty()) {
                logger.info("Detected " + flatFileDataFlags.size() + " data entries which need correction.");
            }
            this.updateLeaderboards();
        }
    }

    FlatFileDatabaseManager(@NotNull String usersFilePath, @NotNull Logger logger, long purgeTime, int startingLevel) {
        this(new File(usersFilePath), logger, purgeTime, startingLevel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int purgePowerlessUsers() {
        int purgedUsers = 0;
        LogUtils.debug(this.logger, "Purging powerless users...");
        BufferedReader in = null;
        OutputStreamWriter out = null;
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(this.usersFilePath));
                StringBuilder writer = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    String[] character = line.split(":");
                    Map<PrimarySkillType, Integer> skills = this.getSkillMapFromLine(character);
                    boolean powerless = true;
                    for (int skill : skills.values()) {
                        if (skill == 0) continue;
                        powerless = false;
                        break;
                    }
                    if (!powerless) {
                        writer.append(line).append("\r\n");
                        continue;
                    }
                    ++purgedUsers;
                }
                out = new FileWriter(this.usersFilePath);
                out.write(writer.toString());
            }
            catch (IOException e) {
                this.logger.severe("Exception while reading " + this.usersFilePath + " (Are you sure you formatted it correctly?)" + e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.logger.info("Purged " + purgedUsers + " users from the database.");
        return purgedUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeOldUsers() {
        int removedPlayers = 0;
        long currentTime = System.currentTimeMillis();
        LogUtils.debug(this.logger, "Purging old users...");
        BufferedReader in = null;
        OutputStreamWriter out = null;
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(this.usersFilePath));
                StringBuilder writer = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    OfflinePlayer player;
                    Object[] character = line.split(":");
                    String uuidString = character[41];
                    UUID uuid = UUID.fromString(uuidString);
                    long lastPlayed = 0L;
                    boolean rewrite = false;
                    try {
                        lastPlayed = Long.parseLong(character[44]);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    if (lastPlayed == -1L && (player = mcMMO.p.getServer().getOfflinePlayer(uuid)).getLastPlayed() != 0L) {
                        lastPlayed = player.getLastPlayed();
                        rewrite = true;
                    }
                    if (lastPlayed < 1L && currentTime - lastPlayed > this.purgeTime) {
                        ++removedPlayers;
                        continue;
                    }
                    if (rewrite) {
                        character[44] = Long.toString(lastPlayed);
                        String newLine = StringUtils.join((Object[])character, (String)":");
                        writer.append(newLine).append("\r\n");
                        continue;
                    }
                    writer.append(line).append("\r\n");
                }
                out = new FileWriter(this.usersFilePath);
                out.write(writer.toString());
                if (this.testing) {
                    System.out.println(writer);
                }
            }
            catch (IOException e) {
                this.logger.severe("Exception while reading " + this.usersFilePath + " (Are you sure you formatted it correctly?)" + e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.logger.info("Purged " + removedPlayers + " users from the database.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUser(String playerName, UUID uuid) {
        boolean worked = false;
        BufferedReader in = null;
        OutputStreamWriter out = null;
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(this.usersFilePath));
                StringBuilder writer = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    if (!worked && line.split(":")[0].equalsIgnoreCase(playerName)) {
                        this.logger.info("User found, removing...");
                        worked = true;
                        continue;
                    }
                    writer.append(line).append("\r\n");
                }
                out = new FileWriter(this.usersFilePath);
                out.write(writer.toString());
            }
            catch (Exception e) {
                this.logger.severe("Exception while reading " + this.usersFilePath + " (Are you sure you formatted it correctly?)" + e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        Misc.profileCleanup(playerName);
        return worked;
    }

    @Override
    public void cleanupUser(UUID uuid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean saveUser(@NotNull PlayerProfile profile) {
        String playerName = profile.getPlayerName();
        UUID uuid = profile.getUniqueId();
        BufferedReader in = null;
        OutputStreamWriter out = null;
        boolean corruptDataFound = false;
        Object object = fileWritingLock;
        synchronized (object) {
            boolean bl;
            try {
                String line;
                in = new BufferedReader(new FileReader(this.usersFilePath));
                StringBuilder writer = new StringBuilder();
                boolean wroteUser = false;
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("#")) {
                        writer.append(line).append("\r\n");
                        continue;
                    }
                    if (!line.contains(":")) {
                        if (corruptDataFound) continue;
                        this.logger.severe("mcMMO found some unexpected or corrupted data in mcmmo.users and is removing it, it is possible some data has been lost.");
                        corruptDataFound = true;
                        continue;
                    }
                    String[] splitData = line.split(":");
                    if (splitData.length < 41) {
                        if (corruptDataFound) continue;
                        this.logger.severe("mcMMO found some unexpected or corrupted data in mcmmo.users and is removing it, it is possible some data has been lost.");
                        corruptDataFound = true;
                        continue;
                    }
                    if (!(uuid != null && splitData[41].equalsIgnoreCase(uuid.toString()) || splitData[0].equalsIgnoreCase(playerName))) {
                        writer.append(line).append("\r\n");
                        continue;
                    }
                    this.writeUserToLine(profile, writer);
                    wroteUser = true;
                }
                if (!wroteUser) {
                    this.writeUserToLine(profile, writer);
                }
                out = new FileWriter(this.usersFilePath);
                out.write(writer.toString());
                bl = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                boolean bl2 = false;
                return bl2;
            }
            return bl;
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void writeUserToLine(@NotNull PlayerProfile profile, @NotNull Appendable appendable) throws IOException {
        appendable.append(profile.getPlayerName()).append(":");
        appendable.append(String.valueOf(profile.getSkillLevel(PrimarySkillType.MINING))).append(":");
        appendable.append(IGNORED).append(":");
        appendable.append(IGNORED).append(":");
        appendable.append(String.valueOf(profile.getSkillXpLevel(PrimarySkillType.MINING))).append(":");
        appendable.append(String.valueOf(profile.getSkillLevel(PrimarySkillType.WOODCUTTING))).append(":");
        appendable.append(String.valueOf(profile.getSkillXpLevel(PrimarySkillType.WOODCUTTING))).append(":");
        appendable.append(String.valueOf(profile.getSkillLevel(PrimarySkillType.REPAIR))).append(":");
        appendable.append(String.valueOf(profile.getSkillLevel(PrimarySkillType.UNARMED))).append(":");
        appendable.append(String.valueOf(profile.getSkillLevel(PrimarySkillType.HERBALISM))).append(":");
        appendable.append(String.valueOf(profile.getSkillLevel(PrimarySkillType.EXCAVATION))).append(":");
        appendable.append(String.valueOf(profile.getSkillLevel(PrimarySkillType.ARCHERY))).append(":");
        appendable.append(String.valueOf(profile.getSkillLevel(PrimarySkillType.SWORDS))).append(":");
        appendable.append(String.valueOf(profile.getSkillLevel(PrimarySkillType.AXES))).append(":");
        appendable.append(String.valueOf(profile.getSkillLevel(PrimarySkillType.ACROBATICS))).append(":");
        appendable.append(String.valueOf(profile.getSkillXpLevel(PrimarySkillType.REPAIR))).append(":");
        appendable.append(String.valueOf(profile.getSkillXpLevel(PrimarySkillType.UNARMED))).append(":");
        appendable.append(String.valueOf(profile.getSkillXpLevel(PrimarySkillType.HERBALISM))).append(":");
        appendable.append(String.valueOf(profile.getSkillXpLevel(PrimarySkillType.EXCAVATION))).append(":");
        appendable.append(String.valueOf(profile.getSkillXpLevel(PrimarySkillType.ARCHERY))).append(":");
        appendable.append(String.valueOf(profile.getSkillXpLevel(PrimarySkillType.SWORDS))).append(":");
        appendable.append(String.valueOf(profile.getSkillXpLevel(PrimarySkillType.AXES))).append(":");
        appendable.append(String.valueOf(profile.getSkillXpLevel(PrimarySkillType.ACROBATICS))).append(":");
        appendable.append(IGNORED).append(":");
        appendable.append(String.valueOf(profile.getSkillLevel(PrimarySkillType.TAMING))).append(":");
        appendable.append(String.valueOf(profile.getSkillXpLevel(PrimarySkillType.TAMING))).append(":");
        appendable.append(String.valueOf(profile.getAbilityDATS(SuperAbilityType.BERSERK))).append(":");
        appendable.append(String.valueOf(profile.getAbilityDATS(SuperAbilityType.GIGA_DRILL_BREAKER))).append(":");
        appendable.append(String.valueOf(profile.getAbilityDATS(SuperAbilityType.TREE_FELLER))).append(":");
        appendable.append(String.valueOf(profile.getAbilityDATS(SuperAbilityType.GREEN_TERRA))).append(":");
        appendable.append(String.valueOf(profile.getAbilityDATS(SuperAbilityType.SERRATED_STRIKES))).append(":");
        appendable.append(String.valueOf(profile.getAbilityDATS(SuperAbilityType.SKULL_SPLITTER))).append(":");
        appendable.append(String.valueOf(profile.getAbilityDATS(SuperAbilityType.SUPER_BREAKER))).append(":");
        appendable.append(IGNORED).append(":");
        appendable.append(String.valueOf(profile.getSkillLevel(PrimarySkillType.FISHING))).append(":");
        appendable.append(String.valueOf(profile.getSkillXpLevel(PrimarySkillType.FISHING))).append(":");
        appendable.append(String.valueOf(profile.getAbilityDATS(SuperAbilityType.BLAST_MINING))).append(":");
        appendable.append(IGNORED).append(":");
        appendable.append(IGNORED).append(":");
        appendable.append(String.valueOf(profile.getSkillLevel(PrimarySkillType.ALCHEMY))).append(":");
        appendable.append(String.valueOf(profile.getSkillXpLevel(PrimarySkillType.ALCHEMY))).append(":");
        appendable.append(profile.getUniqueId() != null ? profile.getUniqueId().toString() : "NULL").append(":");
        appendable.append(String.valueOf(profile.getScoreboardTipsShown())).append(":");
        appendable.append(String.valueOf(profile.getUniqueData(UniqueDataType.CHIMAERA_WING_DATS))).append(":");
        appendable.append(String.valueOf(profile.getLastLogin())).append(":");
        appendable.append(String.valueOf(profile.getSkillXpLevel(PrimarySkillType.CROSSBOWS))).append(":");
        appendable.append(String.valueOf(profile.getSkillLevel(PrimarySkillType.CROSSBOWS))).append(":");
        appendable.append(String.valueOf(profile.getSkillXpLevel(PrimarySkillType.TRIDENTS))).append(":");
        appendable.append(String.valueOf(profile.getSkillLevel(PrimarySkillType.TRIDENTS))).append(":");
        appendable.append(String.valueOf(profile.getAbilityDATS(SuperAbilityType.SUPER_SHOTGUN))).append(":");
        appendable.append(String.valueOf(profile.getAbilityDATS(SuperAbilityType.TRIDENTS_SUPER_ABILITY))).append(":");
        appendable.append(String.valueOf(profile.getAbilityDATS(SuperAbilityType.EXPLOSIVE_SHOT))).append(":");
        appendable.append(String.valueOf(profile.getSkillXpLevel(PrimarySkillType.MACES))).append(":");
        appendable.append(String.valueOf(profile.getSkillLevel(PrimarySkillType.MACES))).append(":");
        appendable.append(String.valueOf(profile.getAbilityDATS(SuperAbilityType.MACES_SUPER_ABILITY))).append(":");
        appendable.append("\r\n");
    }

    @Override
    @NotNull
    public List<PlayerStat> readLeaderboard(@Nullable PrimarySkillType primarySkillType, int pageNumber, int statsPerPage) throws InvalidSkillException {
        if (primarySkillType != null && SkillTools.isChildSkill(primarySkillType)) {
            this.logger.severe("A plugin hooking into mcMMO is being naughty with our database commands, update all plugins that hook into mcMMO and contact their devs!");
            throw new InvalidSkillException("A plugin hooking into mcMMO that you are using is attempting to read leaderboard skills for child skills, child skills do not have leaderboards! This is NOT an mcMMO error!");
        }
        this.updateLeaderboards();
        List<PlayerStat> statsList = primarySkillType == null ? this.powerLevels : this.playerStatHash.get((Object)primarySkillType);
        int fromIndex = (Math.max(pageNumber, 1) - 1) * statsPerPage;
        return statsList.subList(Math.min(fromIndex, statsList.size()), Math.min(fromIndex + statsPerPage, statsList.size()));
    }

    @NotNull
    public HashMap<PrimarySkillType, Integer> readRank(String playerName) {
        this.updateLeaderboards();
        HashMap<PrimarySkillType, Integer> skills = new HashMap<PrimarySkillType, Integer>();
        for (PrimarySkillType skill : SkillTools.NON_CHILD_SKILLS) {
            skills.put(skill, this.getPlayerRank(playerName, this.playerStatHash.get((Object)skill)));
        }
        skills.put(null, this.getPlayerRank(playerName, this.powerLevels));
        return skills;
    }

    @Override
    @NotNull
    public PlayerProfile newUser(@NotNull Player player) {
        return new PlayerProfile(player.getName(), player.getUniqueId(), true, this.startingLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PlayerProfile newUser(@NotNull String playerName, @NotNull UUID uuid) {
        PlayerProfile playerProfile = new PlayerProfile(playerName, uuid, true, this.startingLevel);
        Object object = fileWritingLock;
        synchronized (object) {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.usersFilePath));){
                String line;
                StringBuilder stringBuilder = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuilder.append(line).append("\r\n");
                }
                try (FileWriter fileWriter = new FileWriter(this.usersFile);){
                    this.writeUserToLine(playerProfile, stringBuilder);
                    fileWriter.write(stringBuilder.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return playerProfile;
    }

    @Override
    @NotNull
    public PlayerProfile loadPlayerProfile(@NotNull OfflinePlayer offlinePlayer) {
        return this.processUserQuery(this.getUserQuery(offlinePlayer.getUniqueId(), offlinePlayer.getName()));
    }

    @Override
    @NotNull
    public PlayerProfile loadPlayerProfile(@NotNull String playerName) {
        return this.processUserQuery(this.getUserQuery(null, playerName));
    }

    @Override
    @NotNull
    public PlayerProfile loadPlayerProfile(@NotNull UUID uuid) {
        return this.processUserQuery(this.getUserQuery(uuid, null));
    }

    @NotNull
    private UserQuery getUserQuery(@Nullable UUID uuid, @Nullable String playerName) throws NullPointerException {
        boolean hasName;
        boolean bl = hasName = playerName != null && !playerName.equalsIgnoreCase("null");
        if (hasName && uuid != null) {
            return new UserQueryFull(playerName, uuid);
        }
        if (uuid != null) {
            return new UserQueryUUIDImpl(uuid);
        }
        if (hasName) {
            return new UserQueryNameImpl(playerName);
        }
        throw new NullPointerException("Both name and UUID cannot be null, at least one must be non-null!");
    }

    @NotNull
    private PlayerProfile processUserQuery(@NotNull UserQuery userQuery) throws RuntimeException {
        return switch (userQuery.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case UserQueryType.UUID_AND_NAME -> this.queryByUUIDAndName((UserQueryFull)userQuery);
            case UserQueryType.UUID -> this.queryByUUID((UserQueryUUID)userQuery);
            case UserQueryType.NAME -> this.queryByName((UserQueryNameImpl)userQuery);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private PlayerProfile queryByName(@NotNull UserQueryName userQuery) {
        String playerName = userQuery.getName();
        BufferedReader in = null;
        Object object = fileWritingLock;
        synchronized (object) {
            block19: {
                PlayerProfile playerProfile;
                block18: {
                    try {
                        String line;
                        in = new BufferedReader(new FileReader(this.usersFilePath));
                        while ((line = in.readLine()) != null) {
                            String[] rawSplitData;
                            if (line.startsWith("#") || (rawSplitData = line.split(":")).length < 1 || !playerName.equalsIgnoreCase(rawSplitData[0])) continue;
                            playerProfile = this.loadFromLine(rawSplitData);
                            break block18;
                        }
                        break block19;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break block19;
                    }
                }
                return playerProfile;
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return new PlayerProfile(playerName, new UUID(0L, 0L), this.startingLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private PlayerProfile queryByUUID(@NotNull UserQueryUUID userQuery) {
        String line232;
        BufferedReader in = null;
        UUID uuid = userQuery.getUUID();
        Object object = fileWritingLock;
        // MONITORENTER : object
        in = new BufferedReader(new FileReader(this.usersFilePath));
        while ((line232 = in.readLine()) != null) {
            PlayerProfile playerProfile;
            block21: {
                String[] rawSplitData;
                if (line232.startsWith("#") || (rawSplitData = line232.split(":")).length < 42) continue;
                try {
                    UUID fromDataUUID = UUID.fromString(rawSplitData[41]);
                    if (!fromDataUUID.equals(uuid)) continue;
                    playerProfile = this.loadFromLine(rawSplitData);
                    if (in == null) break block21;
                }
                catch (Exception e) {
                    if (!this.testing) continue;
                    e.printStackTrace();
                    continue;
                }
                try {
                    in.close();
                    return playerProfile;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            // MONITOREXIT : object
            return playerProfile;
        }
        if (in == null) return this.grabUnloadedProfile(uuid, "Player-Not-Found=" + uuid);
        try {
            in.close();
            return this.grabUnloadedProfile(uuid, "Player-Not-Found=" + uuid);
        }
        catch (IOException line232) {
            return this.grabUnloadedProfile(uuid, "Player-Not-Found=" + uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.grabUnloadedProfile(uuid, "Player-Not-Found=" + uuid);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private PlayerProfile queryByUUIDAndName(@NotNull UserQueryFull userQuery) {
        String line232;
        BufferedReader in = null;
        String playerName = userQuery.getName();
        UUID uuid = userQuery.getUUID();
        Object object = fileWritingLock;
        // MONITORENTER : object
        in = new BufferedReader(new FileReader(this.usersFilePath));
        while ((line232 = in.readLine()) != null) {
            PlayerProfile playerProfile;
            block22: {
                String[] rawSplitData;
                if (line232.startsWith("#") || (rawSplitData = line232.split(":")).length < 42) continue;
                try {
                    UUID fromDataUUID = UUID.fromString(rawSplitData[41]);
                    if (!fromDataUUID.equals(uuid)) continue;
                    String dbPlayerName = rawSplitData[0];
                    boolean matchingName = dbPlayerName.equalsIgnoreCase(playerName);
                    if (!matchingName) {
                        this.logger.warning("When loading user: " + playerName + " with UUID of (" + uuid + ") we found a mismatched name, the name in the DB will be replaced (DB name: " + dbPlayerName + ")");
                        rawSplitData[0] = playerName;
                    }
                    playerProfile = this.loadFromLine(rawSplitData);
                    if (in == null) break block22;
                }
                catch (Exception e) {
                    if (!this.testing) continue;
                    e.printStackTrace();
                    continue;
                }
                try {
                    in.close();
                    return playerProfile;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            // MONITOREXIT : object
            return playerProfile;
        }
        if (in == null) return this.grabUnloadedProfile(uuid, playerName);
        try {
            in.close();
            return this.grabUnloadedProfile(uuid, playerName);
        }
        catch (IOException line232) {
            return this.grabUnloadedProfile(uuid, playerName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.grabUnloadedProfile(uuid, playerName);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @NotNull
    private PlayerProfile grabUnloadedProfile(@NotNull UUID uuid, @Nullable String playerName) {
        if (playerName == null) {
            playerName = "";
        }
        return new PlayerProfile(playerName, uuid, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convertUsers(DatabaseManager destination) {
        BufferedReader in = null;
        int convertedUsers = 0;
        long startMillis = System.currentTimeMillis();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(this.usersFilePath));
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    String[] character = line.split(":");
                    try {
                        destination.saveUser(this.loadFromLine(character));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Misc.printProgress(++convertedUsers, 200, startMillis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveUserUUID(String userName, UUID uuid) {
        boolean worked = false;
        int i = 0;
        BufferedReader in = null;
        OutputStreamWriter out = null;
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(this.usersFilePath));
                StringBuilder writer = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    String[] character = line.split(":");
                    if (!worked && character[0].equalsIgnoreCase(userName)) {
                        if (character.length < 42) {
                            this.logger.severe("Could not update UUID for " + userName + "!");
                            this.logger.severe("Database entry is invalid.");
                            continue;
                        }
                        line = line.replace(character[41], uuid.toString());
                        worked = true;
                    }
                    ++i;
                    writer.append(line).append("\r\n");
                }
                out = new FileWriter(this.usersFilePath);
                out.write(writer.toString());
            }
            catch (Exception e) {
                this.logger.severe("Exception while reading " + this.usersFilePath + " (Are you sure you formatted it correctly?)" + e);
            }
            finally {
                LogUtils.debug(this.logger, i + " entries written while saving UUID for " + userName);
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return worked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveUserUUIDs(Map<String, UUID> fetchedUUIDs) {
        BufferedReader in = null;
        OutputStreamWriter out = null;
        int i = 0;
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                Object line;
                in = new BufferedReader(new FileReader(this.usersFilePath));
                StringBuilder writer = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    Object[] character = ((String)line).split(":");
                    if (!fetchedUUIDs.isEmpty() && fetchedUUIDs.containsKey(character[0])) {
                        if (character.length < 42) {
                            this.logger.severe("Could not update UUID for " + character[0] + "!");
                            this.logger.severe("Database entry is invalid.");
                            continue;
                        }
                        character[41] = fetchedUUIDs.remove(character[0]).toString();
                        line = StringUtils.join((Object[])character, (String)":") + ":";
                    }
                    ++i;
                    writer.append((String)line).append("\r\n");
                }
                out = new FileWriter(this.usersFilePath);
                out.write(writer.toString());
            }
            catch (Exception e) {
                this.logger.severe("Exception while reading " + this.usersFilePath + " (Are you sure you formatted it correctly?)" + e);
            }
            finally {
                LogUtils.debug(this.logger, i + " entries written while saving UUID batch");
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getStoredUsers() {
        ArrayList<String> users = new ArrayList<String>();
        BufferedReader in = null;
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(this.usersFilePath));
                while ((line = in.readLine()) != null) {
                    String[] character = line.split(":");
                    users.add(character[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public LeaderboardStatus updateLeaderboards() {
        if (System.currentTimeMillis() < this.lastUpdate + 600000L) {
            return LeaderboardStatus.TOO_SOON_TO_UPDATE;
        }
        this.lastUpdate = System.currentTimeMillis();
        this.powerLevels.clear();
        ArrayList<PlayerStat> mining = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> woodcutting = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> herbalism = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> excavation = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> acrobatics = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> repair = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> swords = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> axes = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> archery = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> unarmed = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> taming = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> fishing = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> alchemy = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> crossbows = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> tridents = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> maces = new ArrayList<PlayerStat>();
        BufferedReader in = null;
        String playerName = null;
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(this.usersFilePath));
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    String[] data = line.split(":");
                    playerName = data[0];
                    int powerLevel = 0;
                    Map<PrimarySkillType, Integer> skills = this.getSkillMapFromLine(data);
                    powerLevel += this.putStat(acrobatics, playerName, skills.get((Object)PrimarySkillType.ACROBATICS));
                    powerLevel += this.putStat(alchemy, playerName, skills.get((Object)PrimarySkillType.ALCHEMY));
                    powerLevel += this.putStat(archery, playerName, skills.get((Object)PrimarySkillType.ARCHERY));
                    powerLevel += this.putStat(axes, playerName, skills.get((Object)PrimarySkillType.AXES));
                    powerLevel += this.putStat(excavation, playerName, skills.get((Object)PrimarySkillType.EXCAVATION));
                    powerLevel += this.putStat(fishing, playerName, skills.get((Object)PrimarySkillType.FISHING));
                    powerLevel += this.putStat(herbalism, playerName, skills.get((Object)PrimarySkillType.HERBALISM));
                    powerLevel += this.putStat(mining, playerName, skills.get((Object)PrimarySkillType.MINING));
                    powerLevel += this.putStat(repair, playerName, skills.get((Object)PrimarySkillType.REPAIR));
                    powerLevel += this.putStat(swords, playerName, skills.get((Object)PrimarySkillType.SWORDS));
                    powerLevel += this.putStat(taming, playerName, skills.get((Object)PrimarySkillType.TAMING));
                    powerLevel += this.putStat(unarmed, playerName, skills.get((Object)PrimarySkillType.UNARMED));
                    powerLevel += this.putStat(woodcutting, playerName, skills.get((Object)PrimarySkillType.WOODCUTTING));
                    powerLevel += this.putStat(crossbows, playerName, skills.get((Object)PrimarySkillType.CROSSBOWS));
                    powerLevel += this.putStat(tridents, playerName, skills.get((Object)PrimarySkillType.TRIDENTS));
                    this.putStat(this.powerLevels, playerName, powerLevel += this.putStat(maces, playerName, skills.get((Object)PrimarySkillType.MACES)));
                }
            }
            catch (Exception e) {
                this.logger.severe("Exception while reading " + this.usersFilePath + " during user " + playerName + " (Are you sure you formatted it correctly?) " + e);
                LeaderboardStatus leaderboardStatus = LeaderboardStatus.FAILED;
                return leaderboardStatus;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        SkillComparator c = new SkillComparator();
        mining.sort(c);
        woodcutting.sort(c);
        repair.sort(c);
        unarmed.sort(c);
        herbalism.sort(c);
        excavation.sort(c);
        archery.sort(c);
        swords.sort(c);
        axes.sort(c);
        acrobatics.sort(c);
        taming.sort(c);
        fishing.sort(c);
        alchemy.sort(c);
        crossbows.sort(c);
        tridents.sort(c);
        maces.sort(c);
        this.powerLevels.sort(c);
        this.playerStatHash.put(PrimarySkillType.MINING, mining);
        this.playerStatHash.put(PrimarySkillType.WOODCUTTING, woodcutting);
        this.playerStatHash.put(PrimarySkillType.REPAIR, repair);
        this.playerStatHash.put(PrimarySkillType.UNARMED, unarmed);
        this.playerStatHash.put(PrimarySkillType.HERBALISM, herbalism);
        this.playerStatHash.put(PrimarySkillType.EXCAVATION, excavation);
        this.playerStatHash.put(PrimarySkillType.ARCHERY, archery);
        this.playerStatHash.put(PrimarySkillType.SWORDS, swords);
        this.playerStatHash.put(PrimarySkillType.AXES, axes);
        this.playerStatHash.put(PrimarySkillType.ACROBATICS, acrobatics);
        this.playerStatHash.put(PrimarySkillType.TAMING, taming);
        this.playerStatHash.put(PrimarySkillType.FISHING, fishing);
        this.playerStatHash.put(PrimarySkillType.ALCHEMY, alchemy);
        this.playerStatHash.put(PrimarySkillType.CROSSBOWS, crossbows);
        this.playerStatHash.put(PrimarySkillType.TRIDENTS, tridents);
        this.playerStatHash.put(PrimarySkillType.MACES, maces);
        return LeaderboardStatus.UPDATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEmptyDB() {
        BufferedWriter bufferedWriter = null;
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(this.usersFilePath, true));
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm");
                LocalDateTime localDateTime = LocalDateTime.now();
                bufferedWriter.append("# mcMMO Database created on ").append(localDateTime.format(dateTimeFormatter)).append("\r\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<FlatFileDataFlag> checkFileHealthAndStructure() {
        ArrayList<FlatFileDataFlag> flagsFound = null;
        LogUtils.debug(this.logger, "(" + this.usersFile.getPath() + ") Validating database file..");
        if (this.usersFile.exists()) {
            BufferedReader bufferedReader = null;
            FileWriter fileWriter = null;
            Object object = fileWritingLock;
            synchronized (object) {
                FlatFileDataProcessor dataProcessor = new FlatFileDataProcessor(this.logger);
                try {
                    String currentLine;
                    String dbCommentDate = null;
                    bufferedReader = new BufferedReader(new FileReader(this.usersFilePath));
                    while ((currentLine = bufferedReader.readLine()) != null) {
                        if (currentLine.startsWith("#") && dbCommentDate == null) {
                            dbCommentDate = currentLine;
                            continue;
                        }
                        if (currentLine.isEmpty()) continue;
                        dataProcessor.processData(currentLine);
                    }
                    if (!dataProcessor.getFlatFileDataFlags().isEmpty()) {
                        flagsFound = new ArrayList<FlatFileDataFlag>(dataProcessor.getFlatFileDataFlags());
                        this.logger.info("Updating FlatFile Database...");
                        fileWriter = new FileWriter(this.usersFilePath);
                        if (dbCommentDate != null) {
                            fileWriter.write(dbCommentDate + "\r\n");
                        }
                        fileWriter.write(dataProcessor.processDataForSave().toString());
                    }
                    this.closeResources(bufferedReader, fileWriter);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    this.closeResources(bufferedReader, fileWriter);
                }
            }
        }
        if (flagsFound == null || flagsFound.isEmpty()) {
            return null;
        }
        return flagsFound;
    }

    private void closeResources(BufferedReader bufferedReader, FileWriter fileWriter) {
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (fileWriter != null) {
            try {
                fileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Integer getPlayerRank(String playerName, List<PlayerStat> statsList) {
        if (statsList == null) {
            return null;
        }
        int currentPos = 1;
        for (PlayerStat stat : statsList) {
            if (stat.name.equalsIgnoreCase(playerName)) {
                return currentPos;
            }
            ++currentPos;
        }
        return null;
    }

    private int putStat(List<PlayerStat> statList, String playerName, int statValue) {
        statList.add(new PlayerStat(playerName, statValue));
        return statValue;
    }

    private PlayerProfile loadFromLine(@NotNull String[] character) {
        long lastLogin;
        int scoreboardTipsShown;
        UUID uuid;
        Map<PrimarySkillType, Integer> skills = this.getSkillMapFromLine(character);
        EnumMap<PrimarySkillType, Float> skillsXp = new EnumMap<PrimarySkillType, Float>(PrimarySkillType.class);
        EnumMap<SuperAbilityType, Integer> skillsDATS = new EnumMap<SuperAbilityType, Integer>(SuperAbilityType.class);
        EnumMap<UniqueDataType, Integer> uniquePlayerDataMap = new EnumMap<UniqueDataType, Integer>(UniqueDataType.class);
        String username = character[0];
        this.tryLoadSkillFloatValuesFromRawData(skillsXp, character, PrimarySkillType.TAMING, 25, username);
        this.tryLoadSkillFloatValuesFromRawData(skillsXp, character, PrimarySkillType.MINING, 4, username);
        this.tryLoadSkillFloatValuesFromRawData(skillsXp, character, PrimarySkillType.REPAIR, 15, username);
        this.tryLoadSkillFloatValuesFromRawData(skillsXp, character, PrimarySkillType.WOODCUTTING, 6, username);
        this.tryLoadSkillFloatValuesFromRawData(skillsXp, character, PrimarySkillType.UNARMED, 16, username);
        this.tryLoadSkillFloatValuesFromRawData(skillsXp, character, PrimarySkillType.HERBALISM, 17, username);
        this.tryLoadSkillFloatValuesFromRawData(skillsXp, character, PrimarySkillType.EXCAVATION, 18, username);
        this.tryLoadSkillFloatValuesFromRawData(skillsXp, character, PrimarySkillType.ARCHERY, 19, username);
        this.tryLoadSkillFloatValuesFromRawData(skillsXp, character, PrimarySkillType.SWORDS, 20, username);
        this.tryLoadSkillFloatValuesFromRawData(skillsXp, character, PrimarySkillType.AXES, 21, username);
        this.tryLoadSkillFloatValuesFromRawData(skillsXp, character, PrimarySkillType.ACROBATICS, 22, username);
        this.tryLoadSkillFloatValuesFromRawData(skillsXp, character, PrimarySkillType.FISHING, 35, username);
        this.tryLoadSkillFloatValuesFromRawData(skillsXp, character, PrimarySkillType.ALCHEMY, 40, username);
        this.tryLoadSkillFloatValuesFromRawData(skillsXp, character, PrimarySkillType.CROSSBOWS, 45, username);
        this.tryLoadSkillFloatValuesFromRawData(skillsXp, character, PrimarySkillType.TRIDENTS, 47, username);
        this.tryLoadSkillFloatValuesFromRawData(skillsXp, character, PrimarySkillType.MACES, 52, username);
        this.tryLoadSkillCooldownFromRawData(skillsDATS, character, SuperAbilityType.SUPER_BREAKER, 32, username);
        this.tryLoadSkillCooldownFromRawData(skillsDATS, character, SuperAbilityType.TREE_FELLER, 28, username);
        this.tryLoadSkillCooldownFromRawData(skillsDATS, character, SuperAbilityType.BERSERK, 26, username);
        this.tryLoadSkillCooldownFromRawData(skillsDATS, character, SuperAbilityType.GREEN_TERRA, 29, username);
        this.tryLoadSkillCooldownFromRawData(skillsDATS, character, SuperAbilityType.GIGA_DRILL_BREAKER, 27, username);
        this.tryLoadSkillCooldownFromRawData(skillsDATS, character, SuperAbilityType.EXPLOSIVE_SHOT, 51, username);
        this.tryLoadSkillCooldownFromRawData(skillsDATS, character, SuperAbilityType.SERRATED_STRIKES, 30, username);
        this.tryLoadSkillCooldownFromRawData(skillsDATS, character, SuperAbilityType.SKULL_SPLITTER, 31, username);
        this.tryLoadSkillCooldownFromRawData(skillsDATS, character, SuperAbilityType.BLAST_MINING, 36, username);
        this.tryLoadSkillCooldownFromRawData(skillsDATS, character, SuperAbilityType.SUPER_SHOTGUN, 49, username);
        this.tryLoadSkillCooldownFromRawData(skillsDATS, character, SuperAbilityType.TRIDENTS_SUPER_ABILITY, 50, username);
        this.tryLoadSkillCooldownFromRawData(skillsDATS, character, SuperAbilityType.MACES_SUPER_ABILITY, 54, username);
        try {
            uuid = UUID.fromString(character[41]);
        }
        catch (Exception e) {
            uuid = null;
        }
        try {
            scoreboardTipsShown = Integer.parseInt(character[42]);
        }
        catch (Exception e) {
            scoreboardTipsShown = 0;
        }
        try {
            uniquePlayerDataMap.put(UniqueDataType.CHIMAERA_WING_DATS, Integer.valueOf(character[43]));
        }
        catch (Exception e) {
            uniquePlayerDataMap.put(UniqueDataType.CHIMAERA_WING_DATS, 0);
        }
        try {
            lastLogin = Long.parseLong(character[44]);
        }
        catch (Exception e) {
            lastLogin = -1L;
        }
        return new PlayerProfile(username, uuid, skills, skillsXp, skillsDATS, scoreboardTipsShown, uniquePlayerDataMap, lastLogin);
    }

    private void tryLoadSkillCooldownFromRawData(@NotNull Map<SuperAbilityType, Integer> cooldownMap, @NotNull String[] splitData, @NotNull SuperAbilityType superAbilityType, int index, @NotNull String userName) {
        try {
            cooldownMap.put(superAbilityType, Integer.valueOf(splitData[index]));
        }
        catch (IndexOutOfBoundsException e) {
            cooldownMap.put(superAbilityType, 0);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Data corruption when trying to load the cooldown for skill " + superAbilityType + " for player named " + userName);
        }
    }

    private void tryLoadSkillFloatValuesFromRawData(@NotNull Map<PrimarySkillType, Float> skillMap, @NotNull String[] character, @NotNull PrimarySkillType primarySkillType, int index, @NotNull String userName) {
        try {
            float valueFromString = Integer.parseInt(character[index]);
            skillMap.put(primarySkillType, Float.valueOf(valueFromString));
        }
        catch (NumberFormatException e) {
            skillMap.put(primarySkillType, Float.valueOf(0.0f));
            this.logger.severe("Data corruption when trying to load the value for skill " + primarySkillType + " for player named " + userName + " setting value to zero");
            e.printStackTrace();
        }
    }

    private void tryLoadSkillIntValuesFromRawData(@NotNull Map<PrimarySkillType, Integer> skillMap, @NotNull String[] character, @NotNull PrimarySkillType primarySkillType, int index, @NotNull String userName) {
        try {
            int valueFromString = Integer.parseInt(character[index]);
            skillMap.put(primarySkillType, valueFromString);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            skillMap.put(primarySkillType, 0);
        }
        catch (NumberFormatException e) {
            skillMap.put(primarySkillType, 0);
            this.logger.severe("Data corruption when trying to load the value for skill " + primarySkillType + " for player named " + userName + " setting value to zero");
            e.printStackTrace();
        }
    }

    @NotNull
    private Map<PrimarySkillType, Integer> getSkillMapFromLine(@NotNull String[] character) {
        EnumMap<PrimarySkillType, Integer> skills = new EnumMap<PrimarySkillType, Integer>(PrimarySkillType.class);
        String username = character[0];
        this.tryLoadSkillIntValuesFromRawData(skills, character, PrimarySkillType.ACROBATICS, 14, username);
        this.tryLoadSkillIntValuesFromRawData(skills, character, PrimarySkillType.TAMING, 24, username);
        this.tryLoadSkillIntValuesFromRawData(skills, character, PrimarySkillType.MINING, 1, username);
        this.tryLoadSkillIntValuesFromRawData(skills, character, PrimarySkillType.REPAIR, 7, username);
        this.tryLoadSkillIntValuesFromRawData(skills, character, PrimarySkillType.WOODCUTTING, 5, username);
        this.tryLoadSkillIntValuesFromRawData(skills, character, PrimarySkillType.UNARMED, 8, username);
        this.tryLoadSkillIntValuesFromRawData(skills, character, PrimarySkillType.HERBALISM, 9, username);
        this.tryLoadSkillIntValuesFromRawData(skills, character, PrimarySkillType.EXCAVATION, 10, username);
        this.tryLoadSkillIntValuesFromRawData(skills, character, PrimarySkillType.ARCHERY, 11, username);
        this.tryLoadSkillIntValuesFromRawData(skills, character, PrimarySkillType.SWORDS, 12, username);
        this.tryLoadSkillIntValuesFromRawData(skills, character, PrimarySkillType.AXES, 13, username);
        this.tryLoadSkillIntValuesFromRawData(skills, character, PrimarySkillType.FISHING, 34, username);
        this.tryLoadSkillIntValuesFromRawData(skills, character, PrimarySkillType.ALCHEMY, 39, username);
        this.tryLoadSkillIntValuesFromRawData(skills, character, PrimarySkillType.CROSSBOWS, 46, username);
        this.tryLoadSkillIntValuesFromRawData(skills, character, PrimarySkillType.TRIDENTS, 48, username);
        this.tryLoadSkillIntValuesFromRawData(skills, character, PrimarySkillType.MACES, 53, username);
        return skills;
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.FLATFILE;
    }

    @NotNull
    public File getUsersFile() {
        return this.usersFile;
    }

    @Override
    public void onDisable() {
    }

    private static class SkillComparator
    implements Comparator<PlayerStat> {
        private SkillComparator() {
        }

        @Override
        public int compare(PlayerStat o1, PlayerStat o2) {
            return o2.statVal - o1.statVal;
        }
    }
}

