/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.items.ChimaeraWingWarmup;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public final class ChimaeraWing {
    private static McMMOPlayer mcMMOPlayer;
    private static Location location;

    private ChimaeraWing() {
    }

    public static void activationCheck(Player player) {
        int timeRemaining;
        int timeRemaining2;
        if (!mcMMO.p.getGeneralConfig().getChimaeraEnabled()) {
            return;
        }
        ItemStack inHand = player.getInventory().getItemInMainHand();
        if (!ItemUtils.isChimaeraWing(inHand)) {
            return;
        }
        if (!Permissions.chimaeraWing((Permissible)player)) {
            NotificationManager.sendPlayerInformation(player, NotificationType.NO_PERMISSION, "mcMMO.NoPermission");
            return;
        }
        mcMMOPlayer = UserManager.getPlayer(player);
        if (mcMMOPlayer == null) {
            return;
        }
        if (mcMMOPlayer.getTeleportCommenceLocation() != null) {
            return;
        }
        int amount = inHand.getAmount();
        if (amount < mcMMO.p.getGeneralConfig().getChimaeraUseCost()) {
            NotificationManager.sendPlayerInformation(player, NotificationType.REQUIREMENTS_NOT_MET, "Item.ChimaeraWing.NotEnough", String.valueOf(mcMMO.p.getGeneralConfig().getChimaeraUseCost() - amount), "Item.ChimaeraWing.Name");
            return;
        }
        long lastTeleport = mcMMOPlayer.getChimeraWingLastUse();
        int cooldown = mcMMO.p.getGeneralConfig().getChimaeraCooldown();
        if (cooldown > 0 && (timeRemaining2 = SkillUtils.calculateTimeLeft(lastTeleport * 1000L, cooldown, player)) > 0) {
            NotificationManager.sendPlayerInformation(player, NotificationType.ABILITY_COOLDOWN, "Item.Generic.Wait", String.valueOf(timeRemaining2));
            return;
        }
        long recentlyHurt = mcMMOPlayer.getRecentlyHurt();
        int hurtCooldown = mcMMO.p.getGeneralConfig().getChimaeraRecentlyHurtCooldown();
        if (hurtCooldown > 0 && (timeRemaining = SkillUtils.calculateTimeLeft(recentlyHurt * 1000L, hurtCooldown, player)) > 0) {
            NotificationManager.sendPlayerInformation(player, NotificationType.ITEM_MESSAGE, "Item.Injured.Wait", String.valueOf(timeRemaining));
            return;
        }
        location = player.getLocation();
        if (mcMMO.p.getGeneralConfig().getChimaeraPreventUseUnderground() && location.getY() < (double)player.getWorld().getHighestBlockYAt(location)) {
            player.getInventory().setItemInMainHand(new ItemStack(ChimaeraWing.getChimaeraWing(amount - mcMMO.p.getGeneralConfig().getChimaeraUseCost())));
            NotificationManager.sendPlayerInformation(player, NotificationType.REQUIREMENTS_NOT_MET, "Item.ChimaeraWing.Fail");
            player.updateInventory();
            player.setVelocity(new Vector(0.0, 0.5, 0.0));
            CombatUtils.dealDamage((LivingEntity)player, Misc.getRandom().nextInt((int)(player.getHealth() - 10.0)));
            mcMMOPlayer.actualizeChimeraWingLastUse();
            return;
        }
        mcMMOPlayer.actualizeTeleportCommenceLocation(player);
        long warmup = mcMMO.p.getGeneralConfig().getChimaeraWarmup();
        if (warmup > 0L) {
            NotificationManager.sendPlayerInformation(player, NotificationType.ITEM_MESSAGE, "Teleport.Commencing", String.valueOf(warmup));
            mcMMO.p.getFoliaLib().getScheduler().runAtEntityLater((Entity)player, new ChimaeraWingWarmup(mcMMOPlayer), 20L * warmup);
        } else {
            ChimaeraWing.chimaeraExecuteTeleport();
        }
    }

    public static void chimaeraExecuteTeleport() {
        Player player = mcMMOPlayer.getPlayer();
        if (mcMMO.p.getGeneralConfig().getChimaeraUseBedSpawn() && player.getBedSpawnLocation() != null) {
            mcMMO.p.getFoliaLib().getScheduler().teleportAsync((Entity)player, player.getBedSpawnLocation());
        } else {
            Location spawnLocation = player.getWorld().getSpawnLocation();
            if (spawnLocation.getBlock().getType() == Material.AIR) {
                mcMMO.p.getFoliaLib().getScheduler().teleportAsync((Entity)player, spawnLocation);
            } else {
                mcMMO.p.getFoliaLib().getScheduler().teleportAsync((Entity)player, player.getWorld().getHighestBlockAt(spawnLocation).getLocation());
            }
        }
        player.getInventory().setItemInMainHand(new ItemStack(ChimaeraWing.getChimaeraWing(player.getInventory().getItemInMainHand().getAmount() - mcMMO.p.getGeneralConfig().getChimaeraUseCost())));
        player.updateInventory();
        mcMMOPlayer.actualizeChimeraWingLastUse();
        mcMMOPlayer.setTeleportCommenceLocation(null);
        if (mcMMO.p.getGeneralConfig().getChimaeraSoundEnabled()) {
            SoundManager.sendSound(player, location, SoundType.CHIMAERA_WING);
        }
        NotificationManager.sendPlayerInformation(player, NotificationType.ITEM_MESSAGE, "Item.ChimaeraWing.Pass");
    }

    public static ItemStack getChimaeraWing(int amount) {
        ItemStack itemStack = new ItemStack(mcMMO.p.getGeneralConfig().getChimaeraItem(), amount);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(ChatColor.GOLD + LocaleLoader.getString("Item.ChimaeraWing.Name"));
        ArrayList<String> itemLore = new ArrayList<String>();
        itemLore.add("mcMMO Item");
        itemLore.add(LocaleLoader.getString("Item.ChimaeraWing.Lore"));
        itemMeta.setLore(itemLore);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ShapelessRecipe getChimaeraWingRecipe() {
        Material ingredient = mcMMO.p.getGeneralConfig().getChimaeraItem();
        int amount = mcMMO.p.getGeneralConfig().getChimaeraRecipeCost();
        ShapelessRecipe chimeraWing = new ShapelessRecipe(new NamespacedKey((Plugin)mcMMO.p, "Chimera"), ChimaeraWing.getChimaeraWing(1));
        chimeraWing.addIngredient(amount, ingredient);
        return chimeraWing;
    }
}

