/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.commands;

import com.gmail.nossr50.commands.McabilityCommand;
import com.gmail.nossr50.commands.McconvertCommand;
import com.gmail.nossr50.commands.McgodCommand;
import com.gmail.nossr50.commands.McmmoCommand;
import com.gmail.nossr50.commands.McnotifyCommand;
import com.gmail.nossr50.commands.McrefreshCommand;
import com.gmail.nossr50.commands.McscoreboardCommand;
import com.gmail.nossr50.commands.XprateCommand;
import com.gmail.nossr50.commands.admin.CompatibilityCommand;
import com.gmail.nossr50.commands.admin.McmmoReloadLocaleCommand;
import com.gmail.nossr50.commands.admin.PlayerDebugCommand;
import com.gmail.nossr50.commands.chat.McChatSpy;
import com.gmail.nossr50.commands.database.McpurgeCommand;
import com.gmail.nossr50.commands.database.McremoveCommand;
import com.gmail.nossr50.commands.database.MmoshowdbCommand;
import com.gmail.nossr50.commands.experience.AddlevelsCommand;
import com.gmail.nossr50.commands.experience.AddxpCommand;
import com.gmail.nossr50.commands.experience.MmoeditCommand;
import com.gmail.nossr50.commands.experience.SkillresetCommand;
import com.gmail.nossr50.commands.party.PartyCommand;
import com.gmail.nossr50.commands.party.teleport.PtpCommand;
import com.gmail.nossr50.commands.player.InspectCommand;
import com.gmail.nossr50.commands.player.McRankCommand;
import com.gmail.nossr50.commands.player.McTopCommand;
import com.gmail.nossr50.commands.player.MccooldownCommand;
import com.gmail.nossr50.commands.player.McstatsCommand;
import com.gmail.nossr50.commands.player.XPBarCommand;
import com.gmail.nossr50.commands.skills.AcrobaticsCommand;
import com.gmail.nossr50.commands.skills.AlchemyCommand;
import com.gmail.nossr50.commands.skills.ArcheryCommand;
import com.gmail.nossr50.commands.skills.AxesCommand;
import com.gmail.nossr50.commands.skills.CrossbowsCommand;
import com.gmail.nossr50.commands.skills.ExcavationCommand;
import com.gmail.nossr50.commands.skills.FishingCommand;
import com.gmail.nossr50.commands.skills.HerbalismCommand;
import com.gmail.nossr50.commands.skills.MacesCommand;
import com.gmail.nossr50.commands.skills.MiningCommand;
import com.gmail.nossr50.commands.skills.MmoInfoCommand;
import com.gmail.nossr50.commands.skills.RepairCommand;
import com.gmail.nossr50.commands.skills.SalvageCommand;
import com.gmail.nossr50.commands.skills.SmeltingCommand;
import com.gmail.nossr50.commands.skills.SwordsCommand;
import com.gmail.nossr50.commands.skills.TamingCommand;
import com.gmail.nossr50.commands.skills.TridentsCommand;
import com.gmail.nossr50.commands.skills.UnarmedCommand;
import com.gmail.nossr50.commands.skills.WoodcuttingCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.text.StringUtils;
import java.util.ArrayList;
import java.util.Locale;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;

public final class CommandRegistrationManager {
    private static final String permissionsMessage = LocaleLoader.getString("mcMMO.NoPermission");

    private CommandRegistrationManager() {
    }

    private static void registerSkillCommands() {
        block20: for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
            if (primarySkillType == PrimarySkillType.MACES && !mcMMO.getCompatibilityManager().getMinecraftGameVersion().isAtLeast(1, 21, 0)) continue;
            String commandName = primarySkillType.toString().toLowerCase(Locale.ENGLISH);
            String localizedName = mcMMO.p.getSkillTools().getLocalizedSkillName(primarySkillType).toLowerCase(Locale.ENGLISH);
            PluginCommand command = mcMMO.p.getCommand(commandName);
            if (command == null) {
                mcMMO.p.getLogger().severe("Command not found: " + commandName);
                continue;
            }
            command.setDescription(LocaleLoader.getString("Commands.Description.Skill", StringUtils.getCapitalized(localizedName)));
            command.setPermission("mcmmo.commands." + commandName);
            command.setPermissionMessage(permissionsMessage);
            command.setUsage(LocaleLoader.getString("Commands.Usage.0", commandName));
            command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.2", commandName, "?", "[" + LocaleLoader.getString("Commands.Usage.Page") + "]"));
            switch (primarySkillType) {
                case ACROBATICS: {
                    command.setExecutor((CommandExecutor)new AcrobaticsCommand());
                    continue block20;
                }
                case ALCHEMY: {
                    command.setExecutor((CommandExecutor)new AlchemyCommand());
                    continue block20;
                }
                case ARCHERY: {
                    command.setExecutor((CommandExecutor)new ArcheryCommand());
                    continue block20;
                }
                case AXES: {
                    command.setExecutor((CommandExecutor)new AxesCommand());
                    continue block20;
                }
                case CROSSBOWS: {
                    command.setExecutor((CommandExecutor)new CrossbowsCommand());
                    continue block20;
                }
                case EXCAVATION: {
                    command.setExecutor((CommandExecutor)new ExcavationCommand());
                    continue block20;
                }
                case FISHING: {
                    command.setExecutor((CommandExecutor)new FishingCommand());
                    continue block20;
                }
                case HERBALISM: {
                    command.setExecutor((CommandExecutor)new HerbalismCommand());
                    continue block20;
                }
                case MACES: {
                    command.setExecutor((CommandExecutor)new MacesCommand());
                    continue block20;
                }
                case MINING: {
                    command.setExecutor((CommandExecutor)new MiningCommand());
                    continue block20;
                }
                case REPAIR: {
                    command.setExecutor((CommandExecutor)new RepairCommand());
                    continue block20;
                }
                case SALVAGE: {
                    command.setExecutor((CommandExecutor)new SalvageCommand());
                    continue block20;
                }
                case SMELTING: {
                    command.setExecutor((CommandExecutor)new SmeltingCommand());
                    continue block20;
                }
                case SWORDS: {
                    command.setExecutor((CommandExecutor)new SwordsCommand());
                    continue block20;
                }
                case TAMING: {
                    command.setExecutor((CommandExecutor)new TamingCommand());
                    continue block20;
                }
                case TRIDENTS: {
                    command.setExecutor((CommandExecutor)new TridentsCommand());
                    continue block20;
                }
                case UNARMED: {
                    command.setExecutor((CommandExecutor)new UnarmedCommand());
                    continue block20;
                }
                case WOODCUTTING: {
                    command.setExecutor((CommandExecutor)new WoodcuttingCommand());
                    continue block20;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + primarySkillType);
                }
            }
        }
    }

    private static void registerAddlevelsCommand() {
        PluginCommand command = mcMMO.p.getCommand("addlevels");
        command.setDescription(LocaleLoader.getString("Commands.Description.addlevels"));
        command.setPermission("mcmmo.commands.addlevels;mcmmo.commands.addlevels.others");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.3.XP", "addlevels", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]", "<" + LocaleLoader.getString("Commands.Usage.Skill") + ">", "<" + LocaleLoader.getString("Commands.Usage.Level") + ">"));
        command.setExecutor((CommandExecutor)new AddlevelsCommand());
    }

    private static void registerAddxpCommand() {
        PluginCommand command = mcMMO.p.getCommand("addxp");
        command.setDescription(LocaleLoader.getString("Commands.Description.addxp"));
        command.setPermission("mcmmo.commands.addxp;mcmmo.commands.addxp.others");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.3.XP", "addxp", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]", "<" + LocaleLoader.getString("Commands.Usage.Skill") + ">", "<" + LocaleLoader.getString("Commands.Usage.XP") + ">"));
        command.setExecutor((CommandExecutor)new AddxpCommand());
    }

    private static void registerMcgodCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcgod");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcgod"));
        command.setPermission("mcmmo.commands.mcgod;mcmmo.commands.mcgod.others");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcgod", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]"));
        command.setExecutor((CommandExecutor)new McgodCommand());
    }

    private static void registerMmoInfoCommand() {
        PluginCommand command = mcMMO.p.getCommand("mmoinfo");
        command.setDescription(LocaleLoader.getString("Commands.Description.mmoinfo"));
        command.setPermission("mcmmo.commands.mmoinfo");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "mmoinfo", "[" + LocaleLoader.getString("Commands.Usage.SubSkill") + "]"));
        command.setExecutor((CommandExecutor)new MmoInfoCommand());
    }

    private static void registerMmoDebugCommand() {
        PluginCommand command = mcMMO.p.getCommand("mmodebug");
        command.setDescription(LocaleLoader.getString("Commands.Description.mmodebug"));
        command.setPermission(null);
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.0", "mmodebug"));
        command.setExecutor((CommandExecutor)new PlayerDebugCommand());
    }

    private static void registerMcChatSpyCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcchatspy");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcchatspy"));
        command.setPermission("mcmmo.commands.mcchatspy;mcmmo.commands.mcchatspy.others");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcchatspy", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]"));
        command.setExecutor((CommandExecutor)new McChatSpy());
    }

    private static void registerMcrefreshCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcrefresh");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcrefresh"));
        command.setPermission("mcmmo.commands.mcrefresh;mcmmo.commands.mcrefresh.others");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcrefresh", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]"));
        command.setExecutor((CommandExecutor)new McrefreshCommand());
    }

    private static void registerMmoeditCommand() {
        PluginCommand command = mcMMO.p.getCommand("mmoedit");
        command.setDescription(LocaleLoader.getString("Commands.Description.mmoedit"));
        command.setPermission("mcmmo.commands.mmoedit;mcmmo.commands.mmoedit.others");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.3.XP", "mmoedit", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]", "<" + LocaleLoader.getString("Commands.Usage.Skill") + ">", "<" + LocaleLoader.getString("Commands.Usage.Level") + ">"));
        command.setExecutor((CommandExecutor)new MmoeditCommand());
    }

    private static void registerSkillresetCommand() {
        PluginCommand command = mcMMO.p.getCommand("skillreset");
        command.setDescription(LocaleLoader.getString("Commands.Description.skillreset"));
        command.setPermission("mcmmo.commands.skillreset;mcmmo.commands.skillreset.others");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.2", "skillreset", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]", "<" + LocaleLoader.getString("Commands.Usage.Skill") + ">"));
        command.setExecutor((CommandExecutor)new SkillresetCommand());
    }

    private static void registerXprateCommand() {
        ArrayList<String> aliasList = new ArrayList<String>();
        aliasList.add("mcxprate");
        PluginCommand command = mcMMO.p.getCommand("xprate");
        command.setDescription(LocaleLoader.getString("Commands.Description.xprate"));
        command.setPermission("mcmmo.commands.xprate;mcmmo.commands.xprate.reset;mcmmo.commands.xprate.set");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.2", "xprate", "<" + LocaleLoader.getString("Commands.Usage.Rate") + ">", "<true|false>"));
        command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "xprate", "reset"));
        command.setAliases(aliasList);
        command.setExecutor((CommandExecutor)new XprateCommand());
    }

    private static void registerInspectCommand() {
        PluginCommand command = mcMMO.p.getCommand("inspect");
        command.setDescription(LocaleLoader.getString("Commands.Description.inspect"));
        command.setPermission("mcmmo.commands.inspect;mcmmo.commands.inspect.far;mcmmo.commands.inspect.offline");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "inspect", "<" + LocaleLoader.getString("Commands.Usage.Player") + ">"));
        command.setExecutor((CommandExecutor)new InspectCommand());
    }

    private static void registerMccooldownCommand() {
        PluginCommand command = mcMMO.p.getCommand("mccooldown");
        command.setDescription(LocaleLoader.getString("Commands.Description.mccooldown"));
        command.setPermission("mcmmo.commands.mccooldown");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.0", "mccooldowns"));
        command.setExecutor((CommandExecutor)new MccooldownCommand());
    }

    private static void registerMcabilityCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcability");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcability"));
        command.setPermission("mcmmo.commands.mcability;mcmmo.commands.mcability.others");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcability", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]"));
        command.setExecutor((CommandExecutor)new McabilityCommand());
    }

    private static void registerMcmmoCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcmmo");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcmmo"));
        command.setPermission("mcmmo.commands.mcmmo.description;mcmmo.commands.mcmmo.help");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.0", "mcmmo"));
        command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "mcmmo", "help"));
        command.setExecutor((CommandExecutor)new McmmoCommand());
    }

    private static void registerMcrankCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcrank");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcrank"));
        command.setPermission("mcmmo.commands.mcrank;mcmmo.commands.mcrank.others;mcmmo.commands.mcrank.others.far;mcmmo.commands.mcrank.others.offline");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcrank", "[" + LocaleLoader.getString("Commands.Usage.Player") + "]"));
        command.setExecutor((CommandExecutor)new McRankCommand());
    }

    private static void registerMcstatsCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcstats");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcstats"));
        command.setPermission("mcmmo.commands.mcstats");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.0", "mcstats"));
        command.setExecutor((CommandExecutor)new McstatsCommand());
    }

    private static void registerMctopCommand() {
        PluginCommand command = mcMMO.p.getCommand("mctop");
        command.setDescription(LocaleLoader.getString("Commands.Description.mctop"));
        command.setPermission("mcmmo.commands.mctop");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.2", "mctop", "[" + LocaleLoader.getString("Commands.Usage.Skill") + "]", "[" + LocaleLoader.getString("Commands.Usage.Page") + "]"));
        command.setExecutor((CommandExecutor)new McTopCommand());
    }

    private static void registerMcpurgeCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcpurge");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcpurge", mcMMO.p.getGeneralConfig().getOldUsersCutoff()));
        command.setPermission("mcmmo.commands.mcpurge");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.0", "mcpurge"));
        command.setExecutor((CommandExecutor)new McpurgeCommand());
    }

    private static void registerMcremoveCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcremove");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcremove"));
        command.setPermission("mcmmo.commands.mcremove");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcremove", "<" + LocaleLoader.getString("Commands.Usage.Player") + ">"));
        command.setExecutor((CommandExecutor)new McremoveCommand());
    }

    private static void registerMmoshowdbCommand() {
        PluginCommand command = mcMMO.p.getCommand("mmoshowdb");
        command.setDescription(LocaleLoader.getString("Commands.Description.mmoshowdb"));
        command.setPermission("mcmmo.commands.mmoshowdb");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.0", "mmoshowdb"));
        command.setExecutor((CommandExecutor)new MmoshowdbCommand());
    }

    private static void registerMcconvertCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcconvert");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcconvert"));
        command.setPermission("mcmmo.commands.mcconvert;mcmmo.commands.mcconvert.experience;mcmmo.commands.mcconvert.database");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.2", "mcconvert", "database", "<flatfile|sql>"));
        command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.2", "mcconvert", "experience", "<linear|exponential>"));
        command.setExecutor((CommandExecutor)new McconvertCommand());
    }

    private static void registerPartyCommand() {
        PluginCommand command = mcMMO.p.getCommand("party");
        command.setDescription(LocaleLoader.getString("Commands.Description.party"));
        command.setPermission("mcmmo.commands.party;mcmmo.commands.party.accept;mcmmo.commands.party.create;mcmmo.commands.party.disband;mcmmo.commands.party.xpshare;mcmmo.commands.party.invite;mcmmo.commands.party.itemshare;mcmmo.commands.party.join;mcmmo.commands.party.kick;mcmmo.commands.party.lock;mcmmo.commands.party.owner;mcmmo.commands.party.password;mcmmo.commands.party.quit;mcmmo.commands.party.rename;mcmmo.commands.party.unlock");
        command.setPermissionMessage(permissionsMessage);
        command.setExecutor((CommandExecutor)new PartyCommand());
    }

    private static void registerPtpCommand() {
        PluginCommand command = mcMMO.p.getCommand("ptp");
        command.setDescription(LocaleLoader.getString("Commands.Description.ptp"));
        command.setPermission("mcmmo.commands.ptp");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "ptp", "<" + LocaleLoader.getString("Commands.Usage.Player") + ">"));
        command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.1", "ptp", "<toggle|accept|acceptall>"));
        command.setExecutor((CommandExecutor)new PtpCommand());
    }

    private static void registerMcnotifyCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcnotify");
        command.setDescription(LocaleLoader.getString("Commands.Description.mcnotify"));
        command.setPermission("mcmmo.commands.mcnotify");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.0", "mcnotify"));
        command.setExecutor((CommandExecutor)new McnotifyCommand());
    }

    private static void registerMcscoreboardCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcscoreboard");
        command.setDescription("Change the current mcMMO scoreboard being displayed");
        command.setPermission("mcmmo.commands.mcscoreboard");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "mcscoreboard", "<CLEAR | KEEP>"));
        command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.2", "mcscoreboard", "time", "<seconds>"));
        command.setExecutor((CommandExecutor)new McscoreboardCommand());
    }

    private static void registerReloadLocaleCommand() {
        PluginCommand command = mcMMO.p.getCommand("mcmmoreloadlocale");
        command.setDescription("Reloads locale");
        command.setPermission("mcmmo.commands.reloadlocale");
        command.setPermissionMessage(permissionsMessage);
        command.setUsage(LocaleLoader.getString("Commands.Usage.0", "mcmmoreloadlocale"));
        command.setExecutor((CommandExecutor)new McmmoReloadLocaleCommand());
    }

    private static void registerCompatibilityCommand() {
        PluginCommand command = mcMMO.p.getCommand("mmocompat");
        command.setDescription(LocaleLoader.getString("Commands.Description.mmocompat"));
        command.setUsage(LocaleLoader.getString("Commands.Usage.0", "mmocompat"));
        command.setExecutor((CommandExecutor)new CompatibilityCommand());
    }

    private static void registerXPBarCommand() {
        PluginCommand command = mcMMO.p.getCommand("mmoxpbar");
        command.setDescription(LocaleLoader.getString("Commands.Description.mmoxpbar"));
        command.setUsage(LocaleLoader.getString("Commands.Usage.1", "mmoxpbar", "<reset | disable>"));
        command.setUsage(command.getUsage() + "\n" + LocaleLoader.getString("Commands.Usage.2", "mmoxpbar", "<show | hide | disable>", "<skillname>"));
        command.setExecutor((CommandExecutor)new XPBarCommand());
    }

    public static void registerCommands() {
        CommandRegistrationManager.registerXPBarCommand();
        CommandRegistrationManager.registerMmoInfoCommand();
        CommandRegistrationManager.registerMmoDebugCommand();
        CommandRegistrationManager.registerMcabilityCommand();
        CommandRegistrationManager.registerMcgodCommand();
        CommandRegistrationManager.registerMcChatSpyCommand();
        CommandRegistrationManager.registerMcmmoCommand();
        CommandRegistrationManager.registerMcnotifyCommand();
        CommandRegistrationManager.registerMcrefreshCommand();
        CommandRegistrationManager.registerMcscoreboardCommand();
        CommandRegistrationManager.registerXprateCommand();
        CommandRegistrationManager.registerMcpurgeCommand();
        CommandRegistrationManager.registerMcremoveCommand();
        CommandRegistrationManager.registerMmoshowdbCommand();
        CommandRegistrationManager.registerMcconvertCommand();
        CommandRegistrationManager.registerAddlevelsCommand();
        CommandRegistrationManager.registerAddxpCommand();
        CommandRegistrationManager.registerMmoeditCommand();
        CommandRegistrationManager.registerSkillresetCommand();
        if (mcMMO.p.getPartyConfig().isPartyEnabled()) {
            CommandRegistrationManager.registerPartyCommand();
            CommandRegistrationManager.registerPtpCommand();
        }
        CommandRegistrationManager.registerInspectCommand();
        CommandRegistrationManager.registerMccooldownCommand();
        CommandRegistrationManager.registerMcrankCommand();
        CommandRegistrationManager.registerMcstatsCommand();
        CommandRegistrationManager.registerMctopCommand();
        CommandRegistrationManager.registerSkillCommands();
        CommandRegistrationManager.registerReloadLocaleCommand();
        CommandRegistrationManager.registerCompatibilityCommand();
    }
}

