/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.subskills.AbstractSubSkill;
import com.gmail.nossr50.listeners.InteractionManager;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.text.TextComponentFactory;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;

public class AcrobaticsCommand
extends SkillCommand {
    private String dodgeChance;
    private String dodgeChanceLucky;
    private boolean canDodge;
    private boolean canRoll;

    public AcrobaticsCommand() {
        super(PrimarySkillType.ACROBATICS);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue) {
        if (this.canDodge) {
            String[] dodgeStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.ACROBATICS_DODGE);
            this.dodgeChance = dodgeStrings[0];
            this.dodgeChanceLucky = dodgeStrings[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canDodge = Permissions.canUseSubSkill(player, SubSkillType.ACROBATICS_DODGE);
        this.canRoll = Permissions.canUseSubSkill(player, SubSkillType.ACROBATICS_ROLL);
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        AbstractSubSkill abstractSubSkill;
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canDodge) {
            messages.add(this.getStatMessage(SubSkillType.ACROBATICS_DODGE, this.dodgeChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.dodgeChanceLucky) : ""));
        }
        if (this.canRoll && (abstractSubSkill = InteractionManager.getAbstractByName("Roll")) != null) {
            String[] rollStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.ACROBATICS_ROLL);
            messages.add(this.getStatMessage(SubSkillType.ACROBATICS_ROLL, rollStrings[0]) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", rollStrings[1]) : ""));
        }
        return messages;
    }

    @Override
    protected List<Component> getTextComponents(Player player) {
        ArrayList<Component> textComponents = new ArrayList<Component>();
        TextComponentFactory.getSubSkillTextComponents(player, textComponents, PrimarySkillType.ACROBATICS);
        return textComponents;
    }
}

