/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillGuideCommand;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.mcmmo.kyori.adventure.text.Component;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import com.gmail.nossr50.util.skills.PerksUtils;
import com.gmail.nossr50.util.skills.SkillTools;
import com.gmail.nossr50.util.text.StringUtils;
import com.gmail.nossr50.util.text.TextComponentFactory;
import com.google.common.collect.ImmutableList;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public abstract class SkillCommand
implements TabExecutor {
    public static final String ABILITY_GENERIC_TEMPLATE_CUSTOM = "Ability.Generic.Template.Custom";
    public static final String ABILITY_GENERIC_TEMPLATE = "Ability.Generic.Template";
    protected PrimarySkillType skill;
    protected DecimalFormat percent = new DecimalFormat("##0.00%", DecimalFormatSymbols.getInstance(Locale.US));
    protected DecimalFormat decimal = new DecimalFormat("##0.00", DecimalFormatSymbols.getInstance(Locale.US));
    protected McMMOPlayer mmoPlayer;
    private final CommandExecutor skillGuideCommand;

    public SkillCommand(PrimarySkillType skill) {
        this.skill = skill;
        this.skillGuideCommand = new SkillGuideCommand(skill);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (CommandUtils.noConsoleUsage(sender)) {
            return true;
        }
        if (!CommandUtils.hasPlayerDataKey(sender)) {
            return true;
        }
        Player player = (Player)sender;
        this.mmoPlayer = UserManager.getPlayer(player);
        if (this.mmoPlayer == null) {
            sender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
            return true;
        }
        if (args.length == 0) {
            boolean isLucky = Permissions.lucky((Permissible)player, this.skill);
            boolean hasEndurance = PerksUtils.handleActivationPerks(player, 0, 0) != 0;
            float skillValue = this.mmoPlayer.getSkillLevel(this.skill);
            if (mcMMO.p.getAdvancedConfig().doesSkillCommandSendBlankLines()) {
                for (int i = 0; i < 2; ++i) {
                    player.sendMessage("");
                }
            }
            this.permissionsCheck(player);
            this.dataCalculations(player, skillValue);
            this.sendSkillCommandHeader(mcMMO.p.getSkillTools().getLocalizedSkillName(this.skill), player, this.mmoPlayer, (int)skillValue);
            List<Component> subskillTextComponents = this.getTextComponents(player);
            player.sendMessage(LocaleLoader.getString("Skills.Overhaul.Header", LocaleLoader.getString("Effects.SubSkills.Overhaul")));
            TextComponentFactory.sendPlayerSubSkillList(player, subskillTextComponents);
            this.getStatMessages(player, isLucky, hasEndurance, skillValue);
            if (mcMMO.p.getGeneralConfig().getUrlLinksEnabled()) {
                player.sendMessage(LocaleLoader.getString("Overhaul.mcMMO.Header"));
                TextComponentFactory.sendPlayerUrlHeader(player);
            }
            if (mcMMO.p.getGeneralConfig().getScoreboardsEnabled() && mcMMO.p.getGeneralConfig().getSkillUseBoard()) {
                ScoreboardManager.enablePlayerSkillScoreboard(player, this.skill);
            }
            return true;
        }
        if ("keep".equals(args[0].toLowerCase())) {
            if (!(mcMMO.p.getGeneralConfig().getAllowKeepBoard() && mcMMO.p.getGeneralConfig().getScoreboardsEnabled() && mcMMO.p.getGeneralConfig().getSkillUseBoard())) {
                sender.sendMessage(LocaleLoader.getString("Commands.Disabled"));
                return true;
            }
            ScoreboardManager.enablePlayerSkillScoreboard(player, this.skill);
            ScoreboardManager.keepBoard(sender.getName());
            sender.sendMessage(LocaleLoader.getString("Commands.Scoreboard.Keep"));
            return true;
        }
        return this.skillGuideCommand.onCommand(sender, command, label, args);
    }

    private void getStatMessages(Player player, boolean isLucky, boolean hasEndurance, float skillValue) {
        List<String> statsMessages = this.statsDisplay(player, skillValue, hasEndurance, isLucky);
        if (!statsMessages.isEmpty()) {
            player.sendMessage(LocaleLoader.getString("Skills.Overhaul.Header", LocaleLoader.getString("Commands.Stats.Self.Overhaul")));
            for (String message : statsMessages) {
                player.sendMessage(message);
            }
        }
        String skillName = mcMMO.p.getSkillTools().getLocalizedSkillName(this.skill);
        player.sendMessage(LocaleLoader.getString("Guides.Available", skillName, skillName.toLowerCase(Locale.ENGLISH)));
    }

    private void sendSkillCommandHeader(String skillName, Player player, McMMOPlayer mcMMOPlayer, int skillValue) {
        player.sendMessage(LocaleLoader.getString("Skills.Overhaul.Header", skillName));
        if (!SkillTools.isChildSkill(this.skill)) {
            player.sendMessage(LocaleLoader.getString("Commands.XPGain.Overhaul", LocaleLoader.getString("Commands.XPGain." + StringUtils.getCapitalized(this.skill.toString()))));
            player.sendMessage(LocaleLoader.getString("Effects.Level.Overhaul", skillValue, mcMMOPlayer.getSkillXpLevel(this.skill), mcMMOPlayer.getXpToLevel(this.skill)));
        } else {
            ImmutableList<PrimarySkillType> parents = mcMMO.p.getSkillTools().getChildSkillParents(this.skill);
            ArrayList<PrimarySkillType> parentList = new ArrayList<PrimarySkillType>((Collection<PrimarySkillType>)parents);
            StringBuilder parentMessage = new StringBuilder();
            for (int i = 0; i < parentList.size(); ++i) {
                if (i + 1 < parentList.size()) {
                    parentMessage.append(LocaleLoader.getString("Effects.Child.ParentList", mcMMO.p.getSkillTools().getLocalizedSkillName(parentList.get(i)), mcMMOPlayer.getSkillLevel(parentList.get(i))));
                    parentMessage.append(ChatColor.GRAY).append(", ");
                    continue;
                }
                parentMessage.append(LocaleLoader.getString("Effects.Child.ParentList", mcMMO.p.getSkillTools().getLocalizedSkillName(parentList.get(i)), mcMMOPlayer.getSkillLevel(parentList.get(i))));
            }
            player.sendMessage(LocaleLoader.getString("Commands.XPGain.Overhaul", LocaleLoader.getString("Commands.XPGain.Child")));
            player.sendMessage(LocaleLoader.getString("Effects.Child.Overhaul", skillValue, parentMessage.toString()));
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            return ImmutableList.of((Object)"?", (Object)"keep");
        }
        return ImmutableList.of();
    }

    protected int calculateRank(float skillValue, int maxLevel, int rankChangeLevel) {
        return Math.min((int)skillValue, maxLevel) / rankChangeLevel;
    }

    protected String[] calculateLengthDisplayValues(Player player, float skillValue) {
        int maxLength = mcMMO.p.getSkillTools().getSuperAbilityMaxLength(mcMMO.p.getSkillTools().getSuperAbility(this.skill));
        int abilityLengthVar = mcMMO.p.getAdvancedConfig().getAbilityLength();
        int abilityLengthCap = mcMMO.p.getAdvancedConfig().getAbilityLengthCap();
        int length = abilityLengthCap <= 0 ? 2 + (int)(skillValue / (float)abilityLengthVar) : 2 + (int)(Math.min((float)abilityLengthCap, skillValue) / (float)abilityLengthVar);
        int enduranceLength = PerksUtils.handleActivationPerks(player, length, maxLength);
        if (maxLength != 0) {
            length = Math.min(length, maxLength);
        }
        return new String[]{String.valueOf(length), String.valueOf(enduranceLength)};
    }

    protected String getStatMessage(SubSkillType subSkillType, String ... vars) {
        return this.getStatMessage(false, false, subSkillType, vars);
    }

    protected String getStatMessage(boolean isExtra, boolean isCustom, @NotNull SubSkillType subSkillType, String ... vars) {
        String statDescriptionKey;
        String templateKey = isCustom ? ABILITY_GENERIC_TEMPLATE_CUSTOM : ABILITY_GENERIC_TEMPLATE;
        String string = statDescriptionKey = !isExtra ? subSkillType.getLocaleKeyStatDescription() : subSkillType.getLocaleKeyStatExtraDescription();
        if (isCustom) {
            return LocaleLoader.getString(templateKey, LocaleLoader.getString(statDescriptionKey, vars));
        }
        Object[] mergedList = NotificationManager.addItemToFirstPositionOfArray(LocaleLoader.getString(statDescriptionKey), vars);
        return LocaleLoader.getString(templateKey, mergedList);
    }

    protected String getLimitBreakDescriptionParameter() {
        if (mcMMO.p.getAdvancedConfig().canApplyLimitBreakPVE()) {
            return "(PVP/PVE)";
        }
        return "(PVP)";
    }

    protected abstract void dataCalculations(Player var1, float var2);

    protected abstract void permissionsCheck(Player var1);

    protected abstract List<String> statsDisplay(Player var1, float var2, boolean var3, boolean var4);

    protected abstract List<Component> getTextComponents(Player var1);
}

