/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.experience;

import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.SkillTools;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class SkillresetCommand
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        switch (args.length) {
            case 1: {
                if (CommandUtils.noConsoleUsage(sender)) {
                    return true;
                }
                if (!this.permissionsCheckSelf(sender)) {
                    sender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (!this.validateArguments(sender, args[0])) {
                    return true;
                }
                PrimarySkillType skill = args[0].equalsIgnoreCase("all") ? null : mcMMO.p.getSkillTools().matchSkill(args[0]);
                this.editValues((Player)sender, UserManager.getPlayer(sender.getName()).getProfile(), skill);
                return true;
            }
            case 2: {
                if (!this.permissionsCheckOthers(sender)) {
                    sender.sendMessage(command.getPermissionMessage());
                    return true;
                }
                if (!this.validateArguments(sender, args[1])) {
                    return true;
                }
                PrimarySkillType skill = args[1].equalsIgnoreCase("all") ? null : mcMMO.p.getSkillTools().matchSkill(args[1]);
                String playerName = CommandUtils.getMatchedPlayerName(args[0]);
                McMMOPlayer mcMMOPlayer = UserManager.getOfflinePlayer(playerName);
                if (mcMMOPlayer == null) {
                    OfflinePlayer offlinePlayer = mcMMO.p.getServer().getOfflinePlayer(playerName);
                    PlayerProfile profile = mcMMO.getDatabaseManager().loadPlayerProfile(offlinePlayer);
                    if (CommandUtils.unloadedProfile(sender, profile) && CommandUtils.unloadedProfile(sender, profile = mcMMO.getDatabaseManager().loadPlayerProfile(playerName))) {
                        return true;
                    }
                    this.editValues(null, profile, skill);
                } else {
                    this.editValues(mcMMOPlayer.getPlayer(), mcMMOPlayer.getProfile(), skill);
                }
                SkillresetCommand.handleSenderMessage(sender, playerName, skill);
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        switch (args.length) {
            case 1: {
                List<String> playerNames = CommandUtils.getOnlinePlayerNames(sender);
                return (List)StringUtil.copyPartialMatches((String)args[0], playerNames, new ArrayList(playerNames.size()));
            }
            case 2: {
                return (List)StringUtil.copyPartialMatches((String)args[1], mcMMO.p.getSkillTools().LOCALIZED_SKILL_NAMES, new ArrayList(mcMMO.p.getSkillTools().LOCALIZED_SKILL_NAMES.size()));
            }
        }
        return ImmutableList.of();
    }

    protected void handleCommand(Player player, PlayerProfile profile, PrimarySkillType skill) {
        int levelsRemoved = profile.getSkillLevel(skill);
        float xpRemoved = profile.getSkillXpLevelRaw(skill);
        profile.modifySkill(skill, 0);
        if (player == null) {
            profile.scheduleAsyncSave();
            return;
        }
        EventUtils.tryLevelChangeEvent(player, skill, levelsRemoved, xpRemoved, false, XPGainReason.COMMAND);
    }

    protected boolean permissionsCheckSelf(CommandSender sender) {
        return Permissions.skillreset((Permissible)sender);
    }

    protected boolean permissionsCheckOthers(CommandSender sender) {
        return Permissions.skillresetOthers((Permissible)sender);
    }

    protected void handlePlayerMessageAll(Player player) {
        player.sendMessage(LocaleLoader.getString("Commands.Reset.All"));
    }

    protected void handlePlayerMessageSkill(Player player, PrimarySkillType skill) {
        player.sendMessage(LocaleLoader.getString("Commands.Reset.Single", mcMMO.p.getSkillTools().getLocalizedSkillName(skill)));
    }

    private boolean validateArguments(CommandSender sender, String skillName) {
        return skillName.equalsIgnoreCase("all") || !CommandUtils.isInvalidSkill(sender, skillName);
    }

    protected static void handleSenderMessage(CommandSender sender, String playerName, PrimarySkillType skill) {
        if (skill == null) {
            sender.sendMessage(LocaleLoader.getString("Commands.addlevels.AwardAll.2", playerName));
        } else {
            sender.sendMessage(LocaleLoader.getString("Commands.addlevels.AwardSkill.2", mcMMO.p.getSkillTools().getLocalizedSkillName(skill), playerName));
        }
    }

    protected void editValues(Player player, PlayerProfile profile, PrimarySkillType skill) {
        if (skill == null) {
            for (PrimarySkillType primarySkillType : SkillTools.NON_CHILD_SKILLS) {
                this.handleCommand(player, profile, primarySkillType);
            }
            if (player != null) {
                this.handlePlayerMessageAll(player);
            }
        } else {
            this.handleCommand(player, profile, skill);
            if (player != null) {
                this.handlePlayerMessageSkill(player, skill);
            }
        }
    }
}

