/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.text.TextComponentFactory;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class SwordsCommand
extends SkillCommand {
    private String counterChance;
    private String counterChanceLucky;
    private String serratedStrikesLength;
    private String serratedStrikesLengthEndurance;
    private String rupturePureTickDamageAgainstPlayers;
    private String rupturePureTickDamageAgainstMobs;
    private String ruptureExplosionDamageAgainstPlayers;
    private String ruptureExplosionDamageAgainstMobs;
    private String ruptureLengthSecondsAgainstPlayers;
    private String ruptureLengthSecondsAgainstMobs;
    private String ruptureChanceToApply;
    private String ruptureChanceToApplyLucky;
    private boolean canCounter;
    private boolean canSerratedStrike;
    private boolean canRupture;

    public SwordsCommand() {
        super(PrimarySkillType.SWORDS);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue) {
        if (this.canCounter) {
            String[] counterStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.SWORDS_COUNTER_ATTACK);
            this.counterChance = counterStrings[0];
            this.counterChanceLucky = counterStrings[1];
        }
        if (this.canRupture) {
            int ruptureRank = RankUtils.getRank(player, SubSkillType.SWORDS_RUPTURE);
            this.ruptureLengthSecondsAgainstPlayers = String.valueOf(mcMMO.p.getAdvancedConfig().getRuptureDurationSeconds(true));
            this.ruptureLengthSecondsAgainstMobs = String.valueOf(mcMMO.p.getAdvancedConfig().getRuptureDurationSeconds(false));
            this.rupturePureTickDamageAgainstPlayers = String.valueOf(mcMMO.p.getAdvancedConfig().getRuptureTickDamage(true, ruptureRank));
            this.rupturePureTickDamageAgainstMobs = String.valueOf(mcMMO.p.getAdvancedConfig().getRuptureTickDamage(false, ruptureRank));
            this.ruptureExplosionDamageAgainstPlayers = String.valueOf(mcMMO.p.getAdvancedConfig().getRuptureExplosionDamage(true, ruptureRank));
            this.ruptureExplosionDamageAgainstMobs = String.valueOf(mcMMO.p.getAdvancedConfig().getRuptureExplosionDamage(false, ruptureRank));
            this.ruptureChanceToApply = String.valueOf(mcMMO.p.getAdvancedConfig().getRuptureChanceToApplyOnHit(ruptureRank) + "%");
            this.ruptureChanceToApplyLucky = String.valueOf(mcMMO.p.getAdvancedConfig().getRuptureChanceToApplyOnHit(ruptureRank) * 1.33);
        }
        if (this.canSerratedStrike) {
            String[] serratedStrikesStrings = this.calculateLengthDisplayValues(player, skillValue);
            this.serratedStrikesLength = serratedStrikesStrings[0];
            this.serratedStrikesLengthEndurance = serratedStrikesStrings[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canRupture = SkillUtils.canUseSubskill(player, SubSkillType.SWORDS_RUPTURE);
        this.canCounter = SkillUtils.canUseSubskill(player, SubSkillType.SWORDS_COUNTER_ATTACK);
        this.canSerratedStrike = RankUtils.hasUnlockedSubskill(player, SubSkillType.SWORDS_SERRATED_STRIKES) && Permissions.serratedStrikes((Permissible)player);
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canCounter) {
            messages.add(this.getStatMessage(SubSkillType.SWORDS_COUNTER_ATTACK, this.counterChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.counterChanceLucky) : ""));
        }
        if (this.canRupture) {
            messages.add(this.getStatMessage(SubSkillType.SWORDS_RUPTURE, this.ruptureChanceToApply) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.ruptureChanceToApplyLucky) : ""));
            messages.add(this.getStatMessage(true, true, SubSkillType.SWORDS_RUPTURE, this.ruptureLengthSecondsAgainstPlayers, this.ruptureLengthSecondsAgainstMobs));
            messages.add(LocaleLoader.getString("Swords.SubSkill.Rupture.Stat.TickDamage", this.rupturePureTickDamageAgainstPlayers, this.rupturePureTickDamageAgainstMobs));
            messages.add(LocaleLoader.getString("Swords.Combat.Rupture.Note.Update.One"));
        }
        if (this.canSerratedStrike) {
            messages.add(this.getStatMessage(SubSkillType.SWORDS_SERRATED_STRIKES, this.serratedStrikesLength) + (hasEndurance ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.serratedStrikesLengthEndurance) : ""));
        }
        if (SkillUtils.canUseSubskill(player, SubSkillType.SWORDS_STAB)) {
            messages.add(this.getStatMessage(SubSkillType.SWORDS_STAB, String.valueOf(this.mmoPlayer.getSwordsManager().getStabDamage())));
        }
        if (SkillUtils.canUseSubskill(player, SubSkillType.SWORDS_SWORDS_LIMIT_BREAK)) {
            messages.add(this.getStatMessage(SubSkillType.SWORDS_SWORDS_LIMIT_BREAK, String.valueOf(CombatUtils.getLimitBreakDamageAgainstQuality(player, SubSkillType.SWORDS_SWORDS_LIMIT_BREAK, 1000))));
        }
        return messages;
    }

    @Override
    protected List<Component> getTextComponents(Player player) {
        ArrayList<Component> textComponents = new ArrayList<Component>();
        TextComponentFactory.getSubSkillTextComponents(player, textComponents, PrimarySkillType.SWORDS);
        return textComponents;
    }
}

