/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.crossbows;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.util.MetadataConstants;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.ProjectileUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import org.bukkit.Location;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class CrossbowsManager
extends SkillManager {
    public CrossbowsManager(McMMOPlayer mmoPlayer) {
        super(mmoPlayer, PrimarySkillType.CROSSBOWS);
    }

    public void handleRicochet(@NotNull Plugin pluginRef, @NotNull Arrow arrow, @NotNull Vector hitBlockNormal) {
        if (!ProjectileUtils.isCrossbowProjectile(arrow)) {
            return;
        }
        if (!Permissions.trickShot((Permissible)this.mmoPlayer.getPlayer())) {
            return;
        }
        this.spawnReflectedArrow(pluginRef, arrow, arrow.getLocation(), hitBlockNormal);
    }

    private void spawnReflectedArrow(@NotNull Plugin pluginRef, @NotNull Arrow originalArrow, @NotNull Location origin, @NotNull Vector normal) {
        int bounceCount = 0;
        if (originalArrow.hasMetadata("mcMMO: Arrow Bounce Count") && (bounceCount = ((MetadataValue)originalArrow.getMetadata("mcMMO: Arrow Bounce Count").get(0)).asInt()) >= this.getTrickShotMaxBounceCount()) {
            return;
        }
        ProjectileSource originalArrowShooter = originalArrow.getShooter();
        Vector arrowInBlockVector = originalArrow.getVelocity();
        Vector reflectedDirection = arrowInBlockVector.subtract(normal.multiply(2.0 * arrowInBlockVector.dot(normal)));
        Vector inverseNormal = normal.multiply(-1);
        if (bounceCount == 0 && (double)arrowInBlockVector.angle(inverseNormal) < 0.7853981633974483) {
            return;
        }
        Arrow spawnedArrow = originalArrow.getWorld().spawnArrow(origin, reflectedDirection, 1.0f, 1.0f);
        spawnedArrow.setShooter(originalArrowShooter);
        spawnedArrow.setCritical(originalArrow.isCritical());
        spawnedArrow.setPierceLevel(originalArrow.getPierceLevel());
        spawnedArrow.setPickupStatus(originalArrow.getPickupStatus());
        spawnedArrow.setKnockbackStrength(originalArrow.getKnockbackStrength());
        ProjectileUtils.copyArrowMetadata(pluginRef, originalArrow, spawnedArrow);
        originalArrow.remove();
        spawnedArrow.setMetadata("mcMMO: Arrow Bounce Count", (MetadataValue)new FixedMetadataValue(pluginRef, (Object)(bounceCount + 1)));
        spawnedArrow.setMetadata("mcMMO: Spawned Arrow", (MetadataValue)new FixedMetadataValue(pluginRef, (Object)originalArrowShooter));
        if (!spawnedArrow.hasMetadata("mcMMO: Crossbow Projectile")) {
            spawnedArrow.setMetadata("mcMMO: Crossbow Projectile", (MetadataValue)MetadataConstants.MCMMO_METADATA_VALUE);
        }
        spawnedArrow.setShotFromCrossbow(true);
        if (spawnedArrow.hasMetadata("mcMMO: Multi-shot Arrow") || spawnedArrow.hasMetadata("mcMMO: Infinite Arrow")) {
            spawnedArrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
        }
        CombatUtils.delayArrowMetaCleanup(spawnedArrow);
    }

    public int getTrickShotMaxBounceCount() {
        return RankUtils.getRank(this.mmoPlayer, SubSkillType.CROSSBOWS_TRICK_SHOT);
    }

    public double getPoweredShotBonusDamage(Player player, double oldDamage) {
        double damageBonusPercent = this.getDamageBonusPercent(player);
        double newDamage = oldDamage + oldDamage * damageBonusPercent;
        return Math.min(newDamage, oldDamage + mcMMO.p.getAdvancedConfig().getPoweredShotDamageMax());
    }

    public double getDamageBonusPercent(Player player) {
        return (double)RankUtils.getRank(player, SubSkillType.CROSSBOWS_POWERED_SHOT) * mcMMO.p.getAdvancedConfig().getPoweredShotRankDamageMultiplier() / 100.0;
    }

    public double poweredShot(double oldDamage) {
        if (ProbabilityUtil.isNonRNGSkillActivationSuccessful(SubSkillType.CROSSBOWS_POWERED_SHOT, this.mmoPlayer)) {
            return this.getPoweredShotBonusDamage(this.getPlayer(), oldDamage);
        }
        return oldDamage;
    }
}

