/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.skills.salvage;

import com.gmail.nossr50.config.BukkitConfig;
import com.gmail.nossr50.datatypes.database.UpgradeType;
import com.gmail.nossr50.datatypes.skills.ItemType;
import com.gmail.nossr50.datatypes.skills.MaterialType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.salvage.salvageables.Salvageable;
import com.gmail.nossr50.skills.salvage.salvageables.SalvageableFactory;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.LogUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class SalvageConfig
extends BukkitConfig {
    private final HashSet<String> notSupported = new HashSet();
    private Set<Salvageable> salvageables;

    public SalvageConfig(String fileName, boolean copyDefaults) {
        super(fileName, copyDefaults);
        this.loadKeys();
    }

    @Override
    protected void loadKeys() {
        this.salvageables = new HashSet<Salvageable>();
        if (!this.config.isConfigurationSection("Salvageables")) {
            mcMMO.p.getLogger().severe("Could not find Salvageables section in " + this.fileName);
            return;
        }
        ConfigurationSection section = this.config.getConfigurationSection("Salvageables");
        Set keys = section.getKeys(false);
        if (mcMMO.getUpgradeManager().shouldUpgrade(UpgradeType.FIX_NETHERITE_SALVAGE_QUANTITIES)) {
            mcMMO.p.getLogger().log(Level.INFO, "Fixing incorrect Salvage quantities on Netherite gear, this will only run once...");
            for (String namespacedkey : mcMMO.getMaterialMapStore().getNetheriteArmor()) {
                this.config.set("Salvageables." + namespacedkey.toUpperCase() + ".MaximumQuantity", (Object)4);
            }
            try {
                this.config.save(this.getFile());
                mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.FIX_NETHERITE_SALVAGE_QUANTITIES);
                LogUtils.debug(mcMMO.p.getLogger(), "Fixed incorrect Salvage quantities for Netherite gear!");
            }
            catch (IOException e) {
                LogUtils.debug(mcMMO.p.getLogger(), "Unable to fix Salvage config, please delete the salvage yml file to generate a new one.");
                e.printStackTrace();
            }
        }
        for (String key : keys) {
            int configMaximumQuantity;
            int maximumQuantity;
            Material salvageMaterial;
            ArrayList<String> reason = new ArrayList<String>();
            Material itemMaterial = Material.matchMaterial((String)key);
            if (itemMaterial == null) {
                this.notSupported.add(key);
                continue;
            }
            MaterialType salvageMaterialType = MaterialType.OTHER;
            String salvageMaterialTypeString = this.config.getString("Salvageables." + key + ".MaterialType", "OTHER");
            if (!this.config.contains("Salvageables." + key + ".MaterialType") && itemMaterial != null) {
                ItemStack salvageItem = new ItemStack(itemMaterial);
                if (ItemUtils.isWoodTool(salvageItem)) {
                    salvageMaterialType = MaterialType.WOOD;
                } else if (ItemUtils.isStoneTool(salvageItem)) {
                    salvageMaterialType = MaterialType.STONE;
                } else if (ItemUtils.isStringTool(salvageItem)) {
                    salvageMaterialType = MaterialType.STRING;
                } else if (ItemUtils.isPrismarineTool(salvageItem)) {
                    salvageMaterialType = MaterialType.PRISMARINE;
                } else if (ItemUtils.isLeatherArmor(salvageItem)) {
                    salvageMaterialType = MaterialType.LEATHER;
                } else if (ItemUtils.isIronArmor(salvageItem) || ItemUtils.isIronTool(salvageItem)) {
                    salvageMaterialType = MaterialType.IRON;
                } else if (ItemUtils.isGoldArmor(salvageItem) || ItemUtils.isGoldTool(salvageItem)) {
                    salvageMaterialType = MaterialType.GOLD;
                } else if (ItemUtils.isDiamondArmor(salvageItem) || ItemUtils.isDiamondTool(salvageItem)) {
                    salvageMaterialType = MaterialType.DIAMOND;
                } else if (ItemUtils.isNetheriteTool(salvageItem) || ItemUtils.isNetheriteArmor(salvageItem)) {
                    salvageMaterialType = MaterialType.NETHERITE;
                }
            } else {
                try {
                    salvageMaterialType = MaterialType.valueOf(salvageMaterialTypeString.replace(" ", "_").toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException ex) {
                    reason.add(key + " has an invalid MaterialType of " + salvageMaterialTypeString);
                }
            }
            String salvageMaterialName = this.config.getString("Salvageables." + key + ".SalvageMaterial");
            Material material = salvageMaterial = salvageMaterialName == null ? salvageMaterialType.getDefaultMaterial() : Material.matchMaterial((String)salvageMaterialName);
            if (salvageMaterial == null) {
                this.notSupported.add(key);
                continue;
            }
            short maximumDurability = itemMaterial != null ? itemMaterial.getMaxDurability() : (short)this.config.getInt("Salvageables." + key + ".MaximumDurability");
            ItemType salvageItemType = ItemType.OTHER;
            String salvageItemTypeString = this.config.getString("Salvageables." + key + ".ItemType", "OTHER");
            if (!this.config.contains("Salvageables." + key + ".ItemType") && itemMaterial != null) {
                ItemStack salvageItem = new ItemStack(itemMaterial);
                if (ItemUtils.isMinecraftTool(salvageItem)) {
                    salvageItemType = ItemType.TOOL;
                } else if (ItemUtils.isArmor(salvageItem)) {
                    salvageItemType = ItemType.ARMOR;
                }
            } else {
                try {
                    salvageItemType = ItemType.valueOf(salvageItemTypeString.replace(" ", "_").toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException ex) {
                    reason.add(key + " has an invalid ItemType of " + salvageItemTypeString);
                }
            }
            int minimumLevel = this.config.getInt("Salvageables." + key + ".MinimumLevel");
            double xpMultiplier = this.config.getDouble("Salvageables." + key + ".XpMultiplier", 1.0);
            if (minimumLevel < 0) {
                reason.add(key + " has an invalid MinimumLevel of " + minimumLevel);
            }
            int n = maximumQuantity = itemMaterial != null ? SkillUtils.getRepairAndSalvageQuantities(itemMaterial, salvageMaterial) : this.config.getInt("Salvageables." + key + ".MaximumQuantity", 1);
            if (maximumQuantity <= 0 && itemMaterial != null) {
                maximumQuantity = this.config.getInt("Salvageables." + key + ".MaximumQuantity", 1);
            }
            if ((configMaximumQuantity = this.config.getInt("Salvageables." + key + ".MaximumQuantity", -1)) > 0) {
                maximumQuantity = configMaximumQuantity;
            }
            if (maximumQuantity <= 0) {
                reason.add("Maximum quantity of " + key + " must be greater than 0!");
            }
            if (!this.noErrorsInSalvageable(reason)) continue;
            Salvageable salvageable = SalvageableFactory.getSalvageable(itemMaterial, salvageMaterial, minimumLevel, maximumQuantity, maximumDurability, salvageItemType, salvageMaterialType, xpMultiplier);
            this.salvageables.add(salvageable);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.notSupported.size() > 0) {
            stringBuilder.append("mcMMO found the following materials in the Salvage config that are not supported by the version of Minecraft running on this server: ");
            Iterator<String> iterator = this.notSupported.iterator();
            while (iterator.hasNext()) {
                String unsupportedMaterial = iterator.next();
                if (!iterator.hasNext()) {
                    stringBuilder.append(unsupportedMaterial);
                    continue;
                }
                stringBuilder.append(unsupportedMaterial).append(", ");
            }
            LogUtils.debug(mcMMO.p.getLogger(), stringBuilder.toString());
            LogUtils.debug(mcMMO.p.getLogger(), "Items using materials that are not supported will simply be skipped.");
        }
    }

    protected Collection<Salvageable> getLoadedSalvageables() {
        return this.salvageables == null ? new HashSet() : this.salvageables;
    }

    private boolean noErrorsInSalvageable(List<String> issues) {
        if (!issues.isEmpty()) {
            mcMMO.p.getLogger().warning("Errors have been found in: " + this.fileName);
            mcMMO.p.getLogger().warning("The following issues were found:");
        }
        for (String issue : issues) {
            mcMMO.p.getLogger().warning(issue);
        }
        return issues.isEmpty();
    }
}

