/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.mcMMO;
import java.util.Locale;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantmentMapper {
    private final mcMMO pluginRef;
    private final Enchantment efficiency;
    private final Enchantment unbreaking;
    private final Enchantment infinity;
    private final Enchantment featherFalling;
    private final Enchantment luckOfTheSea;

    public EnchantmentMapper(mcMMO pluginRef) {
        this.pluginRef = pluginRef;
        this.efficiency = this.initEfficiency();
        this.unbreaking = this.initUnbreaking();
        this.infinity = this.initInfinity();
        this.featherFalling = this.initFeatherFalling();
        this.luckOfTheSea = this.initLuckOfTheSea();
    }

    @Nullable
    private static Enchantment mockSpigotMatch(@NotNull String input) {
        String filtered = input.toLowerCase(Locale.ROOT).replaceAll("\\s+", "_");
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)filtered);
        return namespacedKey != null ? (Enchantment)Registry.ENCHANTMENT.get(namespacedKey) : null;
    }

    private Enchantment initLuckOfTheSea() {
        if (EnchantmentMapper.mockSpigotMatch("luck_of_the_sea") != null) {
            return EnchantmentMapper.mockSpigotMatch("luck_of_the_sea");
        }
        for (Enchantment enchantment : Registry.ENCHANTMENT) {
            if (!enchantment.getKey().getKey().equalsIgnoreCase("LUCK_OF_THE_SEA") && !enchantment.getKey().getKey().equalsIgnoreCase("LUCK") && !enchantment.getName().equalsIgnoreCase("LUCK_OF_THE_SEA") && !enchantment.getName().equalsIgnoreCase("LUCK")) continue;
            return enchantment;
        }
        this.pluginRef.getLogger().severe("Unable to find the Luck of the Sea enchantment, mcMMO will not function properly.");
        throw new IllegalStateException("Unable to find the Luck of the Sea enchantment");
    }

    private Enchantment initFeatherFalling() {
        if (EnchantmentMapper.mockSpigotMatch("feather_falling") != null) {
            return EnchantmentMapper.mockSpigotMatch("feather_falling");
        }
        for (Enchantment enchantment : Registry.ENCHANTMENT) {
            if (!enchantment.getKey().getKey().equalsIgnoreCase("FEATHER_FALLING") && !enchantment.getKey().getKey().equalsIgnoreCase("PROTECTION_FALL") && !enchantment.getName().equalsIgnoreCase("FEATHER_FALLING") && !enchantment.getName().equalsIgnoreCase("PROTECTION_FALL")) continue;
            return enchantment;
        }
        this.pluginRef.getLogger().severe("Unable to find the Feather Falling enchantment, mcMMO will not function properly.");
        throw new IllegalStateException("Unable to find the Feather Falling enchantment");
    }

    private Enchantment initInfinity() {
        if (EnchantmentMapper.mockSpigotMatch("infinity") != null) {
            return EnchantmentMapper.mockSpigotMatch("infinity");
        }
        for (Enchantment enchantment : Registry.ENCHANTMENT) {
            if (!enchantment.getKey().getKey().equalsIgnoreCase("INFINITY") && !enchantment.getKey().getKey().equalsIgnoreCase("ARROW_INFINITE") && !enchantment.getName().equalsIgnoreCase("INFINITY") && !enchantment.getName().equalsIgnoreCase("ARROW_INFINITE")) continue;
            return enchantment;
        }
        this.pluginRef.getLogger().severe("Unable to find the Infinity enchantment, mcMMO will not function properly.");
        throw new IllegalStateException("Unable to find the Infinity enchantment");
    }

    private Enchantment initEfficiency() {
        if (EnchantmentMapper.mockSpigotMatch("efficiency") != null) {
            return EnchantmentMapper.mockSpigotMatch("efficiency");
        }
        for (Enchantment enchantment : Registry.ENCHANTMENT) {
            if (!enchantment.getKey().getKey().equalsIgnoreCase("EFFICIENCY") && !enchantment.getKey().getKey().equalsIgnoreCase("DIG_SPEED") && !enchantment.getName().equalsIgnoreCase("EFFICIENCY") && !enchantment.getName().equalsIgnoreCase("DIG_SPEED")) continue;
            return enchantment;
        }
        this.pluginRef.getLogger().severe("Unable to find the Efficiency enchantment, mcMMO will not function properly.");
        throw new IllegalStateException("Unable to find the Efficiency enchantment");
    }

    private Enchantment initUnbreaking() {
        if (EnchantmentMapper.mockSpigotMatch("unbreaking") != null) {
            return EnchantmentMapper.mockSpigotMatch("unbreaking");
        }
        for (Enchantment enchantment : Registry.ENCHANTMENT) {
            if (!enchantment.getKey().getKey().equalsIgnoreCase("UNBREAKING") && !enchantment.getKey().getKey().equalsIgnoreCase("DURABILITY") && !enchantment.getName().equalsIgnoreCase("UNBREAKING") && !enchantment.getName().equalsIgnoreCase("DURABILITY")) continue;
            return enchantment;
        }
        this.pluginRef.getLogger().severe("Unable to find the Unbreaking enchantment, mcMMO will not function properly.");
        throw new IllegalStateException("Unable to find the Unbreaking enchantment");
    }

    public Enchantment getEfficiency() {
        return this.efficiency;
    }

    public Enchantment getUnbreaking() {
        return this.unbreaking;
    }

    public Enchantment getInfinity() {
        return this.infinity;
    }

    public Enchantment getFeatherFalling() {
        return this.featherFalling;
    }

    public Enchantment getLuckOfTheSea() {
        return this.luckOfTheSea;
    }
}

