/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.player;

import com.gmail.nossr50.api.exceptions.InvalidSkillException;
import com.gmail.nossr50.chat.author.PlayerAuthor;
import com.gmail.nossr50.config.ChatConfig;
import com.gmail.nossr50.config.WorldBlacklist;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.chat.ChatChannel;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.meta.RuptureTaskMeta;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.party.PartyTeleportRecord;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.events.experience.McMMOPlayerPreXpGainEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.mcmmo.kyori.adventure.identity.Identified;
import com.gmail.nossr50.mcmmo.kyori.adventure.identity.Identity;
import com.gmail.nossr50.party.ShareHandler;
import com.gmail.nossr50.runnables.skills.AbilityDisableTask;
import com.gmail.nossr50.runnables.skills.ToolLowerTask;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.acrobatics.AcrobaticsManager;
import com.gmail.nossr50.skills.alchemy.AlchemyManager;
import com.gmail.nossr50.skills.archery.ArcheryManager;
import com.gmail.nossr50.skills.axes.AxesManager;
import com.gmail.nossr50.skills.crossbows.CrossbowsManager;
import com.gmail.nossr50.skills.excavation.ExcavationManager;
import com.gmail.nossr50.skills.fishing.FishingManager;
import com.gmail.nossr50.skills.herbalism.HerbalismManager;
import com.gmail.nossr50.skills.maces.MacesManager;
import com.gmail.nossr50.skills.mining.MiningManager;
import com.gmail.nossr50.skills.repair.RepairManager;
import com.gmail.nossr50.skills.salvage.SalvageManager;
import com.gmail.nossr50.skills.smelting.SmeltingManager;
import com.gmail.nossr50.skills.swords.SwordsManager;
import com.gmail.nossr50.skills.taming.TamingManager;
import com.gmail.nossr50.skills.tridents.TridentsManager;
import com.gmail.nossr50.skills.unarmed.UnarmedManager;
import com.gmail.nossr50.skills.woodcutting.WoodcuttingManager;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.experience.ExperienceBarManager;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import com.gmail.nossr50.util.skills.PerksUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillTools;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class McMMOPlayer
implements Identified {
    @NotNull
    private final Identity identity;
    @NotNull
    private final PlayerAuthor playerAuthor;
    private final Player player;
    private final PlayerProfile profile;
    private final Map<PrimarySkillType, SkillManager> skillManagers = new EnumMap<PrimarySkillType, SkillManager>(PrimarySkillType.class);
    private final ExperienceBarManager experienceBarManager;
    private Party party;
    private Party invite;
    private Party allianceInvite;
    private int itemShareModifier;
    private PartyTeleportRecord ptpRecord;
    private boolean displaySkillNotifications = true;
    private boolean debugMode;
    private boolean abilityUse = true;
    private boolean godMode;
    private boolean chatSpy = false;
    private ChatChannel chatChannel;
    private final Map<SuperAbilityType, Boolean> abilityMode = new EnumMap<SuperAbilityType, Boolean>(SuperAbilityType.class);
    private final Map<SuperAbilityType, Boolean> abilityInformed = new EnumMap<SuperAbilityType, Boolean>(SuperAbilityType.class);
    private final Map<ToolType, Boolean> toolMode = new EnumMap<ToolType, Boolean>(ToolType.class);
    private int recentlyHurt;
    private int respawnATS;
    private int teleportATS;
    private long databaseATS;
    private Location teleportCommence;
    private boolean isUsingUnarmed;
    private final FixedMetadataValue playerMetadata;
    private final String playerName;
    private PrimarySkillType lastSkillShownScoreboard = PrimarySkillType.values()[0];

    public McMMOPlayer(Player player, PlayerProfile profile) {
        Objects.requireNonNull(player, "player cannot be null");
        Objects.requireNonNull(profile, "profile cannot be null");
        this.playerName = player.getName();
        UUID uuid = player.getUniqueId();
        this.identity = Identity.identity(uuid);
        this.player = player;
        this.playerMetadata = new FixedMetadataValue((Plugin)mcMMO.p, (Object)this.playerName);
        this.profile = profile;
        if (profile.getUniqueId() == null) {
            profile.setUniqueId(uuid);
        }
        this.initSkillManagers();
        for (SuperAbilityType superAbilityType : SuperAbilityType.values()) {
            this.abilityMode.put(superAbilityType, false);
            this.abilityInformed.put(superAbilityType, true);
        }
        for (Enum enum_ : ToolType.values()) {
            this.toolMode.put((ToolType)enum_, false);
        }
        this.experienceBarManager = new ExperienceBarManager(this);
        this.debugMode = false;
        this.playerAuthor = new PlayerAuthor(player);
        this.chatChannel = ChatChannel.NONE;
        if (ChatConfig.getInstance().isSpyingAutomatic() && Permissions.adminChatSpy((Permissible)this.getPlayer())) {
            this.chatSpy = true;
        }
    }

    private void initSkillManagers() {
        for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
            try {
                this.initManager(primarySkillType);
            }
            catch (InvalidSkillException e) {
                e.printStackTrace();
            }
        }
    }

    private void initManager(PrimarySkillType primarySkillType) throws InvalidSkillException {
        switch (primarySkillType) {
            case ACROBATICS: {
                this.skillManagers.put(primarySkillType, new AcrobaticsManager(this));
                break;
            }
            case ALCHEMY: {
                this.skillManagers.put(primarySkillType, new AlchemyManager(this));
                break;
            }
            case ARCHERY: {
                this.skillManagers.put(primarySkillType, new ArcheryManager(this));
                break;
            }
            case AXES: {
                this.skillManagers.put(primarySkillType, new AxesManager(this));
                break;
            }
            case CROSSBOWS: {
                this.skillManagers.put(primarySkillType, new CrossbowsManager(this));
                break;
            }
            case EXCAVATION: {
                this.skillManagers.put(primarySkillType, new ExcavationManager(this));
                break;
            }
            case FISHING: {
                this.skillManagers.put(primarySkillType, new FishingManager(this));
                break;
            }
            case HERBALISM: {
                this.skillManagers.put(primarySkillType, new HerbalismManager(this));
                break;
            }
            case MINING: {
                this.skillManagers.put(primarySkillType, new MiningManager(this));
                break;
            }
            case REPAIR: {
                this.skillManagers.put(primarySkillType, new RepairManager(this));
                break;
            }
            case SALVAGE: {
                this.skillManagers.put(primarySkillType, new SalvageManager(this));
                break;
            }
            case SMELTING: {
                this.skillManagers.put(primarySkillType, new SmeltingManager(this));
                break;
            }
            case SWORDS: {
                this.skillManagers.put(primarySkillType, new SwordsManager(this));
                break;
            }
            case TAMING: {
                this.skillManagers.put(primarySkillType, new TamingManager(this));
                break;
            }
            case TRIDENTS: {
                this.skillManagers.put(primarySkillType, new TridentsManager(this));
                break;
            }
            case UNARMED: {
                this.skillManagers.put(primarySkillType, new UnarmedManager(this));
                break;
            }
            case WOODCUTTING: {
                this.skillManagers.put(primarySkillType, new WoodcuttingManager(this));
                break;
            }
            case MACES: {
                if (!mcMMO.getCompatibilityManager().getMinecraftGameVersion().isAtLeast(1, 21, 0)) break;
                this.skillManagers.put(primarySkillType, new MacesManager(this));
                break;
            }
            default: {
                throw new InvalidSkillException("The skill named has no manager! Contact the devs!");
            }
        }
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public double getAttackStrength() {
        if (mcMMO.p.getAdvancedConfig().useAttackCooldown()) {
            return this.player.getAttackCooldown();
        }
        return 1.0;
    }

    @NotNull
    public PrimarySkillType getLastSkillShownScoreboard() {
        return this.lastSkillShownScoreboard;
    }

    public void setLastSkillShownScoreboard(PrimarySkillType primarySkillType) {
        this.lastSkillShownScoreboard = primarySkillType;
    }

    public void processPostXpEvent(PrimarySkillType primarySkillType, Plugin plugin, XPGainSource xpGainSource) {
        if (this.hasReachedPowerLevelCap()) {
            NotificationManager.sendPlayerInformationChatOnly(this.player, "LevelCap.PowerLevel", String.valueOf(mcMMO.p.getGeneralConfig().getPowerLevelCap()));
        } else if (this.hasReachedLevelCap(primarySkillType)) {
            NotificationManager.sendPlayerInformationChatOnly(this.player, "LevelCap.Skill", String.valueOf(mcMMO.p.getSkillTools().getLevelCap(primarySkillType)), mcMMO.p.getSkillTools().getLocalizedSkillName(primarySkillType));
        }
        if (xpGainSource == XPGainSource.PARTY_MEMBERS && !ExperienceConfig.getInstance().isPartyExperienceBarsEnabled()) {
            return;
        }
        if (xpGainSource == XPGainSource.PASSIVE && !ExperienceConfig.getInstance().isPassiveGainsExperienceBarsEnabled()) {
            return;
        }
        this.updateXPBar(primarySkillType, plugin);
    }

    public void processUnlockNotifications(mcMMO plugin, PrimarySkillType primarySkillType, int skillLevel) {
        RankUtils.executeSkillUnlockNotifications((Plugin)plugin, this, primarySkillType, skillLevel);
    }

    public void updateXPBar(PrimarySkillType primarySkillType, Plugin plugin) {
        this.experienceBarManager.updateExperienceBar(primarySkillType, plugin);
    }

    public double getProgressInCurrentSkillLevel(PrimarySkillType primarySkillType) {
        if (SkillTools.isChildSkill(primarySkillType)) {
            return 1.0;
        }
        double currentXP = this.profile.getSkillXpLevel(primarySkillType);
        double maxXP = this.profile.getXpToLevel(primarySkillType);
        return currentXP / maxXP;
    }

    public ExperienceBarManager getExperienceBarManager() {
        return this.experienceBarManager;
    }

    public AcrobaticsManager getAcrobaticsManager() {
        return (AcrobaticsManager)this.skillManagers.get((Object)PrimarySkillType.ACROBATICS);
    }

    public AlchemyManager getAlchemyManager() {
        return (AlchemyManager)this.skillManagers.get((Object)PrimarySkillType.ALCHEMY);
    }

    public ArcheryManager getArcheryManager() {
        return (ArcheryManager)this.skillManagers.get((Object)PrimarySkillType.ARCHERY);
    }

    public AxesManager getAxesManager() {
        return (AxesManager)this.skillManagers.get((Object)PrimarySkillType.AXES);
    }

    public CrossbowsManager getCrossbowsManager() {
        return (CrossbowsManager)this.skillManagers.get((Object)PrimarySkillType.CROSSBOWS);
    }

    public TridentsManager getTridentsManager() {
        return (TridentsManager)this.skillManagers.get((Object)PrimarySkillType.TRIDENTS);
    }

    public MacesManager getMacesManager() {
        return (MacesManager)this.skillManagers.get((Object)PrimarySkillType.MACES);
    }

    public ExcavationManager getExcavationManager() {
        return (ExcavationManager)this.skillManagers.get((Object)PrimarySkillType.EXCAVATION);
    }

    public FishingManager getFishingManager() {
        return (FishingManager)this.skillManagers.get((Object)PrimarySkillType.FISHING);
    }

    public HerbalismManager getHerbalismManager() {
        return (HerbalismManager)this.skillManagers.get((Object)PrimarySkillType.HERBALISM);
    }

    public MiningManager getMiningManager() {
        return (MiningManager)this.skillManagers.get((Object)PrimarySkillType.MINING);
    }

    public RepairManager getRepairManager() {
        return (RepairManager)this.skillManagers.get((Object)PrimarySkillType.REPAIR);
    }

    public SalvageManager getSalvageManager() {
        return (SalvageManager)this.skillManagers.get((Object)PrimarySkillType.SALVAGE);
    }

    public SmeltingManager getSmeltingManager() {
        return (SmeltingManager)this.skillManagers.get((Object)PrimarySkillType.SMELTING);
    }

    public SwordsManager getSwordsManager() {
        return (SwordsManager)this.skillManagers.get((Object)PrimarySkillType.SWORDS);
    }

    public TamingManager getTamingManager() {
        return (TamingManager)this.skillManagers.get((Object)PrimarySkillType.TAMING);
    }

    public UnarmedManager getUnarmedManager() {
        return (UnarmedManager)this.skillManagers.get((Object)PrimarySkillType.UNARMED);
    }

    public WoodcuttingManager getWoodcuttingManager() {
        return (WoodcuttingManager)this.skillManagers.get((Object)PrimarySkillType.WOODCUTTING);
    }

    public void resetAbilityMode() {
        for (SuperAbilityType ability : SuperAbilityType.values()) {
            new AbilityDisableTask(this, ability).run();
        }
    }

    public boolean getAbilityMode(@NotNull SuperAbilityType superAbilityType) {
        Objects.requireNonNull(superAbilityType, "superAbilityType cannot be null");
        return this.abilityMode.get((Object)superAbilityType);
    }

    public void setAbilityMode(SuperAbilityType ability, boolean isActive) {
        this.abilityMode.put(ability, isActive);
    }

    public boolean getAbilityInformed(SuperAbilityType ability) {
        return this.abilityInformed.get((Object)ability);
    }

    public void setAbilityInformed(SuperAbilityType ability, boolean isInformed) {
        this.abilityInformed.put(ability, isInformed);
    }

    public boolean getToolPreparationMode(ToolType tool) {
        return this.toolMode.get((Object)tool);
    }

    public boolean getAbilityUse() {
        return this.abilityUse;
    }

    public void toggleAbilityUse() {
        this.abilityUse = !this.abilityUse;
    }

    public void resetToolPrepMode() {
        for (ToolType tool : ToolType.values()) {
            this.setToolPreparationMode(tool, false);
        }
    }

    public void setToolPreparationMode(ToolType tool, boolean isPrepared) {
        this.toolMode.put(tool, isPrepared);
    }

    public int getRecentlyHurt() {
        return this.recentlyHurt;
    }

    public void setRecentlyHurt(int value) {
        this.recentlyHurt = value;
    }

    public void actualizeRecentlyHurt() {
        this.recentlyHurt = (int)(System.currentTimeMillis() / 1000L);
    }

    public int getChimeraWingLastUse() {
        return this.profile.getChimaerWingDATS();
    }

    public void actualizeChimeraWingLastUse() {
        this.profile.setChimaeraWingDATS((int)(System.currentTimeMillis() / 1000L));
    }

    public Location getTeleportCommenceLocation() {
        return this.teleportCommence;
    }

    public void setTeleportCommenceLocation(Location location) {
        this.teleportCommence = location;
    }

    public void actualizeTeleportCommenceLocation(Player player) {
        this.teleportCommence = player.getLocation();
    }

    public int getRespawnATS() {
        return this.respawnATS;
    }

    public void actualizeRespawnATS() {
        this.respawnATS = (int)(System.currentTimeMillis() / 1000L);
    }

    public int getTeleportATS() {
        return this.teleportATS;
    }

    public void actualizeTeleportATS() {
        this.teleportATS = (int)(System.currentTimeMillis() / 1000L);
    }

    public long getDatabaseATS() {
        return this.databaseATS;
    }

    public void actualizeDatabaseATS() {
        this.databaseATS = System.currentTimeMillis();
    }

    public boolean getGodMode() {
        return this.godMode;
    }

    public void toggleGodMode() {
        this.godMode = !this.godMode;
    }

    public boolean isPartyChatSpying() {
        return this.chatSpy;
    }

    public void togglePartyChatSpying() {
        this.chatSpy = !this.chatSpy;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void toggleDebugMode() {
        this.debugMode = !this.debugMode;
    }

    public boolean useChatNotifications() {
        return this.displaySkillNotifications;
    }

    public void toggleChatNotifications() {
        this.displaySkillNotifications = !this.displaySkillNotifications;
    }

    public int getPowerLevel() {
        int powerLevel = 0;
        for (PrimarySkillType primarySkillType : SkillTools.NON_CHILD_SKILLS) {
            if (!mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(this.player, primarySkillType)) continue;
            powerLevel += this.getSkillLevel(primarySkillType);
        }
        return powerLevel;
    }

    public boolean hasReachedLevelCap(PrimarySkillType primarySkillType) {
        if (this.hasReachedPowerLevelCap()) {
            return true;
        }
        return this.getSkillLevel(primarySkillType) >= mcMMO.p.getSkillTools().getLevelCap(primarySkillType);
    }

    public boolean hasReachedPowerLevelCap() {
        return this.getPowerLevel() >= mcMMO.p.getGeneralConfig().getPowerLevelCap();
    }

    public void beginXpGain(PrimarySkillType skill, float xp, XPGainReason xpGainReason, XPGainSource xpGainSource) {
        if (xp <= 0.0f) {
            return;
        }
        if (SkillTools.isChildSkill(skill)) {
            ImmutableList<PrimarySkillType> parentSkills = mcMMO.p.getSkillTools().getChildSkillParents(skill);
            float splitXp = xp / (float)parentSkills.size();
            for (PrimarySkillType parentSkill : parentSkills) {
                if (!mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(this.player, parentSkill)) continue;
                this.beginXpGain(parentSkill, splitXp, xpGainReason, xpGainSource);
            }
            return;
        }
        if (this.party != null && ShareHandler.handleXpShare(xp, this, skill, ShareHandler.getSharedXpGainReason(xpGainReason))) {
            return;
        }
        this.beginUnsharedXpGain(skill, xp, xpGainReason, xpGainSource);
    }

    public void beginUnsharedXpGain(PrimarySkillType skill, float xp, XPGainReason xpGainReason, XPGainSource xpGainSource) {
        if (this.player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        this.applyXpGain(skill, this.modifyXpGain(skill, xp), xpGainReason, xpGainSource);
        if (!mcMMO.p.getPartyConfig().isPartyEnabled() || this.party == null || this.party.hasReachedLevelCap()) {
            return;
        }
        if (!mcMMO.p.getGeneralConfig().getPartyXpNearMembersNeeded() || !mcMMO.p.getPartyManager().getNearMembers(this).isEmpty()) {
            this.party.applyXpGain(this.modifyXpGain(skill, xp));
        }
    }

    public void applyXpGain(PrimarySkillType primarySkillType, float xp, XPGainReason xpGainReason, XPGainSource xpGainSource) {
        if (!mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(this.player, primarySkillType)) {
            return;
        }
        McMMOPlayerPreXpGainEvent mcMMOPlayerPreXpGainEvent = new McMMOPlayerPreXpGainEvent(this.player, primarySkillType, xp, xpGainReason);
        Bukkit.getPluginManager().callEvent((Event)mcMMOPlayerPreXpGainEvent);
        xp = mcMMOPlayerPreXpGainEvent.getXpGained();
        if (SkillTools.isChildSkill(primarySkillType)) {
            ImmutableList<PrimarySkillType> parentSkills = mcMMO.p.getSkillTools().getChildSkillParents(primarySkillType);
            for (PrimarySkillType parentSkill : parentSkills) {
                this.applyXpGain(parentSkill, xp / (float)parentSkills.size(), xpGainReason, xpGainSource);
            }
            return;
        }
        if (!EventUtils.handleXpGainEvent(this.player, primarySkillType, xp, xpGainReason)) {
            return;
        }
        this.isUsingUnarmed = primarySkillType == PrimarySkillType.UNARMED;
        this.checkXp(primarySkillType, xpGainReason, xpGainSource);
    }

    private void checkXp(PrimarySkillType primarySkillType, XPGainReason xpGainReason, XPGainSource xpGainSource) {
        if (this.hasReachedLevelCap(primarySkillType)) {
            return;
        }
        if (this.getSkillXpLevelRaw(primarySkillType) < (float)this.getXpToLevel(primarySkillType)) {
            this.processPostXpEvent(primarySkillType, (Plugin)mcMMO.p, xpGainSource);
            return;
        }
        int levelsGained = 0;
        float xpRemoved = 0.0f;
        while (this.getSkillXpLevelRaw(primarySkillType) >= (float)this.getXpToLevel(primarySkillType)) {
            if (this.hasReachedLevelCap(primarySkillType)) {
                this.setSkillXpLevel(primarySkillType, 0.0f);
                break;
            }
            xpRemoved += this.profile.levelUp(primarySkillType);
            ++levelsGained;
        }
        if (EventUtils.tryLevelChangeEvent(this, primarySkillType, levelsGained, xpRemoved, true, xpGainReason)) {
            return;
        }
        if (mcMMO.p.getGeneralConfig().getLevelUpSoundsEnabled()) {
            SoundManager.sendSound(this.player, this.player.getLocation(), SoundType.LEVEL_UP);
        }
        NotificationManager.sendPlayerLevelUpNotification(this, primarySkillType, levelsGained, this.profile.getSkillLevel(primarySkillType));
        this.processPostXpEvent(primarySkillType, (Plugin)mcMMO.p, xpGainSource);
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public PlayerProfile getProfile() {
        return this.profile;
    }

    public void setupPartyData() {
        if (mcMMO.p.isPartySystemEnabled()) {
            this.party = mcMMO.p.getPartyManager().getPlayerParty(this.player.getName(), this.player.getUniqueId());
            this.ptpRecord = new PartyTeleportRecord();
            if (this.inParty()) {
                this.loginParty();
            }
        }
    }

    public void setPartyInvite(Party invite) {
        this.invite = invite;
    }

    public Party getPartyInvite() {
        return this.invite;
    }

    public boolean hasPartyInvite() {
        return this.invite != null;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    @Nullable
    public Party getParty() {
        return this.party;
    }

    public boolean inParty() {
        return this.party != null;
    }

    public void removeParty() {
        this.party = null;
    }

    public void removePartyInvite() {
        this.invite = null;
    }

    @Nullable
    public PartyTeleportRecord getPartyTeleportRecord() {
        return this.ptpRecord;
    }

    public void setPartyAllianceInvite(Party allianceInvite) {
        this.allianceInvite = allianceInvite;
    }

    public Party getPartyAllianceInvite() {
        return this.allianceInvite;
    }

    public boolean hasPartyAllianceInvite() {
        return this.allianceInvite != null;
    }

    public void removePartyAllianceInvite() {
        this.allianceInvite = null;
    }

    public void loginParty() {
        this.party.addOnlineMember(this.getPlayer());
    }

    public int getItemShareModifier() {
        if (this.itemShareModifier < 10) {
            this.setItemShareModifier(10);
        }
        return this.itemShareModifier;
    }

    public void setItemShareModifier(int modifier) {
        this.itemShareModifier = Math.max(10, modifier);
    }

    public boolean isUsingUnarmed() {
        return this.isUsingUnarmed;
    }

    @VisibleForTesting
    float modifyXpGain(PrimarySkillType primarySkillType, float xp) {
        if (mcMMO.p.getSkillTools().getLevelCap(primarySkillType) <= this.getSkillLevel(primarySkillType) || mcMMO.p.getGeneralConfig().getPowerLevelCap() <= this.getPowerLevel()) {
            return 0.0f;
        }
        xp = (float)((double)xp * ExperienceConfig.getInstance().getFormulaSkillModifier(primarySkillType) * ExperienceConfig.getInstance().getExperienceGainsGlobalMultiplier());
        return PerksUtils.handleXpPerks(this.player, xp, primarySkillType);
    }

    public void checkGodMode() {
        if (this.godMode && !Permissions.mcgod((Permissible)this.player) || this.godMode && WorldBlacklist.isWorldBlacklisted(this.player.getWorld())) {
            this.toggleGodMode();
            this.player.sendMessage(LocaleLoader.getString("Commands.GodMode.Forbidden"));
        }
    }

    public void checkParty() {
        if (this.inParty() && !Permissions.party((Permissible)this.player)) {
            this.removeParty();
            this.player.sendMessage(LocaleLoader.getString("Party.Forbidden"));
        }
    }

    public void checkAbilityActivation(PrimarySkillType primarySkillType) {
        ToolType tool = mcMMO.p.getSkillTools().getPrimarySkillToolType(primarySkillType);
        SuperAbilityType superAbilityType = mcMMO.p.getSkillTools().getSuperAbility(primarySkillType);
        SubSkillType subSkillType = superAbilityType.getSubSkillTypeDefinition();
        if (this.getAbilityMode(superAbilityType) || !superAbilityType.getPermissions(this.player)) {
            return;
        }
        if (!RankUtils.hasUnlockedSubskill(this.player, subSkillType)) {
            int diff = RankUtils.getSuperAbilityUnlockRequirement(superAbilityType) - this.getSkillLevel(primarySkillType);
            NotificationManager.sendPlayerInformation(this.player, NotificationType.ABILITY_COOLDOWN, "Skills.AbilityGateRequirementFail", String.valueOf(diff), mcMMO.p.getSkillTools().getLocalizedSkillName(primarySkillType));
            return;
        }
        int timeRemaining = this.calculateTimeRemaining(superAbilityType);
        if (timeRemaining > 0) {
            if (primarySkillType == PrimarySkillType.WOODCUTTING || primarySkillType == PrimarySkillType.AXES) {
                NotificationManager.sendPlayerInformation(this.player, NotificationType.ABILITY_COOLDOWN, "Skills.TooTired", String.valueOf(timeRemaining));
            }
            return;
        }
        if (EventUtils.callPlayerAbilityActivateEvent(this, primarySkillType).isCancelled()) {
            return;
        }
        int abilityLengthVar = mcMMO.p.getAdvancedConfig().getAbilityLength();
        int abilityLengthCap = mcMMO.p.getAdvancedConfig().getAbilityLengthCap();
        int ticks = abilityLengthCap > 0 ? PerksUtils.handleActivationPerks(this.player, 2 + Math.min(abilityLengthCap, this.getSkillLevel(primarySkillType)) / abilityLengthVar, superAbilityType.getMaxLength()) : PerksUtils.handleActivationPerks(this.player, 2 + this.getSkillLevel(primarySkillType) / abilityLengthVar, superAbilityType.getMaxLength());
        if (this.useChatNotifications()) {
            NotificationManager.sendPlayerInformation(this.player, NotificationType.SUPER_ABILITY, superAbilityType.getAbilityOn());
        }
        if (mcMMO.p.getAdvancedConfig().sendAbilityNotificationToOtherPlayers()) {
            SkillUtils.sendSkillMessage(this.player, NotificationType.SUPER_ABILITY_ALERT_OTHERS, superAbilityType.getAbilityPlayer());
        }
        SoundManager.worldSendSound(this.player.getWorld(), this.player.getLocation(), SoundType.ABILITY_ACTIVATED_GENERIC);
        if (superAbilityType == SuperAbilityType.SUPER_BREAKER || superAbilityType == SuperAbilityType.GIGA_DRILL_BREAKER) {
            SkillUtils.removeAbilityBuff(this.player.getInventory().getItemInMainHand());
        }
        this.profile.setAbilityDATS(superAbilityType, System.currentTimeMillis() + (long)ticks * 1000L);
        this.setAbilityMode(superAbilityType, true);
        if (superAbilityType == SuperAbilityType.SUPER_BREAKER || superAbilityType == SuperAbilityType.GIGA_DRILL_BREAKER) {
            SkillUtils.handleAbilitySpeedIncrease(this.player);
        }
        this.setToolPreparationMode(tool, false);
        mcMMO.p.getFoliaLib().getScheduler().runAtEntityLater((Entity)this.player, new AbilityDisableTask(this, superAbilityType), (long)ticks * 20L);
    }

    public void processAbilityActivation(@NotNull PrimarySkillType primarySkillType) {
        if (!mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(this.getPlayer(), primarySkillType)) {
            return;
        }
        if (mcMMO.p.getGeneralConfig().getAbilitiesOnlyActivateWhenSneaking() && !this.player.isSneaking()) {
            return;
        }
        ItemStack inHand = this.player.getInventory().getItemInMainHand();
        if (!this.getAbilityUse()) {
            return;
        }
        for (SuperAbilityType superAbilityType : SuperAbilityType.values()) {
            if (!this.getAbilityMode(superAbilityType)) continue;
            return;
        }
        SuperAbilityType ability = mcMMO.p.getSkillTools().getSuperAbility(primarySkillType);
        ToolType tool = mcMMO.p.getSkillTools().getPrimarySkillToolType(primarySkillType);
        if (tool.inHand(inHand) && !this.getToolPreparationMode(tool)) {
            if (primarySkillType != PrimarySkillType.WOODCUTTING && primarySkillType != PrimarySkillType.AXES) {
                int timeRemaining = this.calculateTimeRemaining(ability);
                if (this.isAbilityOnCooldown(ability)) {
                    NotificationManager.sendPlayerInformation(this.player, NotificationType.ABILITY_COOLDOWN, "Skills.TooTired", String.valueOf(timeRemaining));
                    return;
                }
            }
            if (mcMMO.p.getGeneralConfig().getAbilityMessagesEnabled()) {
                if (tool == ToolType.AXE) {
                    this.processAxeToolMessages();
                } else {
                    NotificationManager.sendPlayerInformation(this.player, NotificationType.TOOL, tool.getRaiseTool());
                }
                SoundManager.sendSound(this.player, this.player.getLocation(), SoundType.TOOL_READY);
            }
            this.setToolPreparationMode(tool, true);
            mcMMO.p.getFoliaLib().getScheduler().runAtEntityLater((Entity)this.player, new ToolLowerTask(this, tool), 80L);
        }
    }

    public void processAxeToolMessages() {
        Block rayCast = this.player.getTargetBlock(null, 100);
        if (this.isAbilityOnCooldown(SuperAbilityType.TREE_FELLER) && this.isAbilityOnCooldown(SuperAbilityType.SKULL_SPLITTER)) {
            this.tooTiredMultiple(PrimarySkillType.WOODCUTTING, SubSkillType.WOODCUTTING_TREE_FELLER, SuperAbilityType.TREE_FELLER, SubSkillType.AXES_SKULL_SPLITTER, SuperAbilityType.SKULL_SPLITTER);
        } else if (this.isAbilityOnCooldown(SuperAbilityType.TREE_FELLER) && BlockUtils.isPartOfTree(rayCast)) {
            this.raiseToolWithCooldowns(SubSkillType.WOODCUTTING_TREE_FELLER, SuperAbilityType.TREE_FELLER);
        } else if (this.isAbilityOnCooldown(SuperAbilityType.SKULL_SPLITTER)) {
            this.raiseToolWithCooldowns(SubSkillType.AXES_SKULL_SPLITTER, SuperAbilityType.SKULL_SPLITTER);
        } else {
            NotificationManager.sendPlayerInformation(this.player, NotificationType.TOOL, ToolType.AXE.getRaiseTool());
        }
    }

    private void tooTiredMultiple(PrimarySkillType primarySkillType, SubSkillType aSubSkill, SuperAbilityType aSuperAbility, SubSkillType bSubSkill, SuperAbilityType bSuperAbility) {
        String aSuperAbilityCD = LocaleLoader.getString("Skills.TooTired.Named", aSubSkill.getLocaleName(), String.valueOf(this.calculateTimeRemaining(aSuperAbility)));
        String bSuperAbilityCD = LocaleLoader.getString("Skills.TooTired.Named", bSubSkill.getLocaleName(), String.valueOf(this.calculateTimeRemaining(bSuperAbility)));
        String allCDStr = aSuperAbilityCD + ", " + bSuperAbilityCD;
        NotificationManager.sendPlayerInformation(this.player, NotificationType.TOOL, "Skills.TooTired.Extra", mcMMO.p.getSkillTools().getLocalizedSkillName(primarySkillType), allCDStr);
    }

    private void raiseToolWithCooldowns(SubSkillType subSkillType, SuperAbilityType superAbilityType) {
        NotificationManager.sendPlayerInformation(this.player, NotificationType.TOOL, "Axes.Ability.Ready.Extra", subSkillType.getLocaleName(), String.valueOf(this.calculateTimeRemaining(superAbilityType)));
    }

    public boolean isAbilityOnCooldown(SuperAbilityType ability) {
        return !this.getAbilityMode(ability) && this.calculateTimeRemaining(ability) > 0;
    }

    public int calculateTimeRemaining(SuperAbilityType ability) {
        long deactivatedTimestamp = this.profile.getAbilityDATS(ability) * 1000L;
        return (int)((deactivatedTimestamp + (long)(PerksUtils.handleCooldownPerks(this.player, ability.getCooldown()) * 1000) - System.currentTimeMillis()) / 1000L);
    }

    public int getSkillLevel(PrimarySkillType skill) {
        return this.profile.getSkillLevel(skill);
    }

    public float getSkillXpLevelRaw(PrimarySkillType skill) {
        return this.profile.getSkillXpLevelRaw(skill);
    }

    public int getSkillXpLevel(PrimarySkillType skill) {
        return this.profile.getSkillXpLevel(skill);
    }

    public void setSkillXpLevel(PrimarySkillType skill, float xpLevel) {
        this.profile.setSkillXpLevel(skill, xpLevel);
    }

    public int getXpToLevel(PrimarySkillType skill) {
        return this.profile.getXpToLevel(skill);
    }

    public void removeXp(PrimarySkillType skill, int xp) {
        this.profile.removeXp(skill, xp);
    }

    public void modifySkill(PrimarySkillType skill, int level) {
        this.profile.modifySkill(skill, level);
    }

    public void addLevels(PrimarySkillType skill, int levels) {
        this.profile.addLevels(skill, levels);
    }

    public void addXp(PrimarySkillType skill, float xp) {
        this.profile.addXp(skill, xp);
    }

    public void setAbilityDATS(SuperAbilityType ability, long DATS) {
        this.profile.setAbilityDATS(ability, DATS);
    }

    public void resetCooldowns() {
        this.profile.resetCooldowns();
    }

    public FixedMetadataValue getPlayerMetadata() {
        return this.playerMetadata;
    }

    public void logout(boolean syncSave) {
        Player thisPlayer = this.getPlayer();
        if (this.getPlayer().hasMetadata("mcmmo_rupture")) {
            RuptureTaskMeta ruptureTaskMeta = (RuptureTaskMeta)((Object)this.getPlayer().getMetadata("mcmmo_rupture").get(0));
            ruptureTaskMeta.getRuptureTimerTask().endRupture();
            ruptureTaskMeta.getRuptureTimerTask().endRupture();
            ruptureTaskMeta.getRuptureTimerTask().endRupture();
        }
        this.cleanup();
        if (syncSave) {
            this.getProfile().save(true);
        } else {
            this.getProfile().scheduleAsyncSave();
        }
        UserManager.remove(thisPlayer);
        if (mcMMO.p.getGeneralConfig().getScoreboardsEnabled()) {
            ScoreboardManager.teardownPlayer(thisPlayer);
        }
        if (this.inParty()) {
            this.party.removeOnlineMember(thisPlayer);
        }
        mcMMO.getDatabaseManager().cleanupUser(thisPlayer.getUniqueId());
    }

    public void cleanup() {
        this.resetAbilityMode();
        this.getTamingManager().cleanupAllSummons();
    }

    @Override
    public @NonNull Identity identity() {
        return this.identity;
    }

    @NotNull
    public PlayerAuthor getPlayerAuthor() {
        return this.playerAuthor;
    }

    @NotNull
    public ChatChannel getChatChannel() {
        return this.chatChannel;
    }

    public void setChatMode(@NotNull ChatChannel chatChannel) {
        this.chatChannel = chatChannel;
    }
}

