/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.mcmmo.kyori.adventure.text.Component;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.text.TextComponentFactory;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class WoodcuttingCommand
extends SkillCommand {
    private String treeFellerLength;
    private String treeFellerLengthEndurance;
    private String doubleDropChance;
    private String tripleDropChance;
    private String doubleDropChanceLucky;
    private String tripleDropChanceLucky;
    private boolean canTreeFell;
    private boolean canLeafBlow;
    private boolean canDoubleDrop;
    private boolean canTripleDrop;
    private boolean canKnockOnWood;

    public WoodcuttingCommand() {
        super(PrimarySkillType.WOODCUTTING);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue) {
        if (this.canDoubleDrop) {
            this.setDoubleDropClassicChanceStrings(player);
        }
        if (this.canTripleDrop) {
            String[] tripleDropStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.WOODCUTTING_CLEAN_CUTS);
            this.tripleDropChance = tripleDropStrings[0];
            this.tripleDropChanceLucky = tripleDropStrings[1];
        }
        if (this.canTreeFell) {
            String[] treeFellerStrings = this.calculateLengthDisplayValues(player, skillValue);
            this.treeFellerLength = treeFellerStrings[0];
            this.treeFellerLengthEndurance = treeFellerStrings[1];
        }
    }

    private void setDoubleDropClassicChanceStrings(Player player) {
        String[] doubleDropStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.WOODCUTTING_HARVEST_LUMBER);
        this.doubleDropChance = doubleDropStrings[0];
        this.doubleDropChanceLucky = doubleDropStrings[1];
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canTreeFell = RankUtils.hasUnlockedSubskill(player, SubSkillType.WOODCUTTING_TREE_FELLER) && Permissions.treeFeller((Permissible)player);
        this.canDoubleDrop = !mcMMO.p.getGeneralConfig().getDoubleDropsDisabled(this.skill) && Permissions.canUseSubSkill(player, SubSkillType.WOODCUTTING_HARVEST_LUMBER) && RankUtils.getRank(player, SubSkillType.WOODCUTTING_HARVEST_LUMBER) >= 1;
        this.canTripleDrop = !mcMMO.p.getGeneralConfig().getDoubleDropsDisabled(this.skill) && Permissions.canUseSubSkill(player, SubSkillType.WOODCUTTING_CLEAN_CUTS);
        this.canLeafBlow = Permissions.canUseSubSkill(player, SubSkillType.WOODCUTTING_LEAF_BLOWER);
        this.canKnockOnWood = this.canTreeFell && Permissions.canUseSubSkill(player, SubSkillType.WOODCUTTING_KNOCK_ON_WOOD);
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canDoubleDrop) {
            messages.add(this.getStatMessage(SubSkillType.WOODCUTTING_HARVEST_LUMBER, this.doubleDropChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.doubleDropChanceLucky) : ""));
        }
        if (this.canTripleDrop) {
            messages.add(this.getStatMessage(SubSkillType.WOODCUTTING_CLEAN_CUTS, this.tripleDropChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.tripleDropChanceLucky) : ""));
        }
        if (this.canKnockOnWood) {
            String lootNote = RankUtils.hasReachedRank(2, player, SubSkillType.WOODCUTTING_KNOCK_ON_WOOD) ? LocaleLoader.getString("Woodcutting.SubSkill.KnockOnWood.Loot.Rank2") : LocaleLoader.getString("Woodcutting.SubSkill.KnockOnWood.Loot.Normal");
            messages.add(this.getStatMessage(SubSkillType.WOODCUTTING_KNOCK_ON_WOOD, lootNote));
        }
        if (this.canLeafBlow) {
            messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Woodcutting.Ability.0"), LocaleLoader.getString("Woodcutting.Ability.1")));
        }
        if (this.canTreeFell) {
            messages.add(this.getStatMessage(SubSkillType.WOODCUTTING_TREE_FELLER, this.treeFellerLength) + (hasEndurance ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.treeFellerLengthEndurance) : ""));
        }
        return messages;
    }

    @Override
    protected List<Component> getTextComponents(Player player) {
        ArrayList<Component> textComponents = new ArrayList<Component>();
        TextComponentFactory.getSubSkillTextComponents(player, textComponents, PrimarySkillType.WOODCUTTING);
        return textComponents;
    }
}

