/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.mining;

import com.gmail.nossr50.api.ItemSpawnReason;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.skills.AbilityCooldownTask;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.mining.BlastMining;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.Probability;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class MiningManager
extends SkillManager {
    private static final String BUDDING_AMETHYST = "budding_amethyst";
    private static final Collection<Material> BLAST_MINING_BLACKLIST = Set.of(Material.SPAWNER, Material.INFESTED_COBBLESTONE, Material.INFESTED_DEEPSLATE, Material.INFESTED_STONE, Material.INFESTED_STONE_BRICKS, Material.INFESTED_CRACKED_STONE_BRICKS, Material.INFESTED_CHISELED_STONE_BRICKS, Material.INFESTED_MOSSY_STONE_BRICKS);
    private static final Set<String> INFESTED_BLOCKS = Set.of("infested_stone", "infested_cobblestone", "infested_stone_bricks", "infested_cracked_stone_bricks", "infested_mossy_stone_bricks", "infested_chiseled_stone_bricks", "infested_deepslate");

    public MiningManager(@NotNull McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.MINING);
    }

    public boolean canUseDemolitionsExpertise() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.MINING_DEMOLITIONS_EXPERTISE)) {
            return false;
        }
        return this.getSkillLevel() >= BlastMining.getDemolitionExpertUnlockLevel() && Permissions.demolitionsExpertise((Permissible)this.getPlayer());
    }

    public boolean canDetonate() {
        Player player = this.getPlayer();
        return this.canUseBlastMining() && player.isSneaking() && (ItemUtils.isPickaxe(this.getPlayer().getInventory().getItemInMainHand()) || MiningManager.isDetonatorInHand(player)) && Permissions.remoteDetonation((Permissible)player);
    }

    private static boolean isDetonatorInHand(Player player) {
        return player.getInventory().getItemInMainHand().getType() == mcMMO.p.getGeneralConfig().getDetonatorItem();
    }

    public boolean canUseBlastMining() {
        return RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.MINING_BLAST_MINING);
    }

    public boolean canUseBiggerBombs() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.MINING_BIGGER_BOMBS)) {
            return false;
        }
        return this.getSkillLevel() >= BlastMining.getBiggerBombsUnlockLevel() && Permissions.biggerBombs((Permissible)this.getPlayer());
    }

    public boolean canDoubleDrop() {
        return RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.MINING_DOUBLE_DROPS) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.MINING_DOUBLE_DROPS);
    }

    public boolean canMotherLode() {
        return Permissions.canUseSubSkill(this.getPlayer(), SubSkillType.MINING_MOTHER_LODE);
    }

    @Deprecated(since="2.2.024", forRemoval=true)
    public void miningBlockCheck(BlockState blockState) {
        this.miningBlockCheck(blockState.getBlock());
    }

    public void miningBlockCheck(Block block) {
        Player player = this.getPlayer();
        this.applyXpGain(ExperienceConfig.getInstance().getXp(PrimarySkillType.MINING, block), XPGainReason.PVE);
        if (!Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.MINING_DOUBLE_DROPS)) {
            return;
        }
        if (this.mmoPlayer.getAbilityMode(mcMMO.p.getSkillTools().getSuperAbility(this.skill))) {
            SkillUtils.handleDurabilityChange(this.getPlayer().getInventory().getItemInMainHand(), mcMMO.p.getGeneralConfig().getAbilityToolDamage());
        }
        if (!mcMMO.p.getGeneralConfig().getDoubleDropsEnabled(PrimarySkillType.MINING, block.getType()) || !this.canDoubleDrop()) {
            return;
        }
        boolean silkTouch = player.getInventory().getItemInMainHand().containsEnchantment(Enchantment.SILK_TOUCH);
        if (silkTouch && !mcMMO.p.getAdvancedConfig().getDoubleDropSilkTouchEnabled()) {
            return;
        }
        if (this.canMotherLode()) {
            if (!this.processTripleDrops(block)) {
                this.processDoubleDrops(block);
            }
        } else {
            this.processDoubleDrops(block);
        }
    }

    private boolean processTripleDrops(@NotNull Block block) {
        if (ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.MINING_MOTHER_LODE, this.mmoPlayer)) {
            BlockUtils.markDropsAsBonus(block, 2);
            return true;
        }
        return false;
    }

    private void processDoubleDrops(@NotNull Block block) {
        if (ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.MINING_DOUBLE_DROPS, this.mmoPlayer)) {
            boolean useTriple = this.mmoPlayer.getAbilityMode(SuperAbilityType.SUPER_BREAKER) && mcMMO.p.getAdvancedConfig().getAllowMiningTripleDrops();
            BlockUtils.markDropsAsBonus(block, useTriple);
        }
    }

    public void remoteDetonation() {
        Player player = this.getPlayer();
        Block targetBlock = player.getTargetBlock(BlockUtils.getTransparentBlocks(), 100);
        if (!this.blastMiningCooldownOver() || targetBlock.getType() != Material.TNT || !EventUtils.simulateBlockBreak(targetBlock, player)) {
            return;
        }
        TNTPrimed tnt = (TNTPrimed)player.getWorld().spawn(targetBlock.getLocation(), TNTPrimed.class);
        NotificationManager.sendPlayerInformation(player, NotificationType.SUPER_ABILITY, "Mining.Blast.Boom");
        tnt.setMetadata("mcMMO: Tracked TNT", (MetadataValue)this.mmoPlayer.getPlayerMetadata());
        tnt.setFuseTicks(0);
        tnt.setSource((Entity)player);
        targetBlock.setType(Material.AIR);
        this.mmoPlayer.setAbilityDATS(SuperAbilityType.BLAST_MINING, System.currentTimeMillis());
        this.mmoPlayer.setAbilityInformed(SuperAbilityType.BLAST_MINING, false);
        mcMMO.p.getFoliaLib().getScheduler().runAtEntityLater((Entity)this.mmoPlayer.getPlayer(), new AbilityCooldownTask(this.mmoPlayer, SuperAbilityType.BLAST_MINING), (long)SuperAbilityType.BLAST_MINING.getCooldown() * 20L);
    }

    private boolean isInfestedBlock(String material) {
        return INFESTED_BLOCKS.contains(material.toLowerCase(Locale.ENGLISH));
    }

    public void blastMiningDropProcessing(float yield, EntityExplodeEvent event) {
        if (yield == 0.0f) {
            return;
        }
        float increasedYieldFromBonuses = yield + yield * this.getOreBonus();
        ArrayList<Block> ores = new ArrayList<Block>();
        ArrayList<Block> notOres = new ArrayList<Block>();
        for (Block targetBlock : event.blockList()) {
            if (mcMMO.getUserBlockTracker().isIneligible(targetBlock)) continue;
            if (ExperienceConfig.getInstance().getXp(PrimarySkillType.MINING, targetBlock) != 0) {
                if (BlockUtils.isOre(targetBlock) && !(targetBlock instanceof Container)) {
                    ores.add(targetBlock);
                    continue;
                }
                notOres.add(targetBlock);
                continue;
            }
            notOres.add(targetBlock);
        }
        int xp = 0;
        int dropMultiplier = this.getDropMultiplier();
        for (Block block : notOres) {
            if (this.isDropIllegal(block.getType()) || !block.getType().isItem() || !Probability.ofPercent(10.0).evaluate()) continue;
            ItemUtils.spawnItem(this.getPlayer(), Misc.getBlockCenter(block), new ItemStack(block.getType()), ItemSpawnReason.BLAST_MINING_DEBRIS_NON_ORES);
        }
        for (Block block : ores) {
            float currentOreYield = Math.min(increasedYieldFromBonuses, 3.0f);
            if (this.isDropIllegal(block.getType())) continue;
            xp += ExperienceConfig.getInstance().getXp(PrimarySkillType.MINING, block);
            while (currentOreYield > 0.0f) {
                if (Probability.ofValue(currentOreYield).evaluate()) {
                    Collection<Object> oreDrops = ItemUtils.isPickaxe(this.mmoPlayer.getPlayer().getInventory().getItemInMainHand()) ? block.getDrops(this.mmoPlayer.getPlayer().getInventory().getItemInMainHand()) : List.of(new ItemStack(block.getType()));
                    ItemUtils.spawnItems(this.getPlayer(), Misc.getBlockCenter(block), oreDrops, BLAST_MINING_BLACKLIST, ItemSpawnReason.BLAST_MINING_ORES);
                    if (mcMMO.p.getAdvancedConfig().isBlastMiningBonusDropsEnabled() && Probability.ofValue(0.5).evaluate()) {
                        for (int i = 1; i < dropMultiplier; ++i) {
                            ItemUtils.spawnItems(this.getPlayer(), Misc.getBlockCenter(block), oreDrops, BLAST_MINING_BLACKLIST, ItemSpawnReason.BLAST_MINING_ORES_BONUS_DROP);
                        }
                    }
                }
                currentOreYield = Math.max(currentOreYield - 1.0f, 0.0f);
            }
        }
        event.setYield(0.0f);
        this.applyXpGain(xp, XPGainReason.PVE, XPGainSource.SELF);
    }

    public boolean isDropIllegal(@NotNull Material material) {
        return this.isInfestedBlock(material.getKey().getKey()) || material.getKey().getKey().equalsIgnoreCase(BUDDING_AMETHYST);
    }

    public float biggerBombs(float radius) {
        return (float)((double)radius + this.getBlastRadiusModifier());
    }

    public double processDemolitionsExpertise(double damage) {
        return damage * ((100.0 - this.getBlastDamageModifier()) / 100.0);
    }

    public int getBlastMiningTier() {
        return RankUtils.getRank(this.getPlayer(), SubSkillType.MINING_BLAST_MINING);
    }

    public float getOreBonus() {
        return (float)(mcMMO.p.getAdvancedConfig().getOreBonus(this.getBlastMiningTier()) / 100.0);
    }

    @Deprecated(since="2.2.017", forRemoval=true)
    public static double getOreBonus(int rank) {
        return mcMMO.p.getAdvancedConfig().getOreBonus(rank);
    }

    public static double getDebrisReduction(int rank) {
        return mcMMO.p.getAdvancedConfig().getDebrisReduction(rank);
    }

    public double getDebrisReduction() {
        return MiningManager.getDebrisReduction(this.getBlastMiningTier());
    }

    public static int getDropMultiplier(int rank) {
        return mcMMO.p.getAdvancedConfig().getDropMultiplier(rank);
    }

    public int getDropMultiplier() {
        if (!mcMMO.p.getAdvancedConfig().isBlastMiningBonusDropsEnabled()) {
            return 0;
        }
        return switch (this.getBlastMiningTier()) {
            case 7, 8 -> 3;
            case 3, 4, 5, 6 -> 2;
            case 1, 2 -> 1;
            default -> 0;
        };
    }

    public double getBlastRadiusModifier() {
        return BlastMining.getBlastRadiusModifier(this.getBlastMiningTier());
    }

    public double getBlastDamageModifier() {
        return BlastMining.getBlastDamageDecrease(this.getBlastMiningTier());
    }

    private boolean blastMiningCooldownOver() {
        int timeRemaining = this.mmoPlayer.calculateTimeRemaining(SuperAbilityType.BLAST_MINING);
        if (timeRemaining > 0) {
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.ABILITY_COOLDOWN, "Skills.TooTired", String.valueOf(timeRemaining));
            return false;
        }
        return true;
    }
}

