/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcmmo.kyori.adventure.text.Component;
import com.gmail.nossr50.skills.mining.MiningManager;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.text.TextComponentFactory;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class MiningCommand
extends SkillCommand {
    private String doubleDropChance;
    private String doubleDropChanceLucky;
    private String tripleDropChance;
    private String tripleDropChanceLucky;
    private String superBreakerLength;
    private String superBreakerLengthEndurance;
    private int blastMiningRank;
    private int bonusTNTDrops;
    private double blastRadiusIncrease;
    private String oreBonus;
    private String blastDamageDecrease;
    private boolean canSuperBreaker;
    private boolean canDoubleDrop;
    private boolean canTripleDrop;
    private boolean canBlast;
    private boolean canBiggerBombs;
    private boolean canDemoExpert;

    public MiningCommand() {
        super(PrimarySkillType.MINING);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue) {
        if (this.canBlast || this.canDemoExpert || this.canBiggerBombs) {
            MiningManager miningManager = this.mmoPlayer.getMiningManager();
            this.blastMiningRank = miningManager.getBlastMiningTier();
            this.bonusTNTDrops = miningManager.getDropMultiplier();
            this.oreBonus = this.percent.format(miningManager.getOreBonus());
            this.blastDamageDecrease = this.percent.format(miningManager.getBlastDamageModifier() / 100.0);
            this.blastRadiusIncrease = miningManager.getBlastRadiusModifier();
        }
        if (this.canTripleDrop) {
            String[] masteryTripleDropStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.MINING_MOTHER_LODE);
            this.tripleDropChance = masteryTripleDropStrings[0];
            this.tripleDropChanceLucky = masteryTripleDropStrings[1];
        }
        if (this.canDoubleDrop) {
            String[] doubleDropStrings = ProbabilityUtil.getRNGDisplayValues(this.mmoPlayer, SubSkillType.MINING_DOUBLE_DROPS);
            this.doubleDropChance = doubleDropStrings[0];
            this.doubleDropChanceLucky = doubleDropStrings[1];
        }
        if (this.canSuperBreaker) {
            String[] superBreakerStrings = this.calculateLengthDisplayValues(player, skillValue);
            this.superBreakerLength = superBreakerStrings[0];
            this.superBreakerLengthEndurance = superBreakerStrings[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canBiggerBombs = RankUtils.hasUnlockedSubskill(player, SubSkillType.MINING_BIGGER_BOMBS) && Permissions.biggerBombs((Permissible)player);
        this.canBlast = RankUtils.hasUnlockedSubskill(player, SubSkillType.MINING_BLAST_MINING) && Permissions.remoteDetonation((Permissible)player);
        this.canDemoExpert = RankUtils.hasUnlockedSubskill(player, SubSkillType.MINING_DEMOLITIONS_EXPERTISE) && Permissions.demolitionsExpertise((Permissible)player);
        this.canDoubleDrop = Permissions.canUseSubSkill(player, SubSkillType.MINING_DOUBLE_DROPS);
        this.canTripleDrop = Permissions.canUseSubSkill(player, SubSkillType.MINING_MOTHER_LODE);
        this.canSuperBreaker = RankUtils.hasUnlockedSubskill(player, SubSkillType.MINING_SUPER_BREAKER) && Permissions.superBreaker((Permissible)player);
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canBiggerBombs) {
            messages.add(this.getStatMessage(true, true, SubSkillType.MINING_BLAST_MINING, String.valueOf(this.blastRadiusIncrease)));
        }
        if (this.canBlast) {
            messages.add(this.getStatMessage(false, true, SubSkillType.MINING_BLAST_MINING, String.valueOf(this.blastMiningRank), String.valueOf(RankUtils.getHighestRank(SubSkillType.MINING_BLAST_MINING)), LocaleLoader.getString("Mining.Blast.Effect", this.oreBonus, this.bonusTNTDrops)));
        }
        if (this.canDemoExpert) {
            messages.add(this.getStatMessage(SubSkillType.MINING_DEMOLITIONS_EXPERTISE, this.blastDamageDecrease));
        }
        if (this.canDoubleDrop) {
            messages.add(this.getStatMessage(SubSkillType.MINING_DOUBLE_DROPS, this.doubleDropChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.doubleDropChanceLucky) : ""));
        }
        if (this.canTripleDrop) {
            messages.add(this.getStatMessage(SubSkillType.MINING_MOTHER_LODE, this.tripleDropChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.tripleDropChanceLucky) : ""));
        }
        if (this.canSuperBreaker) {
            messages.add(this.getStatMessage(SubSkillType.MINING_SUPER_BREAKER, this.superBreakerLength) + (hasEndurance ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.superBreakerLengthEndurance) : ""));
        }
        return messages;
    }

    @Override
    protected List<Component> getTextComponents(Player player) {
        ArrayList<Component> textComponents = new ArrayList<Component>();
        TextComponentFactory.getSubSkillTextComponents(player, textComponents, PrimarySkillType.MINING);
        return textComponents;
    }
}

