/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.salvage;

import com.gmail.nossr50.api.ItemSpawnReason;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.salvage.Salvage;
import com.gmail.nossr50.skills.salvage.salvageables.Salvageable;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import com.gmail.nossr50.util.text.StringUtils;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;

public class SalvageManager
extends SkillManager {
    private boolean placedAnvil;
    private int lastClick;

    public SalvageManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.SALVAGE);
    }

    public void placedAnvilCheck() {
        Player player = this.getPlayer();
        if (this.getPlacedAnvil()) {
            return;
        }
        if (mcMMO.p.getGeneralConfig().getSalvageAnvilMessagesEnabled()) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Salvage.Listener.Anvil");
        }
        if (mcMMO.p.getGeneralConfig().getSalvageAnvilPlaceSoundsEnabled()) {
            SoundManager.sendSound(player, player.getLocation(), SoundType.ANVIL);
        }
        this.togglePlacedAnvil();
    }

    public void handleSalvage(Location location, ItemStack item) {
        ItemStack salvageResults;
        Player player = this.getPlayer();
        Salvageable salvageable = mcMMO.getSalvageableManager().getSalvageable(item.getType());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (meta.hasCustomModelData() && !mcMMO.p.getCustomItemSupportConfig().isCustomSalvageAllowed()) {
                NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Anvil.Salvage.Reject.CustomModelData");
                return;
            }
            if (meta.isUnbreakable()) {
                NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Anvil.Unbreakable");
                return;
            }
        }
        if (!Permissions.salvageItemType((Permissible)player, salvageable.getSalvageItemType())) {
            NotificationManager.sendPlayerInformation(player, NotificationType.NO_PERMISSION, "mcMMO.NoPermission");
            return;
        }
        if (!Permissions.salvageMaterialType((Permissible)player, salvageable.getSalvageMaterialType())) {
            NotificationManager.sendPlayerInformation(player, NotificationType.NO_PERMISSION, "mcMMO.NoPermission");
            return;
        }
        int minimumSalvageableLevel = salvageable.getMinimumLevel();
        if (this.getSkillLevel() < minimumSalvageableLevel) {
            NotificationManager.sendPlayerInformation(player, NotificationType.REQUIREMENTS_NOT_MET, "Salvage.Skills.Adept.Level", String.valueOf(minimumSalvageableLevel), StringUtils.getPrettyMaterialString(item.getType()));
            return;
        }
        int durability = meta instanceof Damageable ? ((Damageable)meta).getDamage() : 0;
        int potentialSalvageYield = Salvage.calculateSalvageableAmount(durability, salvageable.getMaximumDurability(), salvageable.getMaximumQuantity());
        if (potentialSalvageYield <= 0) {
            NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE_FAILED, "Salvage.Skills.TooDamaged");
            return;
        }
        potentialSalvageYield = Math.min(potentialSalvageYield, SalvageManager.getSalvageLimit(this.getPlayer()));
        location.add(0.5, 1.0, 0.5);
        Map enchants = item.getEnchantments();
        ItemStack enchantBook = null;
        if (!enchants.isEmpty()) {
            enchantBook = this.arcaneSalvageCheck(enchants);
        }
        if (EventUtils.callSalvageCheckEvent(player, item, salvageResults = new ItemStack(salvageable.getSalvageMaterial(), potentialSalvageYield), enchantBook).isCancelled()) {
            return;
        }
        NotificationManager.sendPlayerInformationChatOnly(player, "Salvage.Skills.Lottery.Normal", String.valueOf(potentialSalvageYield), StringUtils.getPrettyMaterialString(item.getType()));
        player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
        Location anvilLoc = location.clone();
        Location playerLoc = player.getLocation().clone();
        double distance = anvilLoc.distance(playerLoc);
        double speedLimit = 0.6;
        double minSpeed = 0.3;
        double vectorSpeed = Math.min(speedLimit, Math.max(minSpeed, distance * 0.2));
        anvilLoc.add(0.0, 0.1, 0.0);
        if (enchantBook != null) {
            ItemUtils.spawnItemTowardsLocation(this.getPlayer(), anvilLoc.clone(), playerLoc.clone(), enchantBook, vectorSpeed, ItemSpawnReason.SALVAGE_ENCHANTMENT_BOOK);
        }
        ItemUtils.spawnItemTowardsLocation(this.getPlayer(), anvilLoc.clone(), playerLoc.clone(), salvageResults, vectorSpeed, ItemSpawnReason.SALVAGE_MATERIALS);
        if (mcMMO.p.getGeneralConfig().getSalvageAnvilUseSoundsEnabled()) {
            SoundManager.sendSound(player, player.getLocation(), SoundType.ITEM_BREAK);
        }
        NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Salvage.Skills.Success");
    }

    public static int getSalvageLimit(Player player) {
        if (RankUtils.getRank(player, SubSkillType.SALVAGE_SCRAP_COLLECTOR) == 1) {
            return 1;
        }
        int curRank = RankUtils.getRank(player, SubSkillType.SALVAGE_SCRAP_COLLECTOR);
        return curRank * 2;
    }

    public int getArcaneSalvageRank() {
        return RankUtils.getRank(this.getPlayer(), SubSkillType.SALVAGE_ARCANE_SALVAGE);
    }

    public double getExtractFullEnchantChance() {
        if (Permissions.hasSalvageEnchantBypassPerk((Permissible)this.getPlayer())) {
            return 100.0;
        }
        return mcMMO.p.getAdvancedConfig().getArcaneSalvageExtractFullEnchantsChance(this.getArcaneSalvageRank());
    }

    public double getExtractPartialEnchantChance() {
        return mcMMO.p.getAdvancedConfig().getArcaneSalvageExtractPartialEnchantsChance(this.getArcaneSalvageRank());
    }

    private ItemStack arcaneSalvageCheck(Map<Enchantment, Integer> enchants) {
        Player player = this.getPlayer();
        if (!RankUtils.hasUnlockedSubskill(player, SubSkillType.SALVAGE_ARCANE_SALVAGE) || !Permissions.arcaneSalvage((Permissible)player)) {
            NotificationManager.sendPlayerInformationChatOnly(player, "Salvage.Skills.ArcaneFailed", new String[0]);
            return null;
        }
        ItemStack book = new ItemStack(Material.ENCHANTED_BOOK);
        EnchantmentStorageMeta enchantMeta = (EnchantmentStorageMeta)book.getItemMeta();
        boolean downgraded = false;
        int arcaneFailureCount = 0;
        for (Map.Entry<Enchantment, Integer> enchant : enchants.entrySet()) {
            int enchantLevel = enchant.getValue();
            if (!ExperienceConfig.getInstance().allowUnsafeEnchantments() && enchantLevel > enchant.getKey().getMaxLevel()) {
                enchantLevel = enchant.getKey().getMaxLevel();
            }
            if (!Salvage.arcaneSalvageEnchantLoss || Permissions.hasSalvageEnchantBypassPerk((Permissible)player) || ProbabilityUtil.isStaticSkillRNGSuccessful(PrimarySkillType.SALVAGE, this.mmoPlayer, this.getExtractFullEnchantChance())) {
                enchantMeta.addStoredEnchant(enchant.getKey(), enchantLevel, true);
                continue;
            }
            if (enchantLevel > 1 && Salvage.arcaneSalvageDowngrades && ProbabilityUtil.isStaticSkillRNGSuccessful(PrimarySkillType.SALVAGE, this.mmoPlayer, this.getExtractPartialEnchantChance())) {
                enchantMeta.addStoredEnchant(enchant.getKey(), enchantLevel - 1, true);
                downgraded = true;
                continue;
            }
            ++arcaneFailureCount;
        }
        if (this.failedAllEnchants(arcaneFailureCount, enchants.entrySet().size())) {
            NotificationManager.sendPlayerInformationChatOnly(player, "Salvage.Skills.ArcaneFailed", new String[0]);
            return null;
        }
        if (downgraded) {
            NotificationManager.sendPlayerInformationChatOnly(player, "Salvage.Skills.ArcanePartial", new String[0]);
        }
        book.setItemMeta((ItemMeta)enchantMeta);
        return book;
    }

    private boolean failedAllEnchants(int arcaneFailureCount, int size) {
        return arcaneFailureCount == size;
    }

    public boolean checkConfirmation(boolean actualize) {
        Player player = this.getPlayer();
        long lastUse = this.getLastAnvilUse();
        if (!SkillUtils.cooldownExpired(lastUse, 3) || !mcMMO.p.getGeneralConfig().getSalvageConfirmRequired()) {
            return true;
        }
        if (!actualize) {
            return false;
        }
        this.actualizeLastAnvilUse();
        NotificationManager.sendPlayerInformation(player, NotificationType.SUBSKILL_MESSAGE, "Skills.ConfirmOrCancel", LocaleLoader.getString("Salvage.Pretty.Name"));
        return false;
    }

    public boolean getPlacedAnvil() {
        return this.placedAnvil;
    }

    public void togglePlacedAnvil() {
        this.placedAnvil = !this.placedAnvil;
    }

    public int getLastAnvilUse() {
        return this.lastClick;
    }

    public void setLastAnvilUse(int value) {
        this.lastClick = value;
    }

    public void actualizeLastAnvilUse() {
        this.lastClick = (int)(System.currentTimeMillis() / 1000L);
    }
}

