/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.scoreboards;

import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.events.scoreboard.McMMOScoreboardObjectiveEvent;
import com.gmail.nossr50.events.scoreboard.McMMOScoreboardRevertEvent;
import com.gmail.nossr50.events.scoreboard.ScoreboardEventReason;
import com.gmail.nossr50.events.scoreboard.ScoreboardObjectiveEventReason;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import com.gmail.nossr50.util.skills.SkillTools;
import com.tcoded.folialib.wrapper.task.WrappedTask;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;

public class ScoreboardWrapper {
    public static final String SIDE_OBJECTIVE = "mcMMO_sideObjective";
    public static final String POWER_OBJECTIVE = "mcMMO_powerObjective";
    public final String playerName;
    public final Player player;
    private final Scoreboard scoreboard;
    private boolean tippedKeep = false;
    private boolean tippedClear = false;
    private ScoreboardManager.SidebarType sidebarType;
    private Objective sidebarObjective;
    private Objective powerObjective;
    private Scoreboard oldBoard = null;
    public String targetPlayer = null;
    public PrimarySkillType targetSkill = null;
    private PlayerProfile targetProfile = null;
    public int leaderboardPage = -1;
    private boolean registered = false;
    public WrappedTask updateTask = null;
    public WrappedTask revertTask = null;
    public WrappedTask cooldownTask = null;

    public ScoreboardWrapper(Player player, Scoreboard scoreboard) {
        this.player = player;
        this.playerName = player.getName();
        this.scoreboard = scoreboard;
        this.initBoard();
    }

    private void initBoard() {
        this.sidebarType = ScoreboardManager.SidebarType.NONE;
        if (this.registered) {
            this.sidebarObjective = this.scoreboard.getObjective("mcmmo_sidebar");
            this.powerObjective = this.scoreboard.getObjective("mcmmo_pwrlvl");
        } else {
            this.sidebarObjective = this.scoreboard.registerNewObjective("mcmmo_sidebar", "dummy", SIDE_OBJECTIVE);
            this.powerObjective = this.scoreboard.registerNewObjective("mcmmo_pwrlvl", "dummy", POWER_OBJECTIVE);
            this.registered = true;
        }
        if (mcMMO.p.getGeneralConfig().getPowerLevelTagsEnabled()) {
            this.powerObjective.setDisplayName(ScoreboardManager.TAG_POWER_LEVEL);
            this.powerObjective.setDisplaySlot(DisplaySlot.BELOW_NAME);
            for (McMMOPlayer mcMMOPlayer : UserManager.getPlayers()) {
                this.powerObjective.getScore(mcMMOPlayer.getProfile().getPlayerName()).setScore(mcMMOPlayer.getPowerLevel());
            }
        }
    }

    public void doSidebarUpdateSoon() {
        if (this.updateTask == null) {
            this.updateTask = mcMMO.p.getFoliaLib().getScheduler().runAtEntityLater((Entity)this.player, (Runnable)new ScoreboardQuickUpdate(), 2L);
        }
    }

    private void startCooldownUpdating() {
        if (this.cooldownTask == null) {
            this.cooldownTask = mcMMO.p.getFoliaLib().getScheduler().runAtEntityTimer((Entity)this.player, (Runnable)new ScoreboardCooldownTask(), 100L, 100L);
        }
    }

    private void stopCooldownUpdating() {
        if (this.cooldownTask != null) {
            try {
                this.cooldownTask.cancel();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.cooldownTask = null;
        }
    }

    public boolean isSkillScoreboard() {
        return this.sidebarType == ScoreboardManager.SidebarType.SKILL_BOARD;
    }

    public boolean isCooldownScoreboard() {
        return this.sidebarType == ScoreboardManager.SidebarType.COOLDOWNS_BOARD;
    }

    public boolean isStatsScoreboard() {
        return this.sidebarType == ScoreboardManager.SidebarType.STATS_BOARD;
    }

    public void setOldScoreboard() {
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        if (player == null) {
            ScoreboardManager.cleanup(this);
            return;
        }
        Scoreboard previousBoard = player.getScoreboard();
        if (previousBoard == this.scoreboard) {
            if (this.oldBoard == null && mcMMO.p.getServer().getScoreboardManager() != null) {
                this.oldBoard = mcMMO.p.getServer().getScoreboardManager().getMainScoreboard();
            }
        } else {
            this.oldBoard = previousBoard;
        }
    }

    public void showBoardWithNoRevert() {
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        if (player == null) {
            ScoreboardManager.cleanup(this);
            return;
        }
        if (this.revertTask != null) {
            this.revertTask.cancel();
        }
        player.setScoreboard(this.scoreboard);
        this.revertTask = null;
    }

    public void showBoardAndScheduleRevert(int ticks) {
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        if (player == null) {
            ScoreboardManager.cleanup(this);
            return;
        }
        if (this.revertTask != null) {
            this.revertTask.cancel();
        }
        player.setScoreboard(this.scoreboard);
        this.revertTask = mcMMO.p.getFoliaLib().getScheduler().runAtEntityLater((Entity)player, (Runnable)new ScoreboardChangeTask(), (long)ticks);
        if (UserManager.getPlayer(this.playerName) == null) {
            return;
        }
        PlayerProfile profile = UserManager.getPlayer(player).getProfile();
        if (profile.getScoreboardTipsShown() >= mcMMO.p.getGeneralConfig().getTipsAmount()) {
            return;
        }
        if (!this.tippedKeep) {
            this.tippedKeep = true;
            player.sendMessage(LocaleLoader.getString("Commands.Scoreboard.Tip.Keep"));
        } else if (!this.tippedClear) {
            this.tippedClear = true;
            player.sendMessage(LocaleLoader.getString("Commands.Scoreboard.Tip.Clear"));
            profile.increaseTipsShown();
        }
    }

    public void tryRevertBoard() {
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        if (player == null) {
            ScoreboardManager.cleanup(this);
            return;
        }
        if (this.oldBoard != null) {
            if (player.getScoreboard() == this.scoreboard) {
                McMMOScoreboardRevertEvent event = new McMMOScoreboardRevertEvent(this.oldBoard, player.getScoreboard(), player, ScoreboardEventReason.REVERTING_BOARD);
                player.getServer().getPluginManager().callEvent((Event)event);
                event.getTargetPlayer().setScoreboard(event.getTargetBoard());
                this.oldBoard = null;
            } else {
                LogUtils.debug(mcMMO.p.getLogger(), "Not reverting targetBoard for " + this.playerName + " - targetBoard was changed by another plugin (Consider disabling the mcMMO scoreboards if you don't want them!)");
            }
        }
        this.cancelRevert();
        this.sidebarType = ScoreboardManager.SidebarType.NONE;
        this.targetPlayer = null;
        this.targetSkill = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
    }

    public boolean isBoardShown() {
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        if (player == null) {
            ScoreboardManager.cleanup(this);
            return false;
        }
        return player.getScoreboard() == this.scoreboard;
    }

    public void cancelRevert() {
        if (this.revertTask == null) {
            return;
        }
        this.revertTask.cancel();
        this.revertTask = null;
    }

    public void setTypeNone() {
        this.sidebarType = ScoreboardManager.SidebarType.NONE;
        this.targetPlayer = null;
        this.targetSkill = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
        this.loadObjective("");
    }

    public void setTypeSkill(PrimarySkillType skill) {
        this.sidebarType = ScoreboardManager.SidebarType.SKILL_BOARD;
        this.targetSkill = skill;
        this.targetPlayer = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
        this.loadObjective(ScoreboardManager.skillLabels.get((Object)skill));
    }

    public void setTypeSelfStats() {
        this.sidebarType = ScoreboardManager.SidebarType.STATS_BOARD;
        this.targetPlayer = null;
        this.targetSkill = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
        this.loadObjective(ScoreboardManager.HEADER_STATS);
    }

    public void setTypeInspectStats(PlayerProfile profile) {
        this.sidebarType = ScoreboardManager.SidebarType.STATS_BOARD;
        this.targetPlayer = profile.getPlayerName();
        this.targetProfile = profile;
        this.targetSkill = null;
        this.leaderboardPage = -1;
        this.loadObjective(LocaleLoader.getString("Scoreboard.Header.PlayerInspect", this.targetPlayer));
    }

    public void setTypeInspectStats(@NotNull McMMOPlayer mcMMOPlayer) {
        this.sidebarType = ScoreboardManager.SidebarType.STATS_BOARD;
        this.targetPlayer = mcMMOPlayer.getPlayer().getName();
        this.targetProfile = mcMMOPlayer.getProfile();
        this.targetSkill = null;
        this.leaderboardPage = -1;
        this.loadObjective(LocaleLoader.getString("Scoreboard.Header.PlayerInspect", this.targetPlayer));
    }

    public void setTypeCooldowns() {
        this.sidebarType = ScoreboardManager.SidebarType.COOLDOWNS_BOARD;
        this.targetPlayer = null;
        this.targetSkill = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
        this.loadObjective(ScoreboardManager.HEADER_COOLDOWNS);
    }

    public void setTypeSelfRank() {
        this.sidebarType = ScoreboardManager.SidebarType.RANK_BOARD;
        this.targetPlayer = null;
        this.targetSkill = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
        this.loadObjective(ScoreboardManager.HEADER_RANK);
    }

    public void setTypeInspectRank(String otherPlayer) {
        this.sidebarType = ScoreboardManager.SidebarType.RANK_BOARD;
        this.targetPlayer = otherPlayer;
        this.targetSkill = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
        this.loadObjective(ScoreboardManager.HEADER_RANK);
    }

    public void setTypeTopPower(int page) {
        this.sidebarType = ScoreboardManager.SidebarType.TOP_BOARD;
        this.leaderboardPage = page;
        this.targetSkill = null;
        this.targetPlayer = null;
        this.targetProfile = null;
        int endPosition = page * 10;
        int startPosition = endPosition - 9;
        this.loadObjective(String.format("%s (%2d - %2d)", ScoreboardManager.POWER_LEVEL, startPosition, endPosition));
    }

    public void setTypeTop(PrimarySkillType skill, int page) {
        this.sidebarType = ScoreboardManager.SidebarType.TOP_BOARD;
        this.leaderboardPage = page;
        this.targetSkill = skill;
        this.targetPlayer = null;
        this.targetProfile = null;
        int endPosition = page * 10;
        int startPosition = endPosition - 9;
        this.loadObjective(String.format("%s (%2d - %2d)", ScoreboardManager.skillLabels.get((Object)skill), startPosition, endPosition));
    }

    protected void loadObjective(String displayName) {
        McMMOScoreboardObjectiveEvent registerEvent;
        McMMOScoreboardObjectiveEvent unregisterEvent = this.callObjectiveEvent(ScoreboardObjectiveEventReason.UNREGISTER_THIS_OBJECTIVE);
        if (!unregisterEvent.isCancelled()) {
            try {
                this.sidebarObjective.unregister();
            }
            catch (IllegalStateException e) {
                McMMOPlayer mmoPlayer = UserManager.getPlayer(this.player);
                LogUtils.debug(mcMMO.p.getLogger(), "Recovering scoreboard for player: " + this.player.getName());
                if (mmoPlayer.isDebugMode()) {
                    NotificationManager.sendPlayerInformationChatOnlyPrefixed(this.player, "Scoreboard.Recovery", new String[0]);
                }
                this.initBoard();
                mcMMO.p.getFoliaLib().getScheduler().runAtEntity((Entity)this.player, t -> ScoreboardManager.retryLastSkillBoard(this.player));
            }
        }
        if (!(registerEvent = this.callObjectiveEvent(ScoreboardObjectiveEventReason.REGISTER_NEW_OBJECTIVE)).isCancelled()) {
            this.sidebarObjective = registerEvent.getTargetBoard().registerNewObjective("mcmmo_sidebar", "dummy", SIDE_OBJECTIVE);
        }
        if (displayName.length() > 32) {
            displayName = displayName.substring(0, 32);
        }
        this.sidebarObjective.setDisplayName(displayName);
        this.updateSidebar();
        this.sidebarObjective.setDisplaySlot(DisplaySlot.SIDEBAR);
    }

    private McMMOScoreboardObjectiveEvent callObjectiveEvent(ScoreboardObjectiveEventReason reason) {
        McMMOScoreboardObjectiveEvent event = new McMMOScoreboardObjectiveEvent(this.sidebarObjective, reason, this.scoreboard, this.scoreboard, this.player, ScoreboardEventReason.OBJECTIVE);
        this.player.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    private void updateSidebar() {
        if (this.updateTask != null) {
            try {
                this.updateTask.cancel();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.updateTask = null;
        }
        if (this.sidebarType == ScoreboardManager.SidebarType.NONE) {
            return;
        }
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        if (player == null) {
            ScoreboardManager.cleanup(this);
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (mcMMOPlayer == null) {
            return;
        }
        switch (this.sidebarType) {
            case NONE: {
                break;
            }
            case SKILL_BOARD: {
                boolean stopUpdating;
                Objects.requireNonNull(this.targetSkill);
                if (!SkillTools.isChildSkill(this.targetSkill)) {
                    int currentXP = mcMMOPlayer.getSkillXpLevel(this.targetSkill);
                    this.sidebarObjective.getScore(ScoreboardManager.LABEL_CURRENT_XP).setScore(currentXP);
                    this.sidebarObjective.getScore(ScoreboardManager.LABEL_REMAINING_XP).setScore(mcMMOPlayer.getXpToLevel(this.targetSkill) - currentXP);
                } else {
                    for (PrimarySkillType parentSkill : mcMMO.p.getSkillTools().getChildSkillParents(this.targetSkill)) {
                        this.sidebarObjective.getScore(ScoreboardManager.skillLabels.get((Object)parentSkill)).setScore(mcMMOPlayer.getSkillLevel(parentSkill));
                    }
                }
                this.sidebarObjective.getScore(ScoreboardManager.LABEL_LEVEL).setScore(mcMMOPlayer.getSkillLevel(this.targetSkill));
                if (mcMMO.p.getSkillTools().getSuperAbility(this.targetSkill) == null) break;
                if (this.targetSkill == PrimarySkillType.MINING) {
                    Score cooldownSB = this.sidebarObjective.getScore(ScoreboardManager.abilityLabelsSkill.get((Object)SuperAbilityType.SUPER_BREAKER));
                    Score cooldownBM = this.sidebarObjective.getScore(ScoreboardManager.abilityLabelsSkill.get((Object)SuperAbilityType.BLAST_MINING));
                    int secondsSB = Math.max(mcMMOPlayer.calculateTimeRemaining(SuperAbilityType.SUPER_BREAKER), 0);
                    int secondsBM = Math.max(mcMMOPlayer.calculateTimeRemaining(SuperAbilityType.BLAST_MINING), 0);
                    cooldownSB.setScore(secondsSB);
                    cooldownBM.setScore(secondsBM);
                    stopUpdating = secondsSB == 0 && secondsBM == 0;
                } else {
                    SuperAbilityType ability = mcMMO.p.getSkillTools().getSuperAbility(this.targetSkill);
                    Score cooldown = this.sidebarObjective.getScore(ScoreboardManager.abilityLabelsSkill.get((Object)ability));
                    int seconds = Math.max(mcMMOPlayer.calculateTimeRemaining(ability), 0);
                    cooldown.setScore(seconds);
                    boolean bl = stopUpdating = seconds == 0;
                }
                if (stopUpdating) {
                    this.stopCooldownUpdating();
                    break;
                }
                this.startCooldownUpdating();
                break;
            }
            case COOLDOWNS_BOARD: {
                boolean anyCooldownsActive = false;
                for (SuperAbilityType ability : SuperAbilityType.values()) {
                    int seconds = Math.max(mcMMOPlayer.calculateTimeRemaining(ability), 0);
                    if (seconds != 0) {
                        anyCooldownsActive = true;
                    }
                    this.sidebarObjective.getScore(ScoreboardManager.abilityLabelsColored.get((Object)ability)).setScore(seconds);
                }
                if (anyCooldownsActive) {
                    this.startCooldownUpdating();
                    break;
                }
                this.stopCooldownUpdating();
                break;
            }
            case STATS_BOARD: {
                PlayerProfile newProfile = this.targetProfile != null ? this.targetProfile : (this.targetPlayer == null ? mcMMOPlayer.getProfile() : UserManager.getPlayer(this.targetPlayer).getProfile());
                int powerLevel = 0;
                for (PrimarySkillType skill : SkillTools.NON_CHILD_SKILLS) {
                    int level = newProfile.getSkillLevel(skill);
                    powerLevel += level;
                    if (!mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player, skill)) continue;
                    this.sidebarObjective.getScore(ScoreboardManager.skillLabels.get((Object)skill)).setScore(level);
                }
                this.sidebarObjective.getScore(ScoreboardManager.LABEL_POWER_LEVEL).setScore(powerLevel);
                break;
            }
            case RANK_BOARD: 
            case TOP_BOARD: {
                break;
            }
        }
    }

    public void acceptRankData(Map<PrimarySkillType, Integer> rankData) {
        Integer rank;
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        for (PrimarySkillType skill : SkillTools.NON_CHILD_SKILLS) {
            if (!mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(player, skill) || (rank = rankData.get((Object)skill)) == null) continue;
            this.sidebarObjective.getScore(ScoreboardManager.skillLabels.get((Object)skill)).setScore(rank.intValue());
        }
        rank = rankData.get(null);
        if (rank != null) {
            this.sidebarObjective.getScore(ScoreboardManager.LABEL_POWER_LEVEL).setScore(rank.intValue());
        }
    }

    public void acceptLeaderboardData(@NotNull List<PlayerStat> leaderboardData) {
        for (PlayerStat stat : leaderboardData) {
            Object name = stat.name;
            if (((String)name).equals(this.playerName)) {
                name = String.valueOf(ChatColor.GOLD) + "--You--";
            }
            this.sidebarObjective.getScore((String)name).setScore(stat.statVal);
        }
    }

    public void updatePowerLevel(Player player, int newPowerLevel) {
        this.powerObjective.getScore(player.getName()).setScore(newPowerLevel);
    }

    private class ScoreboardQuickUpdate
    implements Runnable {
        private ScoreboardQuickUpdate() {
        }

        @Override
        public void run() {
            ScoreboardWrapper.this.updateSidebar();
            ScoreboardWrapper.this.updateTask = null;
        }
    }

    private class ScoreboardCooldownTask
    implements Runnable {
        private ScoreboardCooldownTask() {
        }

        @Override
        public void run() {
            if (ScoreboardWrapper.this.isBoardShown() && (ScoreboardWrapper.this.isSkillScoreboard() || ScoreboardWrapper.this.isCooldownScoreboard())) {
                ScoreboardWrapper.this.doSidebarUpdateSoon();
            } else {
                ScoreboardWrapper.this.stopCooldownUpdating();
            }
        }
    }

    private class ScoreboardChangeTask
    implements Runnable {
        private ScoreboardChangeTask() {
        }

        @Override
        public void run() {
            ScoreboardWrapper.this.tryRevertBoard();
            ScoreboardWrapper.this.revertTask = null;
        }
    }
}

