/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config;

import com.gmail.nossr50.mcMMO;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.file.YamlConfiguration;

public class HiddenConfig {
    private static HiddenConfig instance;
    private final String fileName;
    private YamlConfiguration config;
    private int conversionRate;
    private boolean useEnchantmentBuffs;

    public HiddenConfig(String fileName) {
        this.fileName = fileName;
        this.load();
    }

    public static HiddenConfig getInstance() {
        if (instance == null) {
            instance = new HiddenConfig("hidden.yml");
        }
        return instance;
    }

    public void load() {
        InputStreamReader reader = mcMMO.p.getResourceAsReader(this.fileName);
        if (reader != null) {
            this.config = YamlConfiguration.loadConfiguration((Reader)reader);
            this.conversionRate = this.config.getInt("Options.ConversionRate", 1);
            this.useEnchantmentBuffs = this.config.getBoolean("Options.EnchantmentBuffs", true);
        }
    }

    public int getConversionRate() {
        return this.conversionRate;
    }

    public boolean useEnchantmentBuffs() {
        return this.useEnchantmentBuffs;
    }
}

