/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.PotionCompatibilityType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionUtil {
    private static final Map<String, String> legacyPotionTypes = new HashMap<String, String>();
    private static final Method methodPotionTypeGetKey;
    private static final Method methodPotionTypeGetEffectType;
    private static final Method methodPotionTypeGetPotionEffects;
    private static final Method methodPotionDataIsUpgraded;
    private static final Method methodPotionDataIsExtended;
    private static final Method methodPotionDataGetType;
    private static final Method methodPotionMetaGetBasePotionData;
    private static final Method methodPotionMetaSetBasePotionData;
    private static final Method methodPotionMetaGetBasePotionType;
    private static final Method methodPotionMetaSetBasePotionType;
    private static final Class<?> potionDataClass;
    public static final String STRONG = "STRONG";
    public static final String LONG = "LONG";
    public static final String WATER_POTION_TYPE_STR = "WATER";
    private static final PotionCompatibilityType COMPATIBILITY_MODE;

    public static PotionType matchPotionType(String partialName, boolean isUpgraded, boolean isExtended) {
        if (COMPATIBILITY_MODE == PotionCompatibilityType.PRE_1_20_5) {
            return PotionUtil.matchLegacyPotionType(partialName);
        }
        String updatedName = PotionUtil.convertLegacyNames(partialName).toUpperCase();
        return Arrays.stream(PotionType.values()).filter(potionType -> PotionUtil.getKeyGetKey(potionType).toUpperCase().contains(updatedName)).filter(potionType -> isUpgraded == potionType.name().toUpperCase().startsWith("STRONG_")).filter(potionType -> isExtended == potionType.name().toUpperCase().startsWith("LONG_")).findAny().orElse(null);
    }

    private static PotionType matchLegacyPotionType(String name) {
        return Arrays.stream(PotionType.values()).filter(potionType -> PotionUtil.getKeyGetKey(potionType).equalsIgnoreCase(name) || PotionUtil.getKeyGetKey(potionType).equalsIgnoreCase(PotionUtil.convertLegacyNames(name)) || potionType.name().equalsIgnoreCase(name) || potionType.name().equalsIgnoreCase(PotionUtil.convertLegacyNames(name))).findAny().orElse(null);
    }

    private static String convertUpgradedOrExtended(String potionType, boolean isUpgraded, boolean isExtended) {
        if (isUpgraded) {
            potionType = "STRONG_" + (String)potionType;
        }
        if (isExtended) {
            potionType = "LONG_" + (String)potionType;
        }
        return potionType;
    }

    public static String getKeyGetKey(PotionType potionType) {
        try {
            if (PotionUtil.getKeyMethod() != null) {
                NamespacedKey key = (NamespacedKey)methodPotionTypeGetKey.invoke((Object)potionType, new Object[0]);
                return key.getKey();
            }
            return potionType.name();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            mcMMO.p.getLogger().warning("Failed to get potion key for " + potionType.name());
            return potionType.name();
        }
    }

    private static Class<?> getPotionDataClass() {
        try {
            return Class.forName("org.bukkit.potion.PotionData");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Nullable
    private static Method getKeyMethod() {
        try {
            return PotionType.class.getMethod("getKey", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    private static Method setBasePotionData() {
        try {
            return PotionMeta.class.getMethod("setBasePotionData", potionDataClass);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method getMethodPotionMetaSetBasePotionType() {
        try {
            return PotionMeta.class.getMethod("setBasePotionType", PotionType.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method getSetBasePotionData() {
        try {
            return PotionMeta.class.getMethod("setBasePotionData", potionDataClass);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    private static Method getPotionDataIsUpgraded() {
        try {
            Class<?> clazz = Class.forName("org.bukkit.potion.PotionData");
            return clazz.getMethod("isUpgraded", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    private static Method getPotionDataIsExtended() {
        try {
            Class<?> clazz = Class.forName("org.bukkit.potion.PotionData");
            return clazz.getMethod("isExtended", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    private static Method getGetBasePotionDataMethod() {
        try {
            return PotionMeta.class.getMethod("getBasePotionData", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method getGetBasePotionTypeMethod() {
        try {
            return PotionMeta.class.getMethod("getBasePotionType", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method getPotionDataGetTypeMethod() {
        try {
            Class<?> clazz = Class.forName("org.bukkit.potion.PotionData");
            return clazz.getMethod("getType", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return null;
        }
    }

    private static Method getPotionTypeEffectTypeMethod() {
        try {
            return PotionType.class.getMethod("getEffectType", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method getPotionTypeGetPotionEffectsMethod() {
        try {
            return PotionType.class.getMethod("getPotionEffects", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static String convertPotionConfigName(String legacyName) {
        Object replacementName = legacyName;
        if (((String)replacementName).contains("POTION_OF_")) {
            replacementName = ((String)replacementName).replace("POTION_OF_", "");
        }
        if (((String)replacementName).contains("_II")) {
            replacementName = ((String)replacementName).replace("_II", "");
            replacementName = "STRONG_" + (String)replacementName;
        } else if (((String)replacementName).contains("_EXTENDED")) {
            replacementName = ((String)replacementName).replace("_EXTENDED", "");
            replacementName = "LONG_" + (String)replacementName;
        }
        return replacementName;
    }

    public static String convertLegacyNames(String legacyPotionType) {
        String modernized = legacyPotionType;
        for (String key : legacyPotionTypes.keySet()) {
            if (!modernized.contains(key)) continue;
            modernized = modernized.replace(key, legacyPotionTypes.get(key));
            break;
        }
        return modernized;
    }

    public static boolean hasLegacyName(String potionType) {
        for (String key : legacyPotionTypes.keySet()) {
            if (!potionType.contains(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStrong(PotionMeta potionMeta) {
        if (methodPotionMetaGetBasePotionData == null) {
            return PotionUtil.isStrongModern(potionMeta);
        }
        return PotionUtil.isStrongLegacy(potionMeta);
    }

    public static boolean isLong(PotionMeta potionMeta) {
        if (methodPotionMetaGetBasePotionData == null) {
            return PotionUtil.isLongModern(potionMeta);
        }
        return PotionUtil.isLongLegacy(potionMeta);
    }

    private static boolean isLongLegacy(PotionMeta potionMeta) {
        try {
            Object potionData = methodPotionMetaGetBasePotionData.invoke((Object)potionMeta, new Object[0]);
            return (Boolean)methodPotionDataIsExtended.invoke(potionData, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isLongModern(PotionMeta potionMeta) {
        try {
            return PotionUtil.getModernPotionTypeKey(potionMeta).getKey().startsWith(LONG);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isStrongLegacy(PotionMeta potionMeta) {
        try {
            Object potionData = methodPotionMetaGetBasePotionData.invoke((Object)potionMeta, new Object[0]);
            return (Boolean)methodPotionDataIsUpgraded.invoke(potionData, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isStrongModern(PotionMeta potionMeta) {
        try {
            return PotionUtil.getModernPotionTypeKey(potionMeta).getKey().startsWith(STRONG);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static NamespacedKey getModernPotionTypeKey(PotionMeta potionMeta) throws IllegalAccessException, InvocationTargetException {
        PotionType potionType = (PotionType)methodPotionMetaGetBasePotionType.invoke((Object)potionMeta, new Object[0]);
        return (NamespacedKey)methodPotionTypeGetKey.invoke((Object)potionType, new Object[0]);
    }

    public static boolean isPotionJustWater(PotionMeta potionMeta) {
        return PotionUtil.isPotionTypeWater(potionMeta) && !PotionUtil.hasBasePotionEffects(potionMeta) && potionMeta.getCustomEffects().isEmpty();
    }

    public static boolean isPotionTypeWater(@NotNull PotionMeta potionMeta) {
        if (COMPATIBILITY_MODE == PotionCompatibilityType.PRE_1_20_5) {
            return PotionUtil.isPotionTypeWaterLegacy(potionMeta);
        }
        return PotionUtil.isPotionTypeWaterModern(potionMeta);
    }

    public static boolean isPotionType(@NotNull PotionMeta potionMeta, String potionType) {
        if (COMPATIBILITY_MODE == PotionCompatibilityType.PRE_1_20_5) {
            return PotionUtil.isPotionTypeLegacy(potionMeta, potionType);
        }
        return PotionUtil.isPotionTypeModern(potionMeta, potionType);
    }

    public static boolean isPotionTypeWithoutEffects(@NotNull PotionMeta potionMeta, String potionType) {
        return PotionUtil.isPotionType(potionMeta, potionType) && !PotionUtil.hasBasePotionEffects(potionMeta) && potionMeta.getCustomEffects().isEmpty();
    }

    private static boolean isPotionTypeModern(@NotNull PotionMeta potionMeta, String potionType) {
        try {
            return PotionUtil.getModernPotionTypeKey(potionMeta).getKey().equalsIgnoreCase(potionType);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean isPotionTypeLegacy(@NotNull PotionMeta potionMeta, String potionType) {
        try {
            Object potionData = methodPotionMetaGetBasePotionData.invoke((Object)potionMeta, new Object[0]);
            PotionType potionTypeObj = (PotionType)methodPotionDataGetType.invoke(potionData, new Object[0]);
            return potionTypeObj.name().equalsIgnoreCase(potionType);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean isPotionTypeWaterLegacy(@NotNull PotionMeta potionMeta) {
        try {
            Object potionData = methodPotionMetaGetBasePotionData.invoke((Object)potionMeta, new Object[0]);
            PotionType potionType = (PotionType)methodPotionDataGetType.invoke(potionData, new Object[0]);
            return potionType.name().equalsIgnoreCase(WATER_POTION_TYPE_STR) || PotionType.valueOf((String)WATER_POTION_TYPE_STR) == potionType;
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean isPotionTypeWaterModern(@NotNull PotionMeta potionMeta) {
        try {
            return PotionUtil.getModernPotionTypeKey(potionMeta).getKey().equalsIgnoreCase(WATER_POTION_TYPE_STR);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean samePotionType(PotionMeta potionMeta, PotionMeta otherPotionMeta) {
        if (COMPATIBILITY_MODE == PotionCompatibilityType.PRE_1_20_5) {
            return PotionUtil.samePotionTypeLegacy(potionMeta, otherPotionMeta);
        }
        return PotionUtil.samePotionTypeModern(potionMeta, otherPotionMeta);
    }

    private static boolean samePotionTypeLegacy(PotionMeta potionMeta, PotionMeta otherPotionMeta) {
        try {
            Object potionData = methodPotionMetaGetBasePotionData.invoke((Object)potionMeta, new Object[0]);
            Object otherPotionData = methodPotionMetaGetBasePotionData.invoke((Object)otherPotionMeta, new Object[0]);
            PotionType potionType = (PotionType)methodPotionDataGetType.invoke(potionData, new Object[0]);
            PotionType otherPotionType = (PotionType)methodPotionDataGetType.invoke(otherPotionData, new Object[0]);
            return potionType == otherPotionType;
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean samePotionTypeModern(PotionMeta potionMeta, PotionMeta otherPotionMeta) {
        try {
            PotionType potionType = (PotionType)methodPotionMetaGetBasePotionType.invoke((Object)potionMeta, new Object[0]);
            PotionType otherPotionType = (PotionType)methodPotionMetaGetBasePotionType.invoke((Object)otherPotionMeta, new Object[0]);
            return potionType == otherPotionType;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean samePotionEffects(PotionMeta potionMeta, PotionMeta otherPotionMeta) {
        if (COMPATIBILITY_MODE == PotionCompatibilityType.PRE_1_20_5) {
            return true;
        }
        return PotionUtil.samePotionEffectsModern(potionMeta, otherPotionMeta);
    }

    private static boolean samePotionEffectsModern(PotionMeta potionMeta, PotionMeta otherPotionMeta) {
        return potionMeta.getCustomEffects().equals(otherPotionMeta.getCustomEffects());
    }

    public static boolean hasBasePotionEffects(PotionMeta potionMeta) {
        if (COMPATIBILITY_MODE == PotionCompatibilityType.PRE_1_20_5) {
            return PotionUtil.hasBasePotionEffectsLegacy(potionMeta);
        }
        return PotionUtil.hasBasePotionEffectsModern(potionMeta);
    }

    private static boolean hasBasePotionEffectsLegacy(PotionMeta potionMeta) {
        try {
            Object potionData = methodPotionMetaGetBasePotionData.invoke((Object)potionMeta, new Object[0]);
            PotionType potionType = (PotionType)methodPotionDataGetType.invoke(potionData, new Object[0]);
            return methodPotionTypeGetEffectType.invoke((Object)potionType, new Object[0]) != null;
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean hasBasePotionEffectsModern(PotionMeta potionMeta) {
        try {
            PotionType potionType = (PotionType)methodPotionMetaGetBasePotionType.invoke((Object)potionMeta, new Object[0]);
            List potionEffectTypeList = (List)methodPotionTypeGetPotionEffects.invoke((Object)potionType, new Object[0]);
            return potionEffectTypeList != null && !potionEffectTypeList.isEmpty();
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void setBasePotionType(PotionMeta potionMeta, PotionType potionType, boolean extended, boolean upgraded) {
        if (methodPotionMetaSetBasePotionType == null) {
            PotionUtil.setBasePotionTypeLegacy(potionMeta, potionType, extended, upgraded);
        } else {
            PotionUtil.setBasePotionTypeModern(potionMeta, potionType);
        }
    }

    public static void setUpgradedAndExtendedProperties(PotionType potionType, PotionMeta potionMeta, boolean isUpgraded, boolean isExtended) {
        if (potionDataClass == null || mcMMO.getCompatibilityManager().getMinecraftGameVersion().isAtLeast(1, 20, 5)) {
            return;
        }
        try {
            Object potionData = potionDataClass.getConstructor(PotionType.class, Boolean.TYPE, Boolean.TYPE).newInstance(potionType, isExtended, isUpgraded);
            methodPotionMetaSetBasePotionData.invoke((Object)potionMeta, potionData);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void setBasePotionTypeLegacy(PotionMeta potionMeta, PotionType potionType, boolean extended, boolean upgraded) {
        try {
            Object potionData = potionDataClass.getConstructor(PotionType.class, Boolean.TYPE, Boolean.TYPE).newInstance(potionType, extended, upgraded);
            methodPotionMetaSetBasePotionData.invoke((Object)potionMeta, potionData);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void setBasePotionTypeModern(PotionMeta potionMeta, PotionType potionType) {
        try {
            methodPotionMetaSetBasePotionType.invoke((Object)potionMeta, potionType);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isPotionDataEqual(PotionMeta potionMeta, PotionMeta otherPotionMeta) {
        if (COMPATIBILITY_MODE == PotionCompatibilityType.MODERN) {
            return true;
        }
        try {
            Object potionData = methodPotionMetaGetBasePotionData.invoke((Object)potionMeta, new Object[0]);
            Object otherPotionData = methodPotionMetaGetBasePotionData.invoke((Object)otherPotionMeta, new Object[0]);
            PotionType potionType = (PotionType)methodPotionDataGetType.invoke(potionData, new Object[0]);
            PotionType otherPotionType = (PotionType)methodPotionDataGetType.invoke(otherPotionData, new Object[0]);
            if (potionType != otherPotionType) {
                return false;
            }
            if (methodPotionDataIsExtended.invoke(potionData, new Object[0]) != methodPotionDataIsExtended.invoke(otherPotionData, new Object[0])) {
                return false;
            }
            return methodPotionDataIsUpgraded.invoke(potionData, new Object[0]) == methodPotionDataIsUpgraded.invoke(otherPotionData, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        potionDataClass = PotionUtil.getPotionDataClass();
        legacyPotionTypes.put("UNCRAFTABLE", "MUNDANE");
        legacyPotionTypes.put("JUMP", "LEAPING");
        legacyPotionTypes.put("SPEED", "SWIFTNESS");
        legacyPotionTypes.put("INSTANT_HEAL", "HEALING");
        legacyPotionTypes.put("INSTANT_DAMAGE", "HARMING");
        legacyPotionTypes.put("REGEN", "REGENERATION");
        methodPotionTypeGetKey = PotionUtil.getKeyMethod();
        methodPotionDataIsUpgraded = PotionUtil.getPotionDataIsUpgraded();
        methodPotionDataIsExtended = PotionUtil.getPotionDataIsExtended();
        methodPotionMetaGetBasePotionData = PotionUtil.getGetBasePotionDataMethod();
        methodPotionMetaGetBasePotionType = PotionUtil.getGetBasePotionTypeMethod();
        methodPotionMetaSetBasePotionType = PotionUtil.getMethodPotionMetaSetBasePotionType();
        methodPotionDataGetType = PotionUtil.getPotionDataGetTypeMethod();
        methodPotionTypeGetEffectType = PotionUtil.getPotionTypeEffectTypeMethod();
        methodPotionTypeGetPotionEffects = PotionUtil.getPotionTypeGetPotionEffectsMethod();
        methodPotionMetaSetBasePotionData = PotionUtil.setBasePotionData();
        COMPATIBILITY_MODE = potionDataClass != null && !mcMMO.getCompatibilityManager().getMinecraftGameVersion().isAtLeast(1, 20, 5) ? PotionCompatibilityType.PRE_1_20_5 : PotionCompatibilityType.MODERN;
    }
}

