/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.taming;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.subskills.taming.CallOfTheWildType;
import com.gmail.nossr50.datatypes.skills.subskills.taming.TamingSummon;
import com.gmail.nossr50.events.skills.taming.McMMOPlayerTameEntityEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.metadata.MobMetaFlagType;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.taming.Taming;
import com.gmail.nossr50.skills.taming.TrackedTamingEntity;
import com.gmail.nossr50.util.AttributeMapper;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.MobMetadataUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import com.gmail.nossr50.util.text.StringUtils;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class TamingManager
extends SkillManager {
    private static HashMap<Material, CallOfTheWildType> summoningItems;
    private static HashMap<CallOfTheWildType, TamingSummon> cotwSummonDataProperties;
    private long lastSummonTimeStamp;

    public TamingManager(@NotNull McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, PrimarySkillType.TAMING);
        this.init();
    }

    private void init() {
        this.lastSummonTimeStamp = 0L;
        mcMMO.getTransientEntityTracker().initPlayer(this.mmoPlayer.getPlayer());
        this.initStaticCaches();
    }

    private void initStaticCaches() {
        if (summoningItems == null) {
            summoningItems = new HashMap();
            summoningItems.put(mcMMO.p.getGeneralConfig().getTamingCOTWMaterial(CallOfTheWildType.CAT.getConfigEntityTypeEntry()), CallOfTheWildType.CAT);
            summoningItems.put(mcMMO.p.getGeneralConfig().getTamingCOTWMaterial(CallOfTheWildType.WOLF.getConfigEntityTypeEntry()), CallOfTheWildType.WOLF);
            summoningItems.put(mcMMO.p.getGeneralConfig().getTamingCOTWMaterial(CallOfTheWildType.HORSE.getConfigEntityTypeEntry()), CallOfTheWildType.HORSE);
        }
        if (cotwSummonDataProperties == null) {
            cotwSummonDataProperties = new HashMap();
            for (CallOfTheWildType callOfTheWildType : CallOfTheWildType.values()) {
                Material itemSummonMaterial = mcMMO.p.getGeneralConfig().getTamingCOTWMaterial(callOfTheWildType.getConfigEntityTypeEntry());
                int itemAmountRequired = mcMMO.p.getGeneralConfig().getTamingCOTWCost(callOfTheWildType.getConfigEntityTypeEntry());
                int entitiesSummonedPerCOTW = mcMMO.p.getGeneralConfig().getTamingCOTWAmount(callOfTheWildType.getConfigEntityTypeEntry());
                int summonLifespanSeconds = mcMMO.p.getGeneralConfig().getTamingCOTWLength(callOfTheWildType.getConfigEntityTypeEntry());
                int perPlayerMaxAmount = mcMMO.p.getGeneralConfig().getTamingCOTWMaxAmount(callOfTheWildType.getConfigEntityTypeEntry());
                TamingSummon tamingSummon = new TamingSummon(callOfTheWildType, itemSummonMaterial, itemAmountRequired, entitiesSummonedPerCOTW, summonLifespanSeconds, perPlayerMaxAmount);
                cotwSummonDataProperties.put(callOfTheWildType, tamingSummon);
            }
        }
    }

    public boolean canUseThickFur() {
        return RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_THICK_FUR) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.TAMING_THICK_FUR);
    }

    public boolean canUseEnvironmentallyAware() {
        return RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_ENVIRONMENTALLY_AWARE) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.TAMING_ENVIRONMENTALLY_AWARE);
    }

    public boolean canUseShockProof() {
        return RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_SHOCK_PROOF) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.TAMING_SHOCK_PROOF);
    }

    public boolean canUseHolyHound() {
        return RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_ENVIRONMENTALLY_AWARE) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.TAMING_HOLY_HOUND);
    }

    public boolean canUseFastFoodService() {
        return RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_FAST_FOOD_SERVICE) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.TAMING_FAST_FOOD_SERVICE);
    }

    public boolean canUseSharpenedClaws() {
        return RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_SHARPENED_CLAWS) && Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.TAMING_SHARPENED_CLAWS);
    }

    public boolean canUseGore() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_GORE)) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.TAMING_GORE);
    }

    public boolean canUseBeastLore() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_BEAST_LORE)) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.TAMING_BEAST_LORE);
    }

    public void awardTamingXP(@NotNull LivingEntity entity) {
        int xp = ExperienceConfig.getInstance().getTamingXP(entity.getType());
        McMMOPlayerTameEntityEvent event = new McMMOPlayerTameEntityEvent(this.mmoPlayer, xp, (Entity)entity);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.applyXpGain(event.getXpGained(), XPGainReason.PVE, XPGainSource.SELF);
        }
    }

    public void fastFoodService(@NotNull Wolf wolf, double damage) {
        double maxHealth;
        if (!ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.TAMING_FAST_FOOD_SERVICE, this.mmoPlayer)) {
            return;
        }
        double health = wolf.getHealth();
        if (health < (maxHealth = wolf.getMaxHealth())) {
            double newHealth = health + damage;
            wolf.setHealth(Math.min(newHealth, maxHealth));
        }
    }

    public double gore(@NotNull LivingEntity target, double damage) {
        damage = damage * Taming.goreModifier - damage;
        return damage;
    }

    public double sharpenedClaws() {
        return Taming.sharpenedClawsBonusDamage;
    }

    public void summonOcelot() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_CALL_OF_THE_WILD)) {
            return;
        }
        if (!Permissions.callOfTheWild((Permissible)this.getPlayer(), EntityType.OCELOT)) {
            return;
        }
        this.processCallOfTheWild();
    }

    public void summonWolf() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_CALL_OF_THE_WILD)) {
            return;
        }
        if (!Permissions.callOfTheWild((Permissible)this.getPlayer(), EntityType.WOLF)) {
            return;
        }
        this.processCallOfTheWild();
    }

    public void summonHorse() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_CALL_OF_THE_WILD)) {
            return;
        }
        if (!Permissions.callOfTheWild((Permissible)this.getPlayer(), EntityType.HORSE)) {
            return;
        }
        this.processCallOfTheWild();
    }

    public void beastLore(LivingEntity target) {
        Player player = this.getPlayer();
        Tameable beast = (Tameable)target;
        Object message = LocaleLoader.getString("Combat.BeastLore") + " ";
        if (beast.isTamed() && beast.getOwner() != null) {
            message = ((String)message).concat(LocaleLoader.getString("Combat.BeastLoreOwner", beast.getOwner().getName()) + " ");
        }
        message = ((String)message).concat(LocaleLoader.getString("Combat.BeastLoreHealth", target.getHealth(), target.getMaxHealth()));
        if (beast instanceof AbstractHorse) {
            AttributeInstance jumpAttribute;
            AbstractHorse horseLikeCreature = (AbstractHorse)beast;
            if (!(beast instanceof Llama) && (jumpAttribute = horseLikeCreature.getAttribute(AttributeMapper.MAPPED_JUMP_STRENGTH)) != null) {
                double jumpStrength = jumpAttribute.getValue();
                jumpStrength = -0.1817584952 * Math.pow(jumpStrength, 3.0) + 3.689713992 * Math.pow(jumpStrength, 2.0) + 2.128599134 * jumpStrength - 0.343930367;
                message = ((String)message).concat("\n" + LocaleLoader.getString("Combat.BeastLoreHorseSpeed", horseLikeCreature.getAttribute(AttributeMapper.MAPPED_MOVEMENT_SPEED).getValue() * 43.0)).concat("\n" + LocaleLoader.getString("Combat.BeastLoreHorseJumpStrength", jumpStrength));
            }
        }
        player.sendMessage((String)message);
    }

    public void processEnvironmentallyAware(@NotNull Wolf wolf, double damage) {
        if (damage > wolf.getHealth()) {
            return;
        }
        Player owner = this.getPlayer();
        wolf.teleport((Entity)owner);
        NotificationManager.sendPlayerInformation(owner, NotificationType.SUBSKILL_MESSAGE, "Taming.Listener.Wolf");
    }

    public void pummel(LivingEntity target, Wolf wolf) {
        Player defender;
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.TAMING_PUMMEL)) {
            return;
        }
        if (!ProbabilityUtil.isStaticSkillRNGSuccessful(PrimarySkillType.TAMING, this.mmoPlayer, mcMMO.p.getAdvancedConfig().getPummelChance())) {
            return;
        }
        ParticleEffectUtils.playGreaterImpactEffect(target);
        target.setVelocity(wolf.getLocation().getDirection().normalize().multiply(1.5));
        if (target instanceof Player && NotificationManager.doesPlayerUseNotifications(defender = (Player)target)) {
            NotificationManager.sendPlayerInformation(defender, NotificationType.SUBSKILL_MESSAGE, "Taming.SubSkill.Pummel.TargetMessage");
        }
    }

    public void attackTarget(LivingEntity target) {
        Tameable tameable;
        if (target instanceof Tameable && (tameable = (Tameable)target).getOwner() == this.getPlayer()) {
            return;
        }
        double range = 5.0;
        Player player = this.getPlayer();
        if (!target.getWorld().equals((Object)player.getWorld())) {
            return;
        }
        for (Entity entity : player.getNearbyEntities(range, range, range)) {
            Wolf wolf;
            if (entity.getType() != EntityType.WOLF || !(wolf = (Wolf)entity).isTamed() || wolf.getOwner() != player || wolf.isSitting()) continue;
            wolf.setTarget(target);
        }
    }

    private void processCallOfTheWild() {
        if (this.lastSummonTimeStamp + 150L > System.currentTimeMillis()) {
            return;
        }
        this.lastSummonTimeStamp = System.currentTimeMillis();
        Player player = this.getPlayer();
        ItemStack itemInMainHand = player.getInventory().getItemInMainHand();
        if (this.isCOTWItem(itemInMainHand)) {
            CallOfTheWildType callOfTheWildType = summoningItems.get(itemInMainHand.getType());
            TamingSummon tamingSummon = cotwSummonDataProperties.get((Object)callOfTheWildType);
            int amountSummoned = 0;
            if (itemInMainHand.getAmount() >= tamingSummon.getItemAmountRequired()) {
                Location spawnLocation = Misc.getLocationOffset(player.getLocation(), 1.0);
                for (int i = 0; i < tamingSummon.getEntitiesSummoned(); ++i) {
                    if (this.getAmountCurrentlySummoned(callOfTheWildType) >= tamingSummon.getSummonCap()) {
                        NotificationManager.sendPlayerInformationChatOnly(player, "Taming.Summon.COTW.Limit", String.valueOf(tamingSummon.getSummonCap()), StringUtils.getCapitalized(callOfTheWildType.toString()));
                        break;
                    }
                    spawnLocation = Misc.getLocationOffset(spawnLocation, 1.0);
                    this.spawnCOTWEntity(callOfTheWildType, spawnLocation, tamingSummon.getEntityType());
                    if (tamingSummon.getSummonLifespan() > 0) {
                        NotificationManager.sendPlayerInformationChatOnly(player, "Taming.Summon.COTW.Success.WithLifespan", StringUtils.getCapitalized(callOfTheWildType.toString()), String.valueOf(tamingSummon.getSummonLifespan()));
                    } else {
                        NotificationManager.sendPlayerInformationChatOnly(player, "Taming.Summon.COTW.Success.WithoutLifespan", StringUtils.getCapitalized(callOfTheWildType.toString()));
                    }
                    SoundManager.sendSound(player, player.getLocation(), SoundType.ABILITY_ACTIVATED_GENERIC);
                    ++amountSummoned;
                }
                if (amountSummoned >= 1) {
                    int itemAmountAfterPayingCost = itemInMainHand.getAmount() - tamingSummon.getItemAmountRequired();
                    itemInMainHand.setAmount(itemAmountAfterPayingCost);
                    player.updateInventory();
                }
            } else {
                int difference = tamingSummon.getItemAmountRequired() - itemInMainHand.getAmount();
                NotificationManager.sendPlayerInformationChatOnly(player, "Taming.Summon.COTW.NeedMoreItems", String.valueOf(difference), StringUtils.getPrettyMaterialString(itemInMainHand.getType()));
            }
        }
    }

    private void spawnCOTWEntity(CallOfTheWildType callOfTheWildType, Location spawnLocation, EntityType entityType) {
        switch (callOfTheWildType) {
            case CAT: {
                this.spawnCat(spawnLocation, entityType);
                break;
            }
            case HORSE: {
                this.spawnHorse(spawnLocation);
                break;
            }
            case WOLF: {
                this.spawnWolf(spawnLocation);
            }
        }
    }

    private void spawnWolf(Location spawnLocation) {
        LivingEntity callOfWildEntity = (LivingEntity)this.getPlayer().getWorld().spawnEntity(spawnLocation, EntityType.WOLF);
        this.applyMetaDataToCOTWEntity(callOfWildEntity);
        this.setBaseCOTWEntityProperties(callOfWildEntity);
        ((Wolf)callOfWildEntity).setAdult();
        this.addToTracker(callOfWildEntity, CallOfTheWildType.WOLF);
        callOfWildEntity.setMaxHealth(20.0);
        callOfWildEntity.setHealth(callOfWildEntity.getMaxHealth());
        callOfWildEntity.setCustomName(LocaleLoader.getString("Taming.Summon.Name.Format", this.getPlayer().getName(), StringUtils.getPrettyEntityTypeString(EntityType.WOLF)));
    }

    private void spawnCat(Location spawnLocation, EntityType entityType) {
        LivingEntity callOfWildEntity = (LivingEntity)this.getPlayer().getWorld().spawnEntity(spawnLocation, entityType);
        this.applyMetaDataToCOTWEntity(callOfWildEntity);
        this.setBaseCOTWEntityProperties(callOfWildEntity);
        this.addToTracker(callOfWildEntity, CallOfTheWildType.CAT);
        if (callOfWildEntity instanceof Ocelot) {
            int numberOfTypes = Ocelot.Type.values().length;
            ((Ocelot)callOfWildEntity).setCatType(Ocelot.Type.values()[Misc.getRandom().nextInt(numberOfTypes)]);
        }
        ((Ageable)callOfWildEntity).setAdult();
        callOfWildEntity.setCustomName(LocaleLoader.getString("Taming.Summon.Name.Format", this.getPlayer().getName(), StringUtils.getPrettyEntityTypeString(entityType)));
        ParticleEffectUtils.playCallOfTheWildEffect(callOfWildEntity);
    }

    private void spawnHorse(Location spawnLocation) {
        LivingEntity callOfWildEntity = (LivingEntity)this.getPlayer().getWorld().spawnEntity(spawnLocation, EntityType.HORSE);
        this.applyMetaDataToCOTWEntity(callOfWildEntity);
        this.setBaseCOTWEntityProperties(callOfWildEntity);
        this.addToTracker(callOfWildEntity, CallOfTheWildType.HORSE);
        Horse horse = (Horse)callOfWildEntity;
        callOfWildEntity.setMaxHealth(15.0 + Misc.getRandom().nextDouble() * 15.0);
        callOfWildEntity.setHealth(callOfWildEntity.getMaxHealth());
        horse.setColor(Horse.Color.values()[Misc.getRandom().nextInt(Horse.Color.values().length)]);
        horse.setStyle(Horse.Style.values()[Misc.getRandom().nextInt(Horse.Style.values().length)]);
        horse.setJumpStrength(Math.max(mcMMO.p.getAdvancedConfig().getMinHorseJumpStrength(), Math.min(Math.min(Misc.getRandom().nextDouble(), Misc.getRandom().nextDouble()) * 2.0, mcMMO.p.getAdvancedConfig().getMaxHorseJumpStrength())));
        horse.setAdult();
        callOfWildEntity.setCustomName(LocaleLoader.getString("Taming.Summon.Name.Format", this.getPlayer().getName(), StringUtils.getPrettyEntityTypeString(EntityType.HORSE)));
        ParticleEffectUtils.playCallOfTheWildEffect(callOfWildEntity);
    }

    private void setBaseCOTWEntityProperties(LivingEntity callOfWildEntity) {
        ((Tameable)callOfWildEntity).setOwner((AnimalTamer)this.getPlayer());
        callOfWildEntity.setRemoveWhenFarAway(false);
    }

    private void applyMetaDataToCOTWEntity(LivingEntity summonedEntity) {
        MobMetadataUtils.flagMetadata(MobMetaFlagType.COTW_SUMMONED_MOB, summonedEntity);
    }

    public boolean isCOTWItem(@NotNull ItemStack itemStack) {
        return summoningItems.containsKey(itemStack.getType());
    }

    private int getAmountCurrentlySummoned(@NotNull CallOfTheWildType callOfTheWildType) {
        return mcMMO.getTransientEntityTracker().getActiveSummonsForPlayerOfType(this.getPlayer().getUniqueId(), callOfTheWildType);
    }

    private void addToTracker(@NotNull LivingEntity livingEntity, @NotNull CallOfTheWildType callOfTheWildType) {
        mcMMO.getTransientEntityTracker().addSummon(this.getPlayer().getUniqueId(), new TrackedTamingEntity(livingEntity, callOfTheWildType, this.getPlayer()));
    }

    public void cleanupAllSummons() {
        mcMMO.getTransientEntityTracker().cleanupPlayer(this.getPlayer());
    }
}

