/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.platform;

import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import com.gmail.nossr50.util.compat.CompatibilityManager;
import com.gmail.nossr50.util.platform.MinecraftGameVersion;
import com.gmail.nossr50.util.platform.Platform;
import com.gmail.nossr50.util.platform.PlatformBuilder;
import com.gmail.nossr50.util.platform.ServerSoftwareType;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformManager {
    protected Platform platform;

    public PlatformManager() {
        this.init();
    }

    private void init() {
        this.platform = this.loadPlatform();
    }

    public Platform getPlatform() {
        return this.platform;
    }

    @Nullable
    private Platform loadPlatform() {
        ServerSoftwareType serverSoftwareType = this.determinePlatformType();
        PlatformBuilder platformBuilder = new PlatformBuilder();
        MinecraftGameVersion gameVersion = this.determineGameVersion(Bukkit.getBukkitVersion());
        return platformBuilder.setMinecraftGameVersion(gameVersion).setSoftwareType(serverSoftwareType).build();
    }

    @Deprecated
    @NotNull
    private MinecraftGameVersion determineGameVersion(String platformVersionString) {
        int major = 0;
        int minor = 0;
        int patch = 0;
        LogUtils.debug(mcMMO.p.getLogger(), "Platform String: " + platformVersionString);
        Matcher versionMatch = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.(\\d+))?[-_].*").matcher(platformVersionString);
        if (versionMatch.find()) {
            major = Integer.parseInt(versionMatch.group(1));
            minor = Integer.parseInt(versionMatch.group(2));
            if (versionMatch.group(3) != null) {
                patch = Integer.parseInt(versionMatch.group(3));
            }
        }
        LogUtils.debug(mcMMO.p.getLogger(), "Minecraft version determined to be - " + major + "." + minor + "." + patch);
        return new MinecraftGameVersion(major, minor, patch);
    }

    @NotNull
    private ServerSoftwareType determinePlatformType() {
        if (Bukkit.getVersion().toLowerCase(Locale.ENGLISH).contains("paper")) {
            return ServerSoftwareType.PAPER;
        }
        if (Bukkit.getVersion().toLowerCase(Locale.ENGLISH).contains("spigot")) {
            return ServerSoftwareType.SPIGOT;
        }
        return ServerSoftwareType.CRAFT_BUKKIT;
    }

    public ServerSoftwareType getServerSoftware() {
        return this.platform.getServerSoftwareType();
    }

    public String getServerSoftwareStr() {
        return switch (this.getServerSoftware()) {
            case ServerSoftwareType.PAPER -> "Paper";
            case ServerSoftwareType.SPIGOT -> "Spigot";
            default -> "CraftBukkit";
        };
    }

    @Nullable
    public CompatibilityManager getCompatibilityManager() {
        return this.platform.getCompatibilityManager();
    }
}

