/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config;

import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import java.io.File;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Deprecated
public abstract class LegacyConfigLoader {
    @NotNull
    protected final File configFile;
    @NotNull
    protected final File dataFolder;
    @NotNull
    protected String fileName;
    protected YamlConfiguration config;

    public LegacyConfigLoader(@NotNull String relativePath, @NotNull String fileName, @NotNull File dataFolder) {
        this.fileName = fileName;
        this.dataFolder = dataFolder;
        this.configFile = new File(dataFolder, relativePath + File.separator + fileName);
        this.loadFile();
    }

    public LegacyConfigLoader(@NotNull String fileName, @NotNull File dataFolder) {
        this.fileName = fileName;
        this.dataFolder = dataFolder;
        this.configFile = new File(dataFolder, fileName);
        this.loadFile();
    }

    @VisibleForTesting
    public LegacyConfigLoader(@NotNull File file) {
        this.fileName = file.getName();
        this.dataFolder = file.getParentFile();
        this.configFile = new File(this.dataFolder, this.fileName);
        this.loadFile();
    }

    @Deprecated
    public LegacyConfigLoader(String relativePath, String fileName) {
        this.fileName = fileName;
        this.configFile = new File(mcMMO.p.getDataFolder(), relativePath + File.separator + fileName);
        this.dataFolder = mcMMO.p.getDataFolder();
        this.loadFile();
    }

    @Deprecated
    public LegacyConfigLoader(String fileName) {
        this.fileName = fileName;
        this.configFile = new File(mcMMO.p.getDataFolder(), fileName);
        this.dataFolder = mcMMO.p.getDataFolder();
        this.loadFile();
    }

    protected void loadFile() {
        if (!this.configFile.exists()) {
            LogUtils.debug(mcMMO.p.getLogger(), "Creating mcMMO " + this.fileName + " File...");
            try {
                mcMMO.p.saveResource(this.fileName, false);
            }
            catch (IllegalArgumentException ex) {
                mcMMO.p.saveResource(this.configFile.getParentFile().getName() + File.separator + this.fileName, false);
            }
        } else {
            LogUtils.debug(mcMMO.p.getLogger(), "Loading mcMMO " + this.fileName + " File...");
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    protected abstract void loadKeys();

    protected boolean validateKeys() {
        return true;
    }

    protected boolean noErrorsInConfig(List<String> issues) {
        for (String issue : issues) {
            mcMMO.p.getLogger().warning(issue);
        }
        return issues.isEmpty();
    }

    protected void validate() {
        if (this.validateKeys()) {
            LogUtils.debug(mcMMO.p.getLogger(), "No errors found in " + this.fileName + "!");
        } else {
            mcMMO.p.getLogger().warning("Errors were found in " + this.fileName + "! mcMMO was disabled!");
            mcMMO.p.getServer().getPluginManager().disablePlugin((Plugin)mcMMO.p);
            mcMMO.p.noErrorsInConfigFiles = false;
        }
    }

    public File getFile() {
        return this.configFile;
    }

    public void backup() {
        mcMMO.p.getLogger().warning("You are using an old version of the " + this.fileName + " file.");
        mcMMO.p.getLogger().warning("Your old file has been renamed to " + this.fileName + ".old and has been replaced by an updated version.");
        this.configFile.renameTo(new File(this.configFile.getPath() + ".old"));
        if (mcMMO.p.getResource(this.fileName) != null) {
            mcMMO.p.saveResource(this.fileName, true);
        }
        mcMMO.p.getLogger().warning("Reloading " + this.fileName + " with new values...");
        this.loadFile();
        this.loadKeys();
    }
}

