/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.maces.MacesManager;
import com.gmail.nossr50.util.skills.CombatUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.text.TextComponentFactory;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;

public class MacesCommand
extends SkillCommand {
    String crippleChanceToApply;
    String crippleChanceToApplyLucky;
    String crippleLengthAgainstPlayers;
    String crippleLengthAgainstMobs;

    public MacesCommand() {
        super(PrimarySkillType.MACES);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue) {
        if (SkillUtils.canUseSubskill(player, SubSkillType.MACES_CRIPPLE)) {
            int crippleRank = RankUtils.getRank(player, SubSkillType.MACES_CRIPPLE);
            this.crippleLengthAgainstPlayers = String.valueOf((double)MacesManager.getCrippleTickDuration(true) / 20.0);
            this.crippleLengthAgainstMobs = String.valueOf((double)MacesManager.getCrippleTickDuration(false) / 20.0);
            this.crippleChanceToApply = String.valueOf(mcMMO.p.getAdvancedConfig().getCrippleChanceToApplyOnHit(crippleRank) + "%");
            this.crippleChanceToApplyLucky = String.valueOf(mcMMO.p.getAdvancedConfig().getCrippleChanceToApplyOnHit(crippleRank) * 1.33);
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (SkillUtils.canUseSubskill(player, SubSkillType.MACES_MACES_LIMIT_BREAK)) {
            messages.add(this.getStatMessage(SubSkillType.MACES_MACES_LIMIT_BREAK, String.valueOf(CombatUtils.getLimitBreakDamageAgainstQuality(player, SubSkillType.MACES_MACES_LIMIT_BREAK, 1000))));
        }
        if (SkillUtils.canUseSubskill(player, SubSkillType.MACES_CRIPPLE)) {
            messages.add(this.getStatMessage(SubSkillType.MACES_CRIPPLE, this.crippleChanceToApply) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.crippleChanceToApplyLucky) : ""));
            messages.add(this.getStatMessage(true, true, SubSkillType.MACES_CRIPPLE, this.crippleLengthAgainstPlayers, this.crippleLengthAgainstMobs));
        }
        if (SkillUtils.canUseSubskill(player, SubSkillType.MACES_CRUSH)) {
            messages.add(this.getStatMessage(SubSkillType.MACES_CRUSH, String.valueOf(this.mmoPlayer.getMacesManager().getCrushDamage())));
        }
        return messages;
    }

    @Override
    protected List<Component> getTextComponents(Player player) {
        ArrayList<Component> textComponents = new ArrayList<Component>();
        TextComponentFactory.getSubSkillTextComponents(player, textComponents, PrimarySkillType.MACES);
        return textComponents;
    }
}

