/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config;

import com.gmail.nossr50.config.BukkitConfig;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.subskills.AbstractSubSkill;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RankConfig
extends BukkitConfig {
    private static RankConfig instance;

    public RankConfig() {
        super("skillranks.yml");
        this.validate();
        instance = this;
    }

    public static RankConfig getInstance() {
        if (instance == null) {
            return new RankConfig();
        }
        return instance;
    }

    @Override
    protected void loadKeys() {
    }

    @Override
    protected boolean validateKeys() {
        ArrayList<String> reason = new ArrayList<String>();
        this.checkKeys(reason);
        return this.noErrorsInConfig(reason);
    }

    public int getSubSkillUnlockLevel(SubSkillType subSkillType, int rank) {
        String key = subSkillType.getRankConfigAddress();
        return this.findRankByRootAddress(rank, key);
    }

    public int getSubSkillUnlockLevel(SubSkillType subSkillType, int rank, boolean retroMode) {
        String key = this.getRankAddressKey(subSkillType, rank, retroMode);
        return this.config.getInt(key, this.defaultYamlConfig.getInt(key));
    }

    public int getSubSkillUnlockLevel(AbstractSubSkill abstractSubSkill, int rank) {
        String key = abstractSubSkill.getPrimaryKeyName() + "." + abstractSubSkill.getConfigKeyName();
        return this.findRankByRootAddress(rank, key);
    }

    private int findRankByRootAddress(int rank, String key) {
        String scalingKey = mcMMO.p.getGeneralConfig().getIsRetroMode() ? ".RetroMode." : ".Standard.";
        String targetRank = "Rank_" + rank;
        key = (String)key + scalingKey;
        key = (String)key + targetRank;
        return this.config.getInt((String)key);
    }

    public String getRankAddressKey(SubSkillType subSkillType, int rank, boolean retroMode) {
        Object key = subSkillType.getRankConfigAddress();
        String scalingKey = retroMode ? ".RetroMode." : ".Standard.";
        String targetRank = "Rank_" + rank;
        key = (String)key + scalingKey;
        key = (String)key + targetRank;
        return key;
    }

    public String getRankAddressKey(AbstractSubSkill subSkillType, int rank, boolean retroMode) {
        String key = subSkillType.getPrimaryKeyName() + "." + subSkillType.getConfigKeyName();
        String scalingKey = retroMode ? ".RetroMode." : ".Standard.";
        String targetRank = "Rank_" + rank;
        key = key + scalingKey;
        key = key + targetRank;
        return key;
    }

    private void resetRankValue(@NotNull SubSkillType subSkillType, int rank, boolean retroMode) {
        String key = this.getRankAddressKey(subSkillType, rank, retroMode);
        int defaultValue = this.defaultYamlConfig.getInt(key);
        this.config.set(key, (Object)defaultValue);
        LogUtils.debug(mcMMO.p.getLogger(), key + " SET -> " + defaultValue);
    }

    private void checkKeys(@NotNull List<String> reasons) {
        HashSet<SubSkillType> badSkillSetup = new HashSet<SubSkillType>();
        this.checkConfig(reasons, badSkillSetup, true);
        this.checkConfig(reasons, badSkillSetup, false);
        if (badSkillSetup.isEmpty()) {
            return;
        }
        LogUtils.debug(mcMMO.p.getLogger(), "(FIXING CONFIG) mcMMO is correcting a few mistakes found in your skill rank config setup");
        for (SubSkillType subSkillType : badSkillSetup) {
            LogUtils.debug(mcMMO.p.getLogger(), "(FIXING CONFIG) Resetting rank config settings for skill named - " + subSkillType.toString());
            this.fixBadEntries(subSkillType);
        }
    }

    private void checkConfig(@NotNull List<String> reasons, @NotNull HashSet<SubSkillType> badSkillSetup, boolean retroMode) {
        for (SubSkillType subSkillType : SubSkillType.values()) {
            int curRank = 0;
            int prevRank = 0;
            for (int x = 0; x < subSkillType.getNumRanks(); ++x) {
                int index = x + 1;
                if (curRank > 0) {
                    prevRank = curRank;
                }
                if ((curRank = this.getSubSkillUnlockLevel(subSkillType, index, retroMode)) < 0) {
                    reasons.add("(CONFIG ISSUE) " + String.valueOf((Object)subSkillType) + " should not have any ranks that require a negative level!");
                    badSkillSetup.add(subSkillType);
                    continue;
                }
                if (prevRank <= curRank) continue;
                LogUtils.debug(mcMMO.p.getLogger(), "(CONFIG ISSUE) You have the ranks for the subskill " + String.valueOf((Object)subSkillType) + " set up poorly, sequential ranks should have ascending requirements");
                badSkillSetup.add(subSkillType);
            }
        }
    }

    private void fixBadEntries(@NotNull SubSkillType subSkillType) {
        for (int x = 0; x < subSkillType.getNumRanks(); ++x) {
            int index = x + 1;
            this.resetRankValue(subSkillType, index, true);
            this.resetRankValue(subSkillType, index, false);
        }
        this.updateFile();
    }
}

