/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.player;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.commands.McScoreboardKeepTask;
import com.gmail.nossr50.util.CancellableRunnable;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.LogUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlayerProfileLoadingTask
extends CancellableRunnable {
    private final Player player;
    private int attempt = 0;

    public PlayerProfileLoadingTask(Player player) {
        this.player = player;
    }

    private PlayerProfileLoadingTask(Player player, int attempt) {
        this.player = player;
        this.attempt = attempt;
    }

    @Override
    public void run() {
        if (Misc.isNPCIncludingVillagers((Entity)this.player)) {
            return;
        }
        if (!this.player.isOnline()) {
            LogUtils.debug(mcMMO.p.getLogger(), "Aborting profile loading recovery for " + this.player.getName() + " - player logged out");
            return;
        }
        PlayerProfile profile = mcMMO.getDatabaseManager().loadPlayerProfile((OfflinePlayer)this.player);
        if (!profile.isLoaded()) {
            LogUtils.debug(mcMMO.p.getLogger(), "Creating new data for player: " + this.player.getName());
            profile = mcMMO.getDatabaseManager().newUser(this.player);
        }
        if (profile.isLoaded()) {
            mcMMO.p.getFoliaLib().getScheduler().runAtEntity((Entity)this.player, new ApplySuccessfulProfile(new McMMOPlayer(this.player, profile)));
            EventUtils.callPlayerProfileLoadEvent(this.player, profile);
            return;
        }
        if (this.attempt >= 3) {
            mcMMO.p.getLogger().severe(LocaleLoader.getString("Profile.Loading.FailureNotice", this.player.getName(), String.valueOf(this.attempt)));
            mcMMO.p.getServer().broadcast(LocaleLoader.getString("Profile.Loading.FailureNotice", this.player.getName()), "bukkit.broadcast.admin");
            this.player.sendMessage(LocaleLoader.getString("Profile.Loading.FailurePlayer", String.valueOf(this.attempt)).split("\n"));
        }
        ++this.attempt;
        mcMMO.p.getFoliaLib().getScheduler().runLaterAsync(new PlayerProfileLoadingTask(this.player, this.attempt), 100L + (long)this.attempt * 100L);
    }

    private class ApplySuccessfulProfile
    extends CancellableRunnable {
        private final McMMOPlayer mcMMOPlayer;

        private ApplySuccessfulProfile(McMMOPlayer mcMMOPlayer) {
            this.mcMMOPlayer = mcMMOPlayer;
        }

        @Override
        public void run() {
            if (!PlayerProfileLoadingTask.this.player.isOnline()) {
                mcMMO.p.getLogger().info("Aborting profile loading recovery for " + PlayerProfileLoadingTask.this.player.getName() + " - player logged out");
                return;
            }
            this.mcMMOPlayer.getProfile().updateLastLogin();
            this.mcMMOPlayer.setupPartyData();
            UserManager.track(this.mcMMOPlayer);
            this.mcMMOPlayer.actualizeRespawnATS();
            if (mcMMO.p.getGeneralConfig().getScoreboardsEnabled()) {
                ScoreboardManager.setupPlayer(PlayerProfileLoadingTask.this.player);
                if (mcMMO.p.getGeneralConfig().getShowStatsAfterLogin()) {
                    ScoreboardManager.enablePlayerStatsScoreboard(PlayerProfileLoadingTask.this.player);
                    mcMMO.p.getFoliaLib().getScheduler().runAtEntityLater((Entity)PlayerProfileLoadingTask.this.player, new McScoreboardKeepTask(PlayerProfileLoadingTask.this.player), 20L);
                }
            }
            if (mcMMO.p.getGeneralConfig().getShowProfileLoadedMessage()) {
                PlayerProfileLoadingTask.this.player.sendMessage(LocaleLoader.getString("Profile.Loading.Success"));
            }
        }
    }
}

